/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import com.imcode.db.DataSourceDatabase;
import com.imcode.db.Database;
import com.imcode.imcms.db.DatabaseUtils;
import com.imcode.imcms.db.DefaultProcedureExecutor;
import com.imcode.imcms.db.ImcmsDatabaseCreator;
import com.imcode.imcms.db.StartupDatabaseUpgrade;
import com.imcode.imcms.util.l10n.CachingLocalizedMessageProvider;
import com.imcode.imcms.util.l10n.ImcmsPrefsLocalizedMessageProvider;
import imcode.server.DatabaseSanityCheck;
import imcode.server.DefaultImcmsServices;
import imcode.server.ImcmsServices;
import imcode.server.SanityCheck;
import imcode.util.CachingFileLoader;
import imcode.util.Prefs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public class Imcms {
    private static final String SERVER_PROPERTIES_FILENAME = "server.properties";
    public static final String ASCII_ENCODING = "US-ASCII";
    public static final String ISO_8859_1_ENCODING = "ISO-8859-1";
    public static final String UTF_8_ENCODING = "UTF-8";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final Logger LOG = Logger.getLogger((String)Imcms.class.getName());
    private static ImcmsServices services;
    private static BasicDataSource apiDataSource;
    private static BasicDataSource dataSource;
    private static File path;

    private Imcms() {
    }

    public static synchronized ImcmsServices getServices() {
        if (null == services) {
            Imcms.start();
        }
        return services;
    }

    public static void setPath(File path) {
        Imcms.path = path;
    }

    public static File getPath() {
        return path;
    }

    public static synchronized void start() throws StartupException {
        try {
            services = Imcms.createServices();
        }
        catch (Exception e) {
            throw new StartupException("imCMS could not be started. Please see the log file in WEB-INF/logs/ for details.", e);
        }
    }

    private static synchronized ImcmsServices createServices() throws Exception {
        Properties serverprops = Imcms.getServerProperties();
        LOG.debug((Object)"Creating main DataSource.");
        Database database = Imcms.createDatabase(serverprops);
        CachingLocalizedMessageProvider localizedMessageProvider = new CachingLocalizedMessageProvider(new ImcmsPrefsLocalizedMessageProvider());
        InputStreamReader initScriptReader = new InputStreamReader((InputStream)new FileInputStream(new File(Imcms.getPath(), "WEB-INF/sql/init.sql")), "UTF-8");
        org.apache.ddlutils.model.Database wantedDdl = DatabaseUtils.getWantedDdl();
        StartupDatabaseUpgrade upgrade = new StartupDatabaseUpgrade(wantedDdl, new ImcmsDatabaseCreator(initScriptReader, localizedMessageProvider));
        upgrade.upgrade(database);
        Imcms.sanityCheckDatabase(database, wantedDdl);
        CachingFileLoader fileLoader = new CachingFileLoader();
        return new DefaultImcmsServices(database, serverprops, localizedMessageProvider, fileLoader, new DefaultProcedureExecutor(database, fileLoader));
    }

    private static void sanityCheckDatabase(Database database, org.apache.ddlutils.model.Database wantedDdl) {
        DatabaseSanityCheck databaseSanityCheck = new DatabaseSanityCheck(database, wantedDdl);
        Collection<SanityCheck.Problem> problems = databaseSanityCheck.execute();
        for (SanityCheck.Problem problem : problems) {
            if (SanityCheck.Problem.Severity.ERROR == problem.getSeverity()) {
                LOG.error((Object)problem.getDescription());
                continue;
            }
            if (SanityCheck.Problem.Severity.WARNING == problem.getSeverity()) {
                LOG.warn((Object)problem.getDescription());
                continue;
            }
            if (SanityCheck.Problem.Severity.UNKNOWN != problem.getSeverity()) continue;
            LOG.debug((Object)problem.getDescription());
        }
    }

    private static Database createDatabase(Properties serverprops) {
        dataSource = Imcms.createDataSource(serverprops);
        return new DataSourceDatabase((DataSource)dataSource);
    }

    public static synchronized DataSource getApiDataSource() {
        if (null == apiDataSource) {
            Properties serverprops = Imcms.getServerProperties();
            LOG.debug((Object)"Creating API DataSource.");
            apiDataSource = Imcms.createDataSource(serverprops);
        }
        return apiDataSource;
    }

    private static Properties getServerProperties() {
        try {
            return Prefs.getProperties(SERVER_PROPERTIES_FILENAME);
        }
        catch (IOException e) {
            LOG.fatal((Object)"Failed to initialize imCMS", (Throwable)e);
            throw new UnhandledException((Throwable)e);
        }
    }

    private static BasicDataSource createDataSource(Properties props) {
        String jdbcDriver = props.getProperty("JdbcDriver");
        String jdbcUrl = props.getProperty("JdbcUrl");
        String user = props.getProperty("User");
        String password = props.getProperty("Password");
        int maxConnectionCount = Integer.parseInt(props.getProperty("MaxConnectionCount"));
        LOG.debug((Object)("JdbcDriver = " + jdbcDriver));
        LOG.debug((Object)("JdbcUrl = " + jdbcUrl));
        LOG.debug((Object)("User = " + user));
        LOG.debug((Object)("MaxConnectionCount = " + maxConnectionCount));
        return Imcms.createDataSource(jdbcDriver, jdbcUrl, user, password, maxConnectionCount);
    }

    public static synchronized void restart() {
        Imcms.stop();
        Imcms.start();
    }

    public static void stop() {
        if (null != apiDataSource) {
            try {
                LOG.debug((Object)"Closing API DataSource.");
                apiDataSource.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        if (null != dataSource) {
            try {
                LOG.debug((Object)"Closing main DataSource.");
                dataSource.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        Prefs.flush();
    }

    private static void logDatabaseVersion(BasicDataSource basicDataSource) throws SQLException {
        Connection connection = basicDataSource.getConnection();
        DatabaseMetaData metaData = connection.getMetaData();
        LOG.info((Object)("Database product version = " + metaData.getDatabaseProductVersion()));
        connection.close();
    }

    public static BasicDataSource createDataSource(String jdbcDriver, String jdbcUrl, String user, String password, int maxConnectionCount) {
        try {
            BasicDataSource basicDataSource = new BasicDataSource();
            basicDataSource.setDriverClassName(jdbcDriver);
            basicDataSource.setUsername(user);
            basicDataSource.setPassword(password);
            basicDataSource.setUrl(jdbcUrl);
            basicDataSource.setMaxActive(maxConnectionCount);
            basicDataSource.setMaxIdle(maxConnectionCount);
            basicDataSource.setDefaultAutoCommit(true);
            basicDataSource.setPoolPreparedStatements(true);
            Imcms.logDatabaseVersion(basicDataSource);
            return basicDataSource;
        }
        catch (SQLException ex) {
            String message = "Could not connect to database " + jdbcUrl + " with driver " + jdbcDriver + ": " + ex.getMessage() + " Error code: " + ex.getErrorCode() + " SQL State: " + ex.getSQLState();
            LOG.fatal((Object)message, (Throwable)ex);
            throw new RuntimeException(message, ex);
        }
    }

    public static class StartupException
    extends RuntimeException {
        public StartupException(String message, Exception e) {
            super(message, e);
        }
    }
}

