/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.util.rss.imcms;

import com.imcode.imcms.api.Document;
import com.imcode.imcms.util.rss.dc.DublinCoreEntity;
import com.imcode.imcms.util.rss.dc.DublinCoreTerms;
import imcode.util.Utility;
import java.util.Date;

public class DocumentDublinCoreTerms
implements DublinCoreTerms {
    private final String urlRoot;
    private Document document;

    public DocumentDublinCoreTerms(String urlRoot, Document document) {
        this.urlRoot = urlRoot;
        this.document = document;
    }

    public Date getIssued() {
        return this.document.getPublicationStartDatetime();
    }

    public Date getModified() {
        return this.document.getModifiedDatetime();
    }

    public Date getCreated() {
        return this.document.getCreatedDatetime();
    }

    public DublinCoreEntity getCreator() {
        return new DublinCoreEntity(){

            public String getEmailAddress() {
                return DocumentDublinCoreTerms.this.document.getCreator().getEmailAddress();
            }

            public String getName() {
                return DocumentDublinCoreTerms.this.document.getCreator().getFirstName() + " " + DocumentDublinCoreTerms.this.document.getCreator().getLastName();
            }
        };
    }

    public String getDescription() {
        return this.document.getMenuText();
    }

    public String getTitle() {
        return this.document.getHeadline();
    }

    public String getIdentifer() {
        return this.urlRoot + Utility.getContextRelativePathToDocumentWithName(this.document.getName());
    }
}

