/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.test.external;

import com.imcode.db.DataSourceDatabase;
import com.imcode.db.Database;
import com.imcode.imcms.db.ImcmsDatabaseCreator;
import com.imcode.imcms.db.StartupDatabaseUpgrade;
import com.imcode.imcms.db.refactoring.DatabasePlatform;
import com.imcode.imcms.util.EmptyEnumeration;
import com.imcode.imcms.util.l10n.LocalizedMessageProvider;
import imcode.server.Imcms;
import imcode.util.ShouldNotBeThrownException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.ddlutils.io.DatabaseIO;

public class TestStartupDatabaseUpgrade
extends TestCase {
    public void testCreateMysql() throws Exception {
        String jdbcDriver = "com.mysql.jdbc.Driver";
        String host = "localhost";
        String baseUrl = "jdbc:mysql://" + host + ":3306/";
        String jdbcUser = "root";
        String jdbcPassword = "";
        String databaseName = "imcmstest";
        this.doTest(jdbcDriver, baseUrl, jdbcUser, jdbcPassword, databaseName);
    }

    public void testCreateMssql() throws Exception {
        String jdbcDriver = "net.sourceforge.jtds.jdbc.Driver";
        String host = "localhost";
        String baseUrl = "jdbc:jtds:sqlserver://" + host + ":1433/";
        String jdbcUser = "sa";
        String jdbcPassword = "";
        String databaseName = "imcmstest";
        this.doTest(jdbcDriver, baseUrl, jdbcUser, jdbcPassword, databaseName);
    }

    private void doTest(String jdbcDriver, String baseUrl, String jdbcUser, String jdbcPassword, String databaseName) throws IOException {
        File root = new File("tmp/test/");
        FileUtils.deleteDirectory((File)root);
        Imcms.setPath(root);
        File templatesDirectory = new File(root, "WEB-INF/templates/text");
        templatesDirectory.mkdirs();
        File templateFile = new File(templatesDirectory, "1.html");
        templateFile.createNewFile();
        DataSourceDatabase database = this.createDataSourceDatabase(jdbcDriver, baseUrl, jdbcUser, jdbcPassword);
        DatabasePlatform databasePlatform = DatabasePlatform.getInstance((Database)database);
        databasePlatform.dropDatabase(databaseName);
        databasePlatform.createDatabase(databaseName);
        database = this.createDataSourceDatabase(jdbcDriver, baseUrl + databaseName, jdbcUser, jdbcPassword);
        ImcmsDatabaseCreator databaseCreator = this.createDatabaseCreator();
        databaseCreator.createDatabase((Database)database, this.getOldDdl());
        org.apache.ddlutils.model.Database wantedDdl = this.getWantedDdl();
        new StartupDatabaseUpgrade(wantedDdl, databaseCreator).upgrade((Database)database);
        TestStartupDatabaseUpgrade.assertFalse((boolean)templateFile.exists());
        TestStartupDatabaseUpgrade.assertTrue((boolean)new File(templatesDirectory, "demo_test.html").exists());
    }

    private org.apache.ddlutils.model.Database getOldDdl() {
        return this.getDdl(this.getOldDdlXmlReader());
    }

    private Reader getOldDdlXmlReader() {
        try {
            return new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/com/imcode/imcms/test/external/imcms-ddl-3.0.xml"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ShouldNotBeThrownException(e);
        }
    }

    private org.apache.ddlutils.model.Database getWantedDdl() throws IOException {
        return this.getDdl(new StringReader(this.getDdlXml()));
    }

    private ImcmsDatabaseCreator createDatabaseCreator() {
        try {
            InputStreamReader initScriptReader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/com/imcode/imcms/test/external/imcms-init-3.0.sql"), "UTF-8");
            return new ImcmsDatabaseCreator(initScriptReader, new LocalizedMessageProvider(){

                public ResourceBundle getResourceBundle(String languageIso639_2) {
                    return new NullResourceBundle();
                }
            });
        }
        catch (UnsupportedEncodingException e) {
            throw new ShouldNotBeThrownException(e);
        }
    }

    private org.apache.ddlutils.model.Database getDdl(Reader reader) {
        DatabaseIO io = new DatabaseIO();
        io.setValidateXml(false);
        return io.read(reader);
    }

    private DataSourceDatabase createDataSourceDatabase(String jdbcDriver, String jdbcUrl, String jdbcUser, String jdbcPassword) {
        return new DataSourceDatabase((DataSource)Imcms.createDataSource(jdbcDriver, jdbcUrl, jdbcUser, jdbcPassword, 20));
    }

    private String getDdlXml() throws IOException {
        File[] tableFiles;
        StringWriter ddlXmlWriter = new StringWriter();
        ddlXmlWriter.write("<database name=\"imcms\">\n");
        for (File tableFile : tableFiles = new File("sql/tables/").listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".tab");
            }
        })) {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(tableFile), "iso-8859-1");
            CopyUtils.copy((Reader)reader, (Writer)ddlXmlWriter);
        }
        ddlXmlWriter.write("</database>");
        return ddlXmlWriter.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullResourceBundle
    extends ResourceBundle {
        private NullResourceBundle() {
        }

        @Override
        protected Object handleGetObject(String key) {
            return "";
        }

        @Override
        public Enumeration<String> getKeys() {
            return new EmptyEnumeration<String>();
        }
    }
}

