/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.DeleteWhereColumnsEqualDatabaseCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.handlers.ObjectFromFirstRowResultSetHandler;
import com.imcode.db.handlers.ObjectFromRowFactory;
import com.imcode.imcms.db.StringArrayArrayResultSetHandler;
import com.imcode.imcms.db.StringFromRowFactory;
import com.imcode.imcms.util.l10n.ImcmsPrefsLocalizedMessageProvider;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.log4j.Logger;

public class AdminSection
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)AdminSection.class.getName());
    private static final String ADMIN_TEMPLATE = "sections/admin_section.html";
    private static final String ADD_TEMPLATE = "sections/admin_section_add.html";
    private static final String NAME_TEMPLATE = "sections/admin_section_name.html";
    private static final String DELETE_TEMPLATE = "sections/admin_section_delete.html";
    private static final String LINE_TEMPLATE = "sections/admin_section_line.html";
    private static final String DELETE_CONFIRM_TEMPLATE = "sections/admin_section_delete_confirm.html";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        Utility.setDefaultHtmlContentType(res);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            log.debug((Object)"the user wasn't a administrator so lets get rid of him");
            res.sendRedirect("StartDoc");
            return;
        }
        ServletOutputStream out = res.getOutputStream();
        out.print(imcref.getAdminTemplate(ADMIN_TEMPLATE, user, null));
        out.flush();
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String[][] section_arr;
        Object[] parameters;
        String section_id;
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            log.debug((Object)"the user wasn't a administrator so lets get rid of him");
            res.sendRedirect("StartDoc");
            return;
        }
        StringBuffer htmlToSend = new StringBuffer();
        if (req.getParameter("add_section") != null) {
            String new_section_name = req.getParameter("new_section_name") == null ? "" : req.getParameter("new_section_name").trim();
            Object[] parameters2 = new String[]{};
            String[][] section_arr2 = (String[][])imcref.getProcedureExecutor().executeProcedure("SectionGetAllCount", parameters2, new StringArrayArrayResultSetHandler());
            Vector<String> vec = new Vector<String>();
            String errormsg = "";
            if (!new_section_name.equals("")) {
                boolean section_exists = false;
                for (int i = 0; i < section_arr2.length; ++i) {
                    if (!new_section_name.equals(section_arr2[i][1])) continue;
                    section_exists = true;
                    Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                    errormsg = langproperties.getProperty("error/servlet/AdminSection/section_exists");
                    break;
                }
                if (!section_exists) {
                    Object[] parameters3 = new String[]{new_section_name};
                    imcref.getProcedureExecutor().executeUpdateProcedure("SectionAdd", parameters3);
                    imcref.getDocumentMapper().initSections();
                    Object[] parameters1 = new String[]{};
                    section_arr2 = (String[][])imcref.getProcedureExecutor().executeProcedure("SectionGetAllCount", parameters1, new StringArrayArrayResultSetHandler());
                }
            }
            vec.add("#errormsg#");
            vec.add(errormsg);
            vec.add("#section_list#");
            vec.add(this.createOptionList(section_arr2, user, null));
            htmlToSend.append(imcref.getAdminTemplate(ADD_TEMPLATE, user, vec));
        }
        if (req.getParameter("edit_section") != null) {
            String new_section = req.getParameter("new_section_name") == null ? "" : req.getParameter("new_section_name").trim();
            String string = section_id = req.getParameter("section_list") == null ? "-1" : req.getParameter("section_list");
            if (!new_section.equals("") && !section_id.equals("-1")) {
                parameters = new String[]{section_id, new_section};
                imcref.getProcedureExecutor().executeUpdateProcedure("SectionChangeName", parameters);
                imcref.getDocumentMapper().initSections();
            }
            Object[] parameters1 = new String[]{};
            section_arr = (String[][])imcref.getProcedureExecutor().executeProcedure("SectionGetAllCount", parameters1, new StringArrayArrayResultSetHandler());
            Vector<String> vec = new Vector<String>();
            vec.add("#section_list#");
            vec.add(this.createOptionList(section_arr, user, null));
            htmlToSend.append(imcref.getAdminTemplate(NAME_TEMPLATE, user, vec));
        }
        if (req.getParameter("delete_section_confirm") != null) {
            String new_sections = req.getParameter("new_section_confirm");
            String del_section = req.getParameter("delete_section");
            if (del_section == null || new_sections == null) {
                log.debug((Object)"new_section_confirm or delete_section was null so return");
                return;
            }
            if (new_sections.equals("-1")) {
                this.deleteSection(imcref, del_section);
            } else {
                parameters = new String[]{new_sections, del_section};
                imcref.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("update meta_section set section_id = ? where section_id = ?", parameters));
                this.deleteSection(imcref, del_section);
            }
        }
        if (req.getParameter("delete_section") != null) {
            boolean got_confirm_page = false;
            String string = section_id = req.getParameter("section_list") == null ? "-1" : req.getParameter("section_list");
            if (!section_id.equals("-1")) {
                parameters = new String[]{section_id};
                String doc_nrs = (String)imcref.getProcedureExecutor().executeProcedure("SectionCount", parameters, (ResultSetHandler)new ObjectFromFirstRowResultSetHandler((ObjectFromRowFactory)new StringFromRowFactory()));
                int doc_int = 0;
                if (doc_nrs != null) {
                    try {
                        doc_int = Integer.parseInt(doc_nrs);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if (doc_int > 0) {
                    Object[] parameters1 = new String[]{};
                    String[][] section_arr3 = (String[][])imcref.getProcedureExecutor().executeProcedure("SectionGetAllCount", parameters1, new StringArrayArrayResultSetHandler());
                    Vector<String> vec = new Vector<String>();
                    vec.add("#section_list#");
                    vec.add(this.createOptionList(section_arr3, user, section_id));
                    vec.add("#docs#");
                    vec.add(doc_nrs);
                    vec.add("#delete_section#");
                    vec.add(section_id);
                    htmlToSend.append(imcref.getAdminTemplate(DELETE_CONFIRM_TEMPLATE, user, vec));
                    got_confirm_page = true;
                } else {
                    this.deleteSection(imcref, section_id);
                }
            }
            if (!got_confirm_page) {
                parameters = new String[]{};
                section_arr = (String[][])imcref.getProcedureExecutor().executeProcedure("SectionGetAllCount", parameters, new StringArrayArrayResultSetHandler());
                Vector<String> vec = new Vector<String>();
                vec.add("#section_list#");
                vec.add(this.createOptionList(section_arr, user, null));
                htmlToSend.append(imcref.getAdminTemplate(DELETE_TEMPLATE, user, vec));
            }
        }
        if (htmlToSend.length() == 0) {
            this.doGet(req, res);
            return;
        }
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(htmlToSend.toString());
        out.flush();
        out.close();
    }

    private void deleteSection(ImcmsServices imcref, String del_section) {
        imcref.getDatabase().execute((DatabaseCommand)new DeleteWhereColumnsEqualDatabaseCommand("meta_section", "section_id", (Object)del_section));
        imcref.getDatabase().execute((DatabaseCommand)new DeleteWhereColumnsEqualDatabaseCommand("sections", "section_id", (Object)del_section));
        imcref.getDocumentMapper().initSections();
    }

    private String createOptionList(String[][] arr, UserDomainObject user, String not_id) {
        ImcmsServices imcref = Imcms.getServices();
        StringBuffer buff = new StringBuffer("");
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                if (not_id != null && not_id.equals(arr[i][0])) continue;
                Vector<String> vec = new Vector<String>();
                vec.add("#section_id#");
                vec.add(arr[i][0]);
                vec.add("#section_name#");
                vec.add(arr[i][1]);
                vec.add("#docs#");
                vec.add(arr[i][2]);
                buff.append(imcref.getAdminTemplate(LINE_TEMPLATE, user, vec));
            }
        }
        return buff.toString();
    }
}

