/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.db.Database;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.mapping.ProfileMapper;
import imcode.server.Imcms;
import imcode.server.document.Profile;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class AdminProfiles
extends HttpServlet {
    private Database getDatabase() {
        return Imcms.getServices().getDatabase();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if ("/list".equals(pathInfo)) {
            this.list(request, response);
        } else if ("/edit".equals(pathInfo)) {
            this.edit(request, response, new ProfileMapper.SimpleProfile("", "", ""));
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        ProfileMapper profileMapper = this.getProfileMapper();
        if ("/list".equals(pathInfo)) {
            if (Parameter.BACK.in(request)) {
                response.sendRedirect(request.getContextPath() + "/servlet/AdminManager");
                return;
            }
            String editId = Parameter.EDIT_PREFIX.suffixFrom(request);
            if (null != editId) {
                this.edit(request, response, (Profile)profileMapper.get(editId));
                return;
            }
            String deleteId = Parameter.DELETE_PREFIX.suffixFrom(request);
            if (null != deleteId) {
                profileMapper.delete(deleteId);
            }
            if (Parameter.NEW_PROFILE.in(request)) {
                this.edit(request, response, new ProfileMapper.SimpleProfile("", "", ""));
                return;
            }
            this.list(request, response);
        } else if ("/edit".equals(pathInfo)) {
            if (Parameter.BACK.in(request)) {
                response.sendRedirect(request.getContextPath() + "/imcms/admin/profile/list");
                return;
            }
            String id = Parameter.PROFILE_ID.from(request);
            String name = Parameter.PROFILE_NAME.from(request);
            String documentName = Parameter.PROFILE_DOCUMENT_NAME.from(request);
            if (null == ContentManagementSystem.fromRequest((ServletRequest)request).getDocumentService().getDocument(documentName)) {
                this.edit(request, response, new ProfileMapper.SimpleProfile(id, name, ""));
                return;
            }
            if (StringUtils.isNotBlank((String)id)) {
                profileMapper.update(new ProfileMapper.SimpleProfile(id, name, documentName));
            } else {
                profileMapper.create(new ProfileMapper.SimpleProfile(null, name, documentName));
            }
            this.list(request, response);
        }
    }

    private void edit(HttpServletRequest request, HttpServletResponse response, Profile profile) throws ServletException, IOException {
        request.setAttribute("profile", (Object)profile);
        request.getRequestDispatcher("/WEB-INF/jsp/imcms/profile/edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void list(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        List profiles = this.getProfileMapper().getAll();
        request.setAttribute("profiles", profiles);
        request.getRequestDispatcher("/WEB-INF/jsp/imcms/profile/list.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private ProfileMapper getProfileMapper() {
        return new ProfileMapper(this.getDatabase());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parameter {
        EDIT_PREFIX,
        DELETE_PREFIX,
        PROFILE_ID,
        PROFILE_NAME,
        PROFILE_DOCUMENT_NAME,
        NEW_PROFILE,
        BACK;


        String from(HttpServletRequest request) {
            return request.getParameter(this.toString());
        }

        public String suffixFrom(HttpServletRequest request) {
            Map parameterMap = request.getParameterMap();
            for (String parameterName : parameterMap.keySet()) {
                String prefix;
                if (!parameterName.startsWith(prefix = this.toString())) continue;
                return parameterName.substring(prefix.length());
            }
            return null;
        }

        public boolean in(HttpServletRequest request) {
            return null != this.from(request);
        }
    }
}

