/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.OkCancelPage;
import com.imcode.imcms.mapping.DocumentMapper;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ListDocumentAliasPage
extends OkCancelPage {
    public static final String REQUEST_PARAMETER_BUTTON__LIST = "showspan";
    public static final String REQUEST_PARAMETER__LIST_START = "start";
    public static final String REQUEST_PARAMETER__LIST_END = "end";
    public static final String REQUEST_PARAMETER__CANCEL_BUTTON = "cancel";
    public String startString;
    public String endString;
    public Set<String> aliasInSelectedRange = new TreeSet<String>();

    public ListDocumentAliasPage(DispatchCommand okDispatchCommand, DispatchCommand cancelDispatchCommand, HttpServletRequest request) {
        super(okDispatchCommand, cancelDispatchCommand);
        this.updateFromRequest(request);
    }

    protected void updateFromRequest(HttpServletRequest request) {
        this.startString = StringUtils.defaultString((String)request.getParameter(REQUEST_PARAMETER__LIST_START), (String)"A");
        this.endString = StringUtils.defaultString((String)request.getParameter(REQUEST_PARAMETER__LIST_END), (String)"\u00d6");
    }

    protected void dispatchOther(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ImcmsServices imcref = Imcms.getServices();
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        List<String> alphaRange = Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "\u00c5", "\u00c4", "\u00d6");
        if (!alphaRange.contains(this.startString.toUpperCase())) {
            this.startString = alphaRange.get(0).toString();
        }
        if (alphaRange.indexOf(this.endString.toUpperCase()) < alphaRange.indexOf(this.startString.toUpperCase())) {
            this.endString = this.startString;
        }
        if (request.getParameter(REQUEST_PARAMETER_BUTTON__LIST) != null) {
            List<String> selectedRange = alphaRange.subList(alphaRange.indexOf(this.startString.toUpperCase()), alphaRange.indexOf(this.endString.toUpperCase()) + 1);
            this.aliasInSelectedRange.clear();
            for (String alias : documentMapper.getAllDocumentAlias()) {
                if (alias.length() <= 0 || !selectedRange.contains(alias.toUpperCase().substring(0, 1))) continue;
                this.aliasInSelectedRange.add(alias);
            }
        }
        this.forward(request, response);
    }

    public String getPath(HttpServletRequest request) {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        return "/imcms/" + user.getLanguageIso639_2() + "/jsp/document_alias_list.jsp";
    }
}

