/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.EditDocumentInformationPageFlow;
import com.imcode.imcms.flow.OkCancelPage;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.servlet.DocumentFinder;
import com.imcode.imcms.servlet.admin.EditLink;
import com.imcode.imcms.servlet.admin.Handler;
import imcode.server.Imcms;
import imcode.server.document.DocumentDomainObject;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkEditPage
extends OkCancelPage {
    private EditLink.Link link;
    private final Handler<EditLink.Link> linkRetrievalCommand;
    private boolean targetEditable = true;

    protected LinkEditPage(DispatchCommand returnCommand, Handler<EditLink.Link> linkRetrievalCommand) {
        super(returnCommand, returnCommand);
        this.linkRetrievalCommand = linkRetrievalCommand;
    }

    @Override
    protected void dispatchOk(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.linkRetrievalCommand.handle(this.link);
        super.dispatchOk(request, response);
    }

    public EditLink.Link getLink() {
        return this.link;
    }

    public void setLink(EditLink.Link link) {
        this.link = link;
    }

    public boolean isTargetEditable() {
        return this.targetEditable;
    }

    public void setTargetEditable(boolean targetEditable) {
        this.targetEditable = targetEditable;
    }

    @Override
    protected void dispatchOther(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (null != request.getParameter(Parameter.SEARCH.toString())) {
            DocumentFinder documentFinder = new DocumentFinder();
            final DocumentIdRetrievalCommand documentRetrievalCommand = new DocumentIdRetrievalCommand();
            DispatchCommand returnCommand = new DispatchCommand(){

                public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    Integer documentId = documentRetrievalCommand.getDocumentId();
                    if (null != documentId) {
                        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
                        DocumentDomainObject doc = documentMapper.getDocument(documentId);
                        LinkEditPage.this.setLink(new SimpleLink(request.getContextPath() + "/" + doc.getName(), LinkEditPage.this.link.getTitle(), LinkEditPage.this.link.getTarget()));
                    }
                    LinkEditPage.this.forward(request, response);
                }
            };
            documentFinder.setCancelCommand(returnCommand);
            documentFinder.setSelectDocumentCommand(documentRetrievalCommand);
            documentFinder.forward(request, response);
        }
    }

    @Override
    protected void updateFromRequest(HttpServletRequest request) {
        this.setLink(this.getLinkFromRequest(request));
    }

    private EditLink.Link getLinkFromRequest(HttpServletRequest request) {
        String href = StringUtils.defaultString((String)request.getParameter(Parameter.HREF.toString()));
        String title = StringUtils.defaultString((String)request.getParameter(Parameter.TITLE.toString()));
        String target = EditDocumentInformationPageFlow.getTargetFromRequest(request, Parameter.TARGET.toString());
        return new SimpleLink(href, title, this.isTargetEditable() ? target : this.link.getTarget());
    }

    @Override
    public String getPath(HttpServletRequest request) {
        return "/WEB-INF/imcms/jsp/edit_link.jsp";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocumentIdRetrievalCommand
    implements Handler<Integer> {
        private Integer documentId;

        private DocumentIdRetrievalCommand() {
        }

        @Override
        public void handle(Integer e) {
            this.documentId = e;
        }

        public Integer getDocumentId() {
            return this.documentId;
        }
    }

    static class SimpleLink
    implements EditLink.Link {
        private final String href;
        private final String title;
        private final String target;

        public SimpleLink(String href, String title, String target) {
            this.href = href;
            this.title = title;
            this.target = target;
        }

        public String getHref() {
            return this.href;
        }

        public String getTitle() {
            return this.title;
        }

        public String getTarget() {
            return this.target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parameter {
        HREF,
        TITLE,
        TARGET,
        SEARCH;

    }
}

