/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.OkCancelPage;
import com.imcode.imcms.servlet.admin.Handler;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.image.ImageInfo;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.math.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCropPage
extends OkCancelPage {
    private static final long serialVersionUID = 2032206435742139836L;
    public static final String PARAM_CROP_X1 = "crop_x1";
    public static final String PARAM_CROP_Y1 = "crop_y1";
    public static final String PARAM_CROP_X2 = "crop_x2";
    public static final String PARAM_CROP_Y2 = "crop_y2";
    private static final Map<String, Object> CONSTANTS = Utility.getConstants(ImageCropPage.class);
    private Handler<ImageDomainObject.CropRegion> selectRegionCommand;
    private ImageDomainObject.CropRegion region;
    private ImageDomainObject image;
    private int forcedWidth;
    private int forcedHeight;

    public ImageCropPage(DispatchCommand okCancelCommand, Handler<ImageDomainObject.CropRegion> selectRegionCommand, ImageDomainObject image, int forcedWidth, int forcedHeight) {
        super(okCancelCommand, okCancelCommand);
        this.selectRegionCommand = selectRegionCommand;
        this.image = image;
        this.region = image.getCropRegion();
        this.forcedWidth = forcedWidth;
        this.forcedHeight = forcedHeight;
        if (forcedWidth > 0) {
            image.setWidth(forcedWidth);
        }
        if (forcedHeight > 0) {
            image.setHeight(forcedHeight);
        }
    }

    @Override
    public void forward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("const", CONSTANTS);
        request.setAttribute("cropPage", (Object)this);
        request.setAttribute("region", (Object)this.region);
        request.setAttribute("image", (Object)this.image);
        ImageInfo imageInfo = this.image.getImageInfo();
        request.setAttribute("imageWidth", (Object)imageInfo.getWidth());
        request.setAttribute("imageHeight", (Object)imageInfo.getHeight());
        request.setAttribute("forcedWidth", (Object)this.forcedWidth);
        request.setAttribute("forcedHeight", (Object)this.forcedHeight);
        super.forward(request, response);
    }

    @Override
    protected void updateFromRequest(HttpServletRequest request) {
        int cropX1 = NumberUtils.toInt((String)request.getParameter(PARAM_CROP_X1), (int)-1);
        int cropY1 = NumberUtils.toInt((String)request.getParameter(PARAM_CROP_Y1), (int)-1);
        int cropX2 = NumberUtils.toInt((String)request.getParameter(PARAM_CROP_X2), (int)-1);
        int cropY2 = NumberUtils.toInt((String)request.getParameter(PARAM_CROP_Y2), (int)-1);
        this.region = new ImageDomainObject.CropRegion(cropX1, cropY1, cropX2, cropY2);
    }

    @Override
    protected void dispatchOther(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.forward(request, response);
    }

    @Override
    protected void dispatchOk(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.selectRegionCommand.handle(this.region);
        super.dispatchOk(request, response);
    }

    @Override
    public String getPath(HttpServletRequest request) {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        return "/imcms/" + user.getLanguageIso639_2() + "/jsp/crop_img.jsp";
    }

    public ImageDomainObject.CropRegion getRegion() {
        return this.region;
    }

    public ImageDomainObject getImage() {
        return this.image;
    }
}

