/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.servlet.admin.AdminDoc;
import imcode.server.Imcms;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChangeText
extends HttpServlet {
    private static final String JSP__CHANGE_TEXT = "change_text.jsp";

    public void doGet(HttpServletRequest request, HttpServletResponse res) throws ServletException, IOException {
        Utility.setDefaultHtmlContentType(res);
        UserDomainObject user = Utility.getLoggedOnUser(request);
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        int documentId = Integer.parseInt(request.getParameter("meta_id"));
        TextDocumentDomainObject textDocument = (TextDocumentDomainObject)documentMapper.getDocument(documentId);
        TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)user.getPermissionSetFor(textDocument);
        if (!textDocumentPermissionSet.getEditTexts()) {
            AdminDoc.adminDoc(documentId, user, request, res, this.getServletContext());
            return;
        }
        int textIndex = Integer.parseInt(request.getParameter("txt"));
        String label = null == request.getParameter("label") ? "" : request.getParameter("label");
        TextDomainObject text = textDocument.getText(textIndex);
        if (null == text) {
            text = new TextDomainObject("", 1);
        }
        String formatsParameter = request.getParameter("formats");
        TextEditPage page = new TextEditPage(documentId, textIndex, text, label);
        page.forward(request, res, user);
    }

    public static class TextEditPage {
        public static final String REQUEST_ATTRIBUTE__PAGE = "page";
        int documentId;
        private int textIndex;
        private String label;
        private TextDomainObject text;

        public TextEditPage(int documentId, int textIndex, TextDomainObject text, String label) {
            this.documentId = documentId;
            this.text = text;
            this.textIndex = textIndex;
            this.label = label;
        }

        public int getDocumentId() {
            return this.documentId;
        }

        public String getTextString() {
            return this.text.getText();
        }

        public int getTextIndex() {
            return this.textIndex;
        }

        public String getLabel() {
            return this.label;
        }

        public int getType() {
            return this.text.getType();
        }

        public void forward(HttpServletRequest request, HttpServletResponse response, UserDomainObject user) throws IOException, ServletException {
            request.setAttribute(REQUEST_ATTRIBUTE__PAGE, (Object)this);
            String forwardPath = "/imcms/" + user.getLanguageIso639_2() + "/jsp/" + ChangeText.JSP__CHANGE_TEXT;
            request.getRequestDispatcher(forwardPath).forward((ServletRequest)request, (ServletResponse)response);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Format {
            NONE,
            TEXT,
            EDITOR;

        }
    }
}

