/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentSaveException;
import com.imcode.imcms.servlet.admin.Handler;
import com.imcode.imcms.servlet.admin.ImageEditPage;
import com.imcode.imcms.util.l10n.LocalizedMessageFormat;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.ConcurrentDocumentModificationException;
import imcode.server.document.NoPermissionToEditDocumentException;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.ShouldHaveCheckedPermissionsEarlierException;
import imcode.util.ShouldNotBeThrownException;
import imcode.util.Utility;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ChangeImage
extends HttpServlet {
    public static final String REQUEST_PARAMETER__IMAGE_INDEX = "img";
    public static final String REQUEST_PARAMETER__LABEL = "label";
    public static final String REQUEST_PARAMETER__WIDTH = "width";
    public static final String REQUEST_PARAMETER__HEIGHT = "height";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        final TextDocumentDomainObject document = (TextDocumentDomainObject)documentMapper.getDocument(Integer.parseInt(request.getParameter("meta_id")));
        final int imageIndex = Integer.parseInt(request.getParameter(REQUEST_PARAMETER__IMAGE_INDEX));
        ImageDomainObject image = document.getImage(imageIndex);
        final UserDomainObject user = Utility.getLoggedOnUser(request);
        int forcedWidth = NumberUtils.toInt((String)request.getParameter(REQUEST_PARAMETER__WIDTH));
        int forcedHeight = NumberUtils.toInt((String)request.getParameter(REQUEST_PARAMETER__HEIGHT));
        forcedWidth = Math.max(forcedWidth, 0);
        forcedHeight = Math.max(forcedHeight, 0);
        if (!ImageEditPage.userHasImagePermissionsOnDocument(user, document)) {
            Utility.redirectToStartDocument(request, response);
            return;
        }
        DispatchCommand returnCommand = new DispatchCommand(){

            public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.sendRedirect("AdminDoc?meta_id=" + document.getId() + "&flags=" + 131072);
            }
        };
        Handler<ImageDomainObject> imageCommand = new Handler<ImageDomainObject>(){

            @Override
            public void handle(ImageDomainObject image) {
                ImcmsServices services = Imcms.getServices();
                document.setImage(imageIndex, image);
                try {
                    services.getDocumentMapper().saveDocument(document, user);
                }
                catch (NoPermissionToEditDocumentException e) {
                    throw new ShouldHaveCheckedPermissionsEarlierException(e);
                }
                catch (NoPermissionToAddDocumentToMenuException e) {
                    throw new ConcurrentDocumentModificationException(e);
                }
                catch (DocumentSaveException e) {
                    throw new ShouldNotBeThrownException(e);
                }
                services.updateMainLog("ImageRef " + imageIndex + " =" + image.getUrlPathRelativeToContextPath() + " in  " + "[" + document.getId() + "] modified by user: [" + user.getFullName() + "]");
            }
        };
        LocalizedMessageFormat heading = new LocalizedMessageFormat("image/edit_image_on_page", imageIndex, document.getId());
        ImageEditPage imageEditPage = new ImageEditPage(document, image, imageIndex, heading, StringUtils.defaultString((String)request.getParameter(REQUEST_PARAMETER__LABEL)), this.getServletContext(), imageCommand, returnCommand, true, forcedWidth, forcedHeight);
        imageEditPage.forward(request, response);
    }
}

