/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.util.l10n.LocalizedMessage;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ImcmsMultipleUserLoginFilter
implements Filter {
    public static final String TOO_MANY_SESSIONS = "TooManySessions";
    public static final LocalizedMessage LOGIN_MSG_TOO_MANY_SESSIONS = new LocalizedMessage("templates/login/TooManySessions");

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        req.setCharacterEncoding("UTF-8");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession();
        ImcmsServices service = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(request);
        if (user != null && !user.isDefaultUser() && service.getConfig().isDenyMultipleUserLogin()) {
            String sessionId = session.getId();
            String lastUserSessionId = service.getImcmsAuthenticatorAndUserAndRoleMapper().getUserSessionId(user);
            if (lastUserSessionId != null && !lastUserSessionId.equals(sessionId)) {
                session.invalidate();
                String redirectURL = request.getContextPath() + "/login?" + TOO_MANY_SESSIONS;
                response.sendRedirect(redirectURL);
                return;
            }
        }
        if (request.getParameter(TOO_MANY_SESSIONS) != null) {
            request.setAttribute("error", (Object)LOGIN_MSG_TOO_MANY_SESSIONS);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

