/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.servlet.ImageCacheManager;
import imcode.server.Imcms;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.ImageCacheDomainObject;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.image.Format;
import imcode.util.image.ImageInfo;
import imcode.util.image.ImageOp;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageHandling
extends HttpServlet {
    private static final long serialVersionUID = 6075455980496678862L;
    private static final Log log;
    private static final Pattern FILENAME_PATTERN;
    private static final Pattern DOT_OR_COLON_PATTERN;
    private static final Pattern ABSOLUTE_PATH_PATTERN;
    private static final String USER_AGENT = "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.9) Gecko/20071025 Firefox/2.0.0.9";
    private static final HttpClient HTTP_CLIENT;
    private static final List<String> ALLOWED_PATHS;

    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String desiredFilename = ImageHandling.getDesiredFilename(request);
        String path = StringUtils.trimToNull((String)request.getParameter("path"));
        String url = StringUtils.trimToNull((String)request.getParameter("url"));
        int fileId = NumberUtils.toInt((String)request.getParameter("file_id"));
        int metaId = NumberUtils.toInt((String)request.getParameter("meta_id"));
        int imageIndex = NumberUtils.toInt((String)request.getParameter("image_index"));
        String formatParam = StringUtils.trimToEmpty((String)request.getParameter("format")).toLowerCase();
        Format format = Format.findFormatByExtension(formatParam);
        int width = NumberUtils.toInt((String)request.getParameter("width"));
        int height = NumberUtils.toInt((String)request.getParameter("height"));
        width = Math.max(width, 0);
        height = Math.max(height, 0);
        if (path == null && url == null && fileId <= 0 || format != null && !format.isWritable()) {
            ImageHandling.sendNotFound(response);
            return;
        }
        int cropX1 = NumberUtils.toInt((String)request.getParameter("crop_x1"), (int)-1);
        int cropY1 = NumberUtils.toInt((String)request.getParameter("crop_y1"), (int)-1);
        int cropX2 = NumberUtils.toInt((String)request.getParameter("crop_x2"), (int)-1);
        int cropY2 = NumberUtils.toInt((String)request.getParameter("crop_y2"), (int)-1);
        ImageDomainObject.CropRegion cropRegion = new ImageDomainObject.CropRegion(cropX1, cropY1, cropX2, cropY2);
        ImageCacheDomainObject imageCache = ImageHandling.createImageCacheObject(path, url, fileId, metaId, imageIndex, format, width, height, cropRegion);
        String cacheId = imageCache.getId();
        File cacheFile = ImageCacheManager.getCacheFile(imageCache);
        if (cacheFile != null) {
            ImageHandling.writeImageToResponse(cacheId, cacheFile, format, desiredFilename, response);
            return;
        }
        if (!ImageHandling.canGenerateImage(metaId, request)) {
            ImageHandling.sendNotFound(response);
            return;
        }
        File imageFile = null;
        boolean deleteFile = false;
        if (path != null) {
            imageFile = ImageHandling.getLocalFile(path);
        } else if (fileId > 0) {
            imageFile = ImageHandling.getFileDocument(fileId);
            deleteFile = true;
        } else {
            imageFile = ImageHandling.retrieveExternalFile(url);
            deleteFile = true;
        }
        if (imageFile == null) {
            ImageHandling.sendNotFound(response);
            return;
        }
        ImageInfo imageInfo = ImageOp.getImageInfo(Imcms.getServices().getConfig(), imageFile);
        if (imageInfo == null || format == null && !imageInfo.getFormat().isWritable()) {
            if (deleteFile) {
                imageFile.delete();
            }
            ImageHandling.sendNotFound(response);
            return;
        }
        cacheFile = ImageCacheManager.storeImage(imageCache, imageFile, deleteFile);
        if (cacheFile == null) {
            ImageHandling.sendNotFound(response);
            return;
        }
        Format outputFormat = format != null ? format : imageInfo.getFormat();
        ImageHandling.writeImageToResponse(cacheId, cacheFile, outputFormat, desiredFilename, response);
    }

    private static boolean canGenerateImage(int metaId, HttpServletRequest request) {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        if (user == null) {
            return false;
        }
        if (metaId > 0) {
            DocumentDomainObject document = Imcms.getServices().getDocumentMapper().getDocument(metaId);
            if (document == null || !(document instanceof TextDocumentDomainObject)) {
                return false;
            }
            TextDocumentPermissionSetDomainObject permissionSet = (TextDocumentPermissionSetDomainObject)user.getPermissionSetFor(document);
            return permissionSet.getEditImages();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void writeImageToResponse(String cacheId, File cacheFile, Format format, String desiredFilename, HttpServletResponse response) {
        if (format != null) {
            response.setContentType(format.getMimeType());
        } else {
            response.setContentType("application/octet-stream");
        }
        response.setContentLength((int)cacheFile.length());
        if (desiredFilename == null) {
            desiredFilename = cacheId;
        }
        desiredFilename = StringUtils.replace((String)desiredFilename, (String)"\"", (String)"\\\"");
        response.addHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", desiredFilename));
        FileInputStream input = null;
        BufferedOutputStream output = null;
        try {
            input = new FileInputStream(cacheFile);
            output = new BufferedOutputStream((OutputStream)response.getOutputStream());
            IOUtils.copy((InputStream)input, (OutputStream)output);
            ((OutputStream)output).flush();
        }
        catch (IOException ex) {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly(output);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(output);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((OutputStream)output);
    }

    static ImageCacheDomainObject createImageCacheObject(String path, String url, int fileId, int metaId, int imageIndex, Format format, int width, int height, ImageDomainObject.CropRegion cropRegion) {
        ImageCacheDomainObject imageCache = new ImageCacheDomainObject();
        if (path != null) {
            imageCache.setResource(path);
            imageCache.setType((short)1);
        } else if (fileId > 0) {
            imageCache.setResource(Integer.toString(fileId));
            imageCache.setType((short)2);
        } else if (url != null) {
            imageCache.setResource(url);
            imageCache.setType((short)3);
        } else {
            throw new RuntimeException("path, url or fileId must be valid");
        }
        if (metaId > 0) {
            imageCache.setMetaId(metaId);
            imageCache.setImageIndex(imageIndex);
        }
        imageCache.setFormat(format);
        imageCache.setWidth(width);
        imageCache.setHeight(height);
        imageCache.setCropRegion(cropRegion);
        imageCache.generateId();
        return imageCache;
    }

    static File getLocalFile(String filepath) {
        File root = Imcms.getPath();
        File localFile = new File(root, ImageHandling.sanitiseFilepath(filepath));
        if (!localFile.exists()) {
            return null;
        }
        for (String allowedPath : ALLOWED_PATHS) {
            try {
                if (!localFile.getCanonicalPath().startsWith(allowedPath)) continue;
                return localFile;
            }
            catch (IOException ex) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File retrieveExternalFile(String url) {
        block12: {
            GetMethod fileGet = new GetMethod(url);
            fileGet.addRequestHeader("User-Agent", USER_AGENT);
            try {
                File file;
                int responseCode = HTTP_CLIENT.executeMethod((HttpMethod)fileGet);
                if (responseCode != 200) {
                    ImageHandling.drainInput(fileGet.getResponseBodyAsStream());
                    File file2 = null;
                    return file2;
                }
                File file3 = File.createTempFile("external_file", ".tmp");
                InputStream input = null;
                BufferedOutputStream output = null;
                try {
                    input = fileGet.getResponseBodyAsStream();
                    output = new BufferedOutputStream(new FileOutputStream(file3));
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                    file = file3;
                }
                catch (Exception ex) {
                    try {
                        try {
                            log.warn((Object)ex.getMessage(), (Throwable)ex);
                            file3.delete();
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(output);
                            IOUtils.closeQuietly((InputStream)input);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((OutputStream)output);
                        IOUtils.closeQuietly((InputStream)input);
                        break block12;
                    }
                    catch (Exception ex2) {
                        log.warn((Object)ex2.getMessage(), (Throwable)ex2);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)output);
                IOUtils.closeQuietly((InputStream)input);
                return file;
            }
            finally {
                fileGet.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static File getFileDocument(int metaId) {
        File file;
        DocumentDomainObject document = Imcms.getServices().getDocumentMapper().getDocument(metaId);
        if (document == null || !(document instanceof FileDocumentDomainObject)) {
            return null;
        }
        FileDocumentDomainObject fileDocument = (FileDocumentDomainObject)document;
        FileDocumentDomainObject.FileDocumentFile documentFile = fileDocument.getDefaultFile();
        if (documentFile == null) {
            return null;
        }
        File file2 = null;
        InputStream input = null;
        BufferedOutputStream output = null;
        try {
            file2 = File.createTempFile("doc_file", ".tmp");
            output = new BufferedOutputStream(new FileOutputStream(file2));
            input = documentFile.getInputStreamSource().getInputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
            file = file2;
        }
        catch (Exception ex) {
            block6: {
                try {
                    log.warn((Object)ex.getMessage(), (Throwable)ex);
                    if (file2 == null) break block6;
                    file2.delete();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(output);
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)output);
            IOUtils.closeQuietly(input);
            return null;
        }
        IOUtils.closeQuietly((OutputStream)output);
        IOUtils.closeQuietly((InputStream)input);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drainInput(InputStream input) throws IOException {
        try {
            byte[] buffer = new byte[4096];
            while (input.read(buffer) > 0) {
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private static String getDesiredFilename(HttpServletRequest request) {
        Matcher matcher = FILENAME_PATTERN.matcher(request.getRequestURI());
        if (matcher.find()) {
            try {
                return URLDecoder.decode(matcher.group(1), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String sanitiseFilepath(String filepath) {
        Matcher matcher = DOT_OR_COLON_PATTERN.matcher(filepath);
        filepath = matcher.replaceAll(".");
        matcher = ABSOLUTE_PATH_PATTERN.matcher(filepath);
        return matcher.replaceFirst("");
    }

    private static void sendNotFound(HttpServletResponse response) throws IOException {
        response.sendError(404);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    static {
        String[] paths;
        log = LogFactory.getLog(ImageHandling.class);
        FILENAME_PATTERN = Pattern.compile("/imagehandling/([^/]+?)/?$");
        DOT_OR_COLON_PATTERN = Pattern.compile("\\.{2,}|:+");
        ABSOLUTE_PATH_PATTERN = Pattern.compile("^(\\\\|/)+");
        HTTP_CLIENT = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        ALLOWED_PATHS = new ArrayList<String>();
        File rootFile = Imcms.getPath();
        String cacheAllowedPaths = Imcms.getServices().getConfig().getImageCacheAllowedPaths();
        for (String path : paths = StringUtils.split((String)cacheAllowedPaths, (char)';')) {
            if (StringUtils.isEmpty((String)(path = path.trim()))) continue;
            try {
                File file = new File(rootFile, path);
                ALLOWED_PATHS.add(file.getCanonicalPath());
            }
            catch (IOException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

