/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.mock.MockDatabase;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.SaveException;
import com.imcode.imcms.mapping.AbstractDocumentGetter;
import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentPermissionSetMapper;
import com.imcode.imcms.mapping.DocumentSaveException;
import com.imcode.imcms.mapping.DocumentSaver;
import com.imcode.imcms.mapping.MapDocumentGetter;
import imcode.server.MockImcmsServices;
import imcode.server.document.DirectDocumentReference;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.NoPermissionToEditDocumentException;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import imcode.util.SystemClock;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import junit.framework.TestCase;

public class TestDocumentSaver
extends TestCase {
    private DocumentMapper documentMapper;
    private DocumentSaver documentSaver;
    private MockDatabase database;

    protected void setUp() throws Exception {
        super.setUp();
        this.database = new MockDatabase();
        this.documentMapper = new DocumentMapper(new MockImcmsServices(), (Database)this.database){

            public void invalidateDocument(DocumentDomainObject document) {
            }
        };
        this.documentMapper.setDocumentPermissionSetMapper(new DocumentPermissionSetMapper((Database)this.database));
        this.documentMapper.setClock(new SystemClock());
        this.documentSaver = new DocumentSaver(this.documentMapper);
    }

    public void testRemoveOwnPermissionsFromDocument() throws SaveException, NoPermissionException, DocumentSaveException {
        final TextDocumentDomainObject oldDocument = this.createDocument(1001);
        this.documentMapper.setDocumentGetter(new AbstractDocumentGetter(){

            public DocumentDomainObject getDocument(Integer documentId) {
                return oldDocument;
            }
        });
        TextDocumentDomainObject document = this.createDocument(1001);
        this.documentSaver.saveDocument(document, oldDocument, new UserDomainObject());
    }

    private TextDocumentDomainObject createDocument(int documentId) {
        TextDocumentDomainObject document = new TextDocumentDomainObject();
        this.documentMapper.makeDocumentLookNew(document, new UserDomainObject());
        document.setId(documentId);
        document.setTemplateName("1");
        return document;
    }

    public void testDocumentAddedWithoutPermission() {
        TextDocumentDomainObject oldDocument = this.createTextDocument(1001);
        TextDocumentDomainObject addedDocument = this.createTextDocument(1002);
        MapDocumentGetter documentGetter = new MapDocumentGetter(new DocumentDomainObject[]{oldDocument, addedDocument});
        this.documentMapper.setDocumentGetter(documentGetter);
        UserDomainObject testedUser = new UserDomainObject();
        TextDocumentDomainObject document = (TextDocumentDomainObject)this.documentMapper.getDocument(1001);
        document.getMenu(1).addMenuItem(new MenuItemDomainObject(new DirectDocumentReference(addedDocument)));
        addedDocument.setLinkableByOtherUsers(true);
        this.assertDocumentsAddedWithPermission(document, null, testedUser, documentGetter);
        addedDocument.setLinkableByOtherUsers(false);
        this.assertDocumentsAddedWithoutPermission(document, null, testedUser, documentGetter);
        this.assertDocumentsAddedWithoutPermission(document, oldDocument, testedUser, documentGetter);
        addedDocument.setLinkableByOtherUsers(true);
        this.assertDocumentsAddedWithPermission(document, oldDocument, testedUser, documentGetter);
        addedDocument.setLinkableByOtherUsers(false);
        this.assertDocumentsAddedWithoutPermission(document, oldDocument, testedUser, documentGetter);
        addedDocument.setDocumentPermissionSetTypeForRoleId(RoleId.USERS, DocumentPermissionSetTypeDomainObject.FULL);
        this.assertDocumentsAddedWithPermission(document, oldDocument, testedUser, documentGetter);
        addedDocument.setDocumentPermissionSetTypeForRoleId(RoleId.USERS, DocumentPermissionSetTypeDomainObject.NONE);
        this.assertDocumentsAddedWithoutPermission(document, oldDocument, testedUser, documentGetter);
        testedUser.addRoleId(RoleId.SUPERADMIN);
        this.assertDocumentsAddedWithPermission(document, oldDocument, testedUser, documentGetter);
        testedUser.removeRoleId(RoleId.SUPERADMIN);
        this.assertDocumentsAddedWithoutPermission(document, oldDocument, testedUser, documentGetter);
    }

    public void testDocumentAddedWithPropertyAlias() throws DocumentSaveException {
        UserDomainObject testedUser = new UserDomainObject();
        testedUser.addRoleId(RoleId.SUPERADMIN);
        TextDocumentDomainObject document = this.createTextDocument(1001);
        MapDocumentGetter documentGetter = new MapDocumentGetter(new DocumentDomainObject[]{document});
        this.documentMapper.setDocumentGetter(documentGetter);
        document.setProperty("imcms.document.alias", "start");
        try {
            this.documentMapper.saveDocument(document, testedUser);
        }
        catch (NoPermissionToEditDocumentException e) {
        }
        catch (NoPermissionToAddDocumentToMenuException e) {
            // empty catch block
        }
        this.database.assertCalled((MockDatabase.SqlCallPredicate)new MockDatabase.InsertIntoTableWithParameterSqlCallPredicate("document_properties", "start"));
        document = (TextDocumentDomainObject)this.documentMapper.getDocument(1001);
        TestDocumentSaver.assertEquals((String)document.getProperty("imcms.document.alias"), (String)"start");
    }

    private void assertDocumentsAddedWithPermission(TextDocumentDomainObject document, TextDocumentDomainObject oldDocument, UserDomainObject user, DocumentGetter documentGetter) {
        Set documentsAddedWithoutPermission = this.documentSaver.getDocumentsAddedWithoutPermission(document, oldDocument, user, documentGetter);
        this.assertEmpty(documentsAddedWithoutPermission);
    }

    private void assertDocumentsAddedWithoutPermission(TextDocumentDomainObject document, TextDocumentDomainObject oldDocument, UserDomainObject user, DocumentGetter documentGetter) {
        Set documentsAddedWithoutPermission = this.documentSaver.getDocumentsAddedWithoutPermission(document, oldDocument, user, documentGetter);
        this.assertNotEmpty(documentsAddedWithoutPermission);
    }

    private void assertEmpty(Collection collection) {
        TestDocumentSaver.assertTrue((boolean)collection.isEmpty());
    }

    private void assertNotEmpty(Collection collection) {
        TestDocumentSaver.assertFalse((boolean)collection.isEmpty());
    }

    private TextDocumentDomainObject createTextDocument(int documentId) {
        TextDocumentDomainObject newTextDocument = new TextDocumentDomainObject();
        newTextDocument.setId(documentId);
        newTextDocument.setActualModifiedDatetime(new Date(0L));
        return newTextDocument;
    }
}

