/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import com.imcode.db.commands.SqlUpdateDatabaseCommand;
import imcode.server.ImcmsServices;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;

public class MenuSaver {
    private Database database;

    public MenuSaver(Database database) {
        this.database = database;
    }

    void updateTextDocumentMenus(TextDocumentDomainObject textDocument, ImcmsServices services, TextDocumentDomainObject oldTextDocument, UserDomainObject savingUser) {
        Map<Integer, MenuDomainObject> menuMap = textDocument.getMenus();
        for (Map.Entry<Integer, MenuDomainObject> entry : menuMap.entrySet()) {
            MenuDomainObject oldMenu;
            Integer menuIndex = entry.getKey();
            MenuDomainObject menu = entry.getValue();
            if (oldTextDocument != null && (oldMenu = oldTextDocument.getMenu(menuIndex)) != null && oldMenu.getMenuItemsUnsorted().size() > 0 && !oldMenu.equals(menu)) {
                this.updateTextDocumentMenuHistory(oldTextDocument, menuIndex, oldMenu, savingUser, services);
            }
            this.updateTextDocumentMenu(textDocument, menuIndex, menu, services);
        }
        this.deleteUnusedMenus(textDocument);
    }

    private void updateTextDocumentMenuHistory(TextDocumentDomainObject oldTextDocument, Integer menuIndex, MenuDomainObject oldMenu, UserDomainObject savingUser, ImcmsServices services) {
        this.insertTextDocumentMenuHistory(oldTextDocument, menuIndex, oldMenu, savingUser, services);
    }

    private void insertTextDocumentMenuHistory(TextDocumentDomainObject oldTextDocument, Integer menuIndex, MenuDomainObject oldMenu, UserDomainObject savingUser, ImcmsServices services) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.database.execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("menus_history", (Object[][])new Object[][]{{"menu_id", new Integer(oldMenu.getId())}, {"meta_id", new Integer(oldTextDocument.getId())}, {"menu_index", new Integer(menuIndex)}, {"sort_order", new Integer(oldMenu.getSortOrder())}, {"modified_datetime", dateFormat.format(new Date())}, {"user_id", new Integer(savingUser.getId())}}));
        Set menuItems = oldMenu.getMenuItemsUnsorted();
        for (MenuItemDomainObject menuItem : menuItems) {
            this.sqlInsertMenuItemHistory(oldMenu, menuItem);
        }
    }

    private void sqlInsertMenuItemHistory(MenuDomainObject oldMenu, MenuItemDomainObject menuItem) {
        this.database.execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("childs_history", (Object[][])new Object[][]{{"menu_id", new Integer(oldMenu.getId())}, {"to_meta_id", new Integer(menuItem.getDocumentReference().getDocumentId())}, {"manual_sort_order", new Integer(menuItem.getSortKey())}, {"tree_sort_index", menuItem.getTreeSortKey().toString()}}));
    }

    private void deleteUnusedMenus(TextDocumentDomainObject textDocument) {
        Collection<MenuDomainObject> menus = textDocument.getMenus().values();
        if (!menus.isEmpty()) {
            Collection menuIds = CollectionUtils.collect(menus, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return new Integer(((MenuDomainObject)input).getId());
                }
            });
            String sqlInMenuIds = StringUtils.join(menuIds.iterator(), (String)",");
            String whereClause = "menu_id NOT IN (" + sqlInMenuIds + ")";
            String sqlDeleteUnusedMenuItems = "DELETE FROM childs WHERE menu_id IN (SELECT menu_id FROM menus WHERE meta_id = ?) AND " + whereClause;
            this.database.execute((DatabaseCommand)new SqlUpdateDatabaseCommand(sqlDeleteUnusedMenuItems, (Object[])new String[]{"" + textDocument.getId()}));
            String sqlDeleteUnusedMenus = "DELETE FROM menus WHERE meta_id = ? AND " + whereClause;
            this.database.execute((DatabaseCommand)new SqlUpdateDatabaseCommand(sqlDeleteUnusedMenus, (Object[])new String[]{"" + textDocument.getId()}));
        }
    }

    private void updateTextDocumentMenu(TextDocumentDomainObject textDocument, Integer menuIndex, MenuDomainObject menu, ImcmsServices services) {
        this.deleteTextDocumentMenu(textDocument, menuIndex);
        this.insertTextDocumentMenu(textDocument, menuIndex, menu, services);
    }

    private void insertTextDocumentMenu(TextDocumentDomainObject textDocument, Integer menuIndex, MenuDomainObject menu, ImcmsServices services) {
        this.sqlInsertMenu(textDocument, menuIndex, menu);
        this.insertTextDocumentMenuItems(menu, services);
    }

    private void deleteTextDocumentMenu(TextDocumentDomainObject textDocument, Integer menuIndex) {
        this.deleteTextDocumentMenuItems(textDocument, menuIndex);
        String sqlDeleteMenu = "DELETE FROM menus WHERE meta_id = ? AND menu_index = ?";
        this.database.execute((DatabaseCommand)new SqlUpdateDatabaseCommand(sqlDeleteMenu, (Object[])new String[]{"" + textDocument.getId(), "" + menuIndex}));
    }

    private void deleteTextDocumentMenuItems(TextDocumentDomainObject textDocument, Integer menuIndex) {
        String sqlDeleteMenuItems = "DELETE FROM childs WHERE menu_id IN (SELECT menu_id FROM menus WHERE meta_id = ? AND menu_index = ?)";
        this.database.execute((DatabaseCommand)new SqlUpdateDatabaseCommand(sqlDeleteMenuItems, (Object[])new String[]{"" + textDocument.getId(), "" + menuIndex}));
    }

    private void insertTextDocumentMenuItems(MenuDomainObject menu, ImcmsServices services) {
        Set menuItems = menu.getMenuItemsUnsorted();
        for (MenuItemDomainObject menuItem : menuItems) {
            this.sqlInsertMenuItem(menu, menuItem);
        }
    }

    private void sqlInsertMenuItem(MenuDomainObject menu, MenuItemDomainObject menuItem) {
        String sqlInsertMenuItem = "INSERT INTO childs (menu_id, to_meta_id, manual_sort_order, tree_sort_index) VALUES(?,?,?,?)";
        Object[] parameters = new String[]{"" + menu.getId(), "" + menuItem.getDocumentReference().getDocumentId(), "" + menuItem.getSortKey(), "" + menuItem.getTreeSortKey()};
        this.database.execute((DatabaseCommand)new SqlUpdateDatabaseCommand(sqlInsertMenuItem, parameters));
    }

    private void sqlInsertMenu(TextDocumentDomainObject textDocument, int menuIndex, MenuDomainObject menu) {
        Number menuId = (Number)this.database.execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("menus", (Object[][])new Object[][]{{"meta_id", new Integer(textDocument.getId())}, {"menu_index", new Integer(menuIndex)}, {"sort_order", new Integer(menu.getSortOrder())}}));
        menu.setId(menuId.intValue());
    }
}

