/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.SingleConnectionDatabase;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.commands.TransactionDatabaseCommand;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.MenuSaver;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.ImageSource;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.image.Format;
import imcode.util.io.FileInputStreamSource;
import imcode.util.io.FileUtility;
import imcode.util.io.InputStreamSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;

public class DocumentStoringVisitor
extends DocumentVisitor {
    private final ResultSetHandler singleStringHandler = new ResultSetHandler(){

        public Object handle(ResultSet rs) throws SQLException {
            return rs.next() ? rs.getString(1) : null;
        }
    };
    protected Database database;
    protected ImcmsServices services;
    private static final int FILE_BUFFER_LENGTH = 2048;
    private static final int DB_FIELD_MAX_LENGTH__FILENAME = 255;

    public DocumentStoringVisitor(Database database, ImcmsServices services) {
        this.database = database;
        this.services = services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFileDocumentFile(int fileDocumentId, FileDocumentDomainObject.FileDocumentFile fileDocumentFile, String fileId) {
        try {
            boolean sameFileOnDisk;
            InputStream in;
            InputStreamSource inputStreamSource = fileDocumentFile.getInputStreamSource();
            try {
                in = inputStreamSource.getInputStream();
            }
            catch (FileNotFoundException e) {
                throw new UnhandledException("The file for filedocument " + fileDocumentId + " has disappeared.", (Throwable)e);
            }
            if (null == in) {
                return;
            }
            File file = DocumentStoringVisitor.getFileForFileDocumentFile(fileDocumentId, fileId);
            FileInputStreamSource fileInputStreamSource = new FileInputStreamSource(file);
            boolean bl = sameFileOnDisk = file.exists() && inputStreamSource.equals(fileInputStreamSource);
            if (sameFileOnDisk) {
                return;
            }
            byte[] buffer = new byte[2048];
            FileOutputStream out = new FileOutputStream(file);
            try {
                int bytesRead;
                while (-1 != (bytesRead = in.read(buffer))) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                }
            }
            finally {
                ((OutputStream)out).close();
                in.close();
            }
            fileDocumentFile.setInputStreamSource(fileInputStreamSource);
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public static File getFileForFileDocumentFile(int fileDocumentId, String fileId) {
        File filePath = Imcms.getServices().getConfig().getFilePath();
        String filename = "" + fileDocumentId;
        if (StringUtils.isNotBlank((String)fileId)) {
            filename = filename + "." + FileUtility.escapeFilename(fileId);
        }
        return new File(filePath, filename);
    }

    static String makeSqlInsertString(String tableName, String[] columnNames) {
        return "INSERT INTO " + tableName + " (" + StringUtils.join((Object[])columnNames, (String)",") + ")" + "VALUES(?" + StringUtils.repeat((String)",?", (int)(columnNames.length - 1)) + ")";
    }

    void updateTextDocumentTexts(TextDocumentDomainObject textDocument, TextDocumentDomainObject oldTextDocument, UserDomainObject user) {
        Map<Integer, TextDomainObject> texts = textDocument.getTexts();
        Map<Integer, Boolean> modifiedTextIndexes = textDocument.getModifiedTextIndexes();
        boolean useModifiedTextIndexes = modifiedTextIndexes.size() > 0;
        Set<Integer> indexes = useModifiedTextIndexes ? modifiedTextIndexes.keySet() : texts.keySet();
        for (Integer textIndex : indexes) {
            boolean saveTextHistory;
            TextDomainObject text = texts.get(textIndex);
            boolean saveText = false;
            boolean bl = saveTextHistory = !useModifiedTextIndexes || modifiedTextIndexes.get(textIndex) != false;
            if (oldTextDocument == null) {
                saveText = true;
            } else {
                String oldTextValue;
                TextDomainObject oldText = oldTextDocument.getText(textIndex);
                String string = oldTextValue = oldText == null ? null : oldText.toString();
                if (oldTextValue == null) {
                    saveText = true;
                } else {
                    String lastHistoryTextValue = this.getLastHistoryTextValue(textDocument.getId(), textIndex, text.getType());
                    if (saveTextHistory && !oldTextValue.equals(lastHistoryTextValue)) {
                        this.sqlInsertTextHistory(oldTextDocument, textIndex, oldText, user);
                    }
                    if (!text.getText().equals(oldTextValue)) {
                        saveText = true;
                    }
                }
            }
            if (!saveText) continue;
            if (saveTextHistory) {
                this.sqlInsertTextHistory(textDocument, textIndex, text, user);
            }
            this.sqlDeleteText(textDocument, textIndex, text);
            this.sqlInsertText(textDocument, textIndex, text);
        }
    }

    private String getLastHistoryTextValue(int metaId, int name, int type) {
        String sql = "SELECT text FROM texts_history WHERE counter = (SELECT MAX(counter) FROM texts_history WHERE meta_id = ? AND name = ? AND type = ?)";
        Object[] parameters = new Object[]{metaId, name, type};
        return (String)this.database.execute((DatabaseCommand)new SqlQueryCommand(sql, parameters, this.singleStringHandler));
    }

    void updateTextDocumentImages(TextDocumentDomainObject textDocument, TextDocumentDomainObject oldTextDocument, UserDomainObject user) {
        Map<Integer, ImageDomainObject> images = textDocument.getImages();
        String sqlDeleteImages = "DELETE FROM images WHERE meta_id = ?";
        Object[] parameters = new String[]{"" + textDocument.getId()};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlDeleteImages, parameters));
        for (Integer imageIndex : images.keySet()) {
            ImageDomainObject image = images.get((int)imageIndex);
            if (oldTextDocument != null && oldTextDocument.getImage(imageIndex) != null && !oldTextDocument.getImage(imageIndex).getSource().toStorageString().equals("") && !image.equals(oldTextDocument.getImage(imageIndex))) {
                this.sqlInsertImageHistory(oldTextDocument, (int)imageIndex, user);
            }
            DocumentStoringVisitor.saveDocumentImage(textDocument.getId(), imageIndex, image);
        }
    }

    private void sqlInsertImageHistory(TextDocumentDomainObject textDocument, Integer imageIndex, UserDomainObject user) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String[] columnNames = new String[]{"imgurl", "width", "height", "border", "v_space", "h_space", "image_name", "target", "align", "alt_text", "low_scr", "linkurl", "type", "archive_image_id", "format", "crop_x1", "crop_y1", "crop_x2", "crop_y2", "meta_id", "name", "modified_datetime", "user_id"};
        ImageDomainObject image = textDocument.getImage(imageIndex);
        Object[] parameters = DocumentStoringVisitor.getSqlImageParameters(image, textDocument.getId(), imageIndex);
        ArrayList<Object> param = new ArrayList<Object>(Arrays.asList(parameters));
        param.add(dateFormat.format(new Date()));
        param.add(user.getId());
        this.database.execute((DatabaseCommand)new SqlUpdateCommand(DocumentStoringVisitor.makeSqlInsertString("images_history", columnNames), param.toArray(new Object[param.size()])));
    }

    void updateTextDocumentIncludes(TextDocumentDomainObject textDocument) {
        Map includes = textDocument.getIncludes();
        String sqlDeleteDocumentIncludes = "DELETE FROM includes WHERE meta_id = ?";
        Object[] parameters = new String[]{"" + textDocument.getId()};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlDeleteDocumentIncludes, parameters));
        for (Integer includeIndex : includes.keySet()) {
            Integer includedDocumentId = (Integer)includes.get(includeIndex);
            this.sqlInsertTextDocumentInclude(textDocument, includeIndex, includedDocumentId);
        }
    }

    private void sqlDeleteText(TextDocumentDomainObject textDocument, Integer textIndex, TextDomainObject text) {
        Object[] parameters = new String[]{"" + textDocument.getId(), "" + textIndex, "" + text.getType()};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand("DELETE FROM texts WHERE meta_id = ? AND name = ? AND type = ?", parameters));
    }

    private void sqlInsertText(TextDocumentDomainObject textDocument, Integer textIndex, TextDomainObject text) {
        Object[] parameters = new String[]{"" + textDocument.getId(), "" + textIndex, text.getText(), "" + text.getType()};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand("INSERT INTO texts (meta_id, name, text, type) VALUES(?,?,?,?)", parameters));
    }

    private void sqlInsertTextHistory(TextDocumentDomainObject textDocument, Integer textIndex, TextDomainObject text, UserDomainObject user) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Object[] parameters = new String[]{"" + textDocument.getId(), "" + textIndex, text.getText(), "" + text.getType(), dateFormat.format(new Date()), "" + user.getId()};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand("INSERT INTO texts_history (meta_id, name, text, type, modified_datetime, user_id) VALUES(?,?,?,?,?,?)", parameters));
    }

    private void sqlInsertTextDocumentInclude(TextDocumentDomainObject textDocument, Integer includeIndex, Integer includedDocumentId) {
        Object[] parameters = new String[]{"" + textDocument.getId(), "" + includeIndex, "" + includedDocumentId};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand("INSERT INTO includes (meta_id, include_id, included_meta_id) VALUES(?,?,?)", parameters));
    }

    public static void saveDocumentImage(int meta_id, int img_no, ImageDomainObject image) {
        String sqlStr = "update images\nset imgurl       = ?, \nwidth            = ?, \nheight           = ?, \nborder           = ?, \nv_space          = ?, \nh_space          = ?, \nimage_name       = ?, \ntarget           = ?, \nalign            = ?, \nalt_text         = ?, \nlow_scr          = ?, \nlinkurl          = ?, \ntype             = ?, \narchive_image_id = ?, \nformat      \t\t= ?, \ncrop_x1     \t\t= ?, \ncrop_y1     \t\t= ?, \ncrop_x2     \t\t= ?, \ncrop_y2     \t\t= ?  \nwhere meta_id = ? \nand name = ? \n";
        int rowUpdateCount = DocumentStoringVisitor.sqlImageUpdateQuery(sqlStr, image, meta_id, img_no);
        if (0 == rowUpdateCount) {
            sqlStr = "insert into images (imgurl, width, height, border, v_space, h_space, image_name, target, align, alt_text, low_scr, linkurl, type, archive_image_id, format, crop_x1, crop_y1, crop_x2, crop_y2, meta_id, name) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?,?,?,?,?,?,?)";
            DocumentStoringVisitor.sqlImageUpdateQuery(sqlStr, image, meta_id, img_no);
        }
    }

    private static int sqlImageUpdateQuery(String sqlStr, ImageDomainObject image, int meta_id, int img_no) {
        Object[] parameters = DocumentStoringVisitor.getSqlImageParameters(image, meta_id, img_no);
        return ((Number)Imcms.getServices().getDatabase().execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters))).intValue();
    }

    private static Object[] getSqlImageParameters(ImageDomainObject image, int meta_id, int img_no) {
        ImageSource imageSource = image.getSource();
        Format format = image.getFormat();
        ImageDomainObject.CropRegion region = image.getCropRegion();
        return new Object[]{imageSource.toStorageString(), image.getWidth(), image.getHeight(), image.getBorder(), image.getVerticalSpace(), image.getHorizontalSpace(), image.getName(), image.getTarget(), image.getAlign(), image.getAlternateText(), image.getLowResolutionUrl(), image.getLinkUrl(), imageSource.getTypeId(), image.getArchiveImageId(), format != null ? format.getOrdinal() : 0, region.isValid() ? region.getCropX1() : -1, region.isValid() ? region.getCropY1() : -1, region.isValid() ? region.getCropX2() : -1, region.isValid() ? region.getCropY2() : -1, meta_id, img_no};
    }

    public void visitFileDocument(FileDocumentDomainObject fileDocument) {
        Map fileDocumentFiles = fileDocument.getFiles();
        String sqlDelete = "DELETE FROM fileupload_docs WHERE meta_id = ?";
        Object[] parameters1 = new String[]{"" + fileDocument.getId()};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlDelete, parameters1));
        for (Map.Entry entry : fileDocumentFiles.entrySet()) {
            String fileId = (String)entry.getKey();
            FileDocumentDomainObject.FileDocumentFile fileDocumentFile = (FileDocumentDomainObject.FileDocumentFile)entry.getValue();
            String filename = fileDocumentFile.getFilename();
            if (filename.length() > 255) {
                filename = this.truncateFilename(filename, 255);
            }
            String sqlInsert = "INSERT INTO fileupload_docs (meta_id, variant_name, filename, mime, created_as_image, default_variant) VALUES(?,?,?,?,?,?)";
            boolean isDefaultFile = fileId.equals(fileDocument.getDefaultFileId());
            Object[] parameters = new String[]{"" + fileDocument.getId(), fileId, filename, fileDocumentFile.getMimeType(), fileDocumentFile.isCreatedAsImage() ? "1" : "0", isDefaultFile ? "1" : "0"};
            this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlInsert, parameters));
            this.saveFileDocumentFile(fileDocument.getId(), fileDocumentFile, fileId);
        }
        DocumentMapper.deleteOtherFileDocumentFiles(fileDocument);
    }

    private String truncateFilename(String filename, int length) {
        String truncatedFilename = StringUtils.left((String)filename, (int)length);
        String extensions = this.getExtensionsFromFilename(filename);
        if (extensions.length() > length) {
            return truncatedFilename;
        }
        String basename = StringUtils.chomp((String)filename, (String)extensions);
        String truncatedBasename = StringUtils.substring((String)basename, (int)0, (int)(length - extensions.length()));
        truncatedFilename = truncatedBasename + extensions;
        return truncatedFilename;
    }

    private String getExtensionsFromFilename(String filename) {
        String extensions = "";
        Matcher matcher = Pattern.compile("(?:\\.\\w+)+$").matcher(filename);
        if (matcher.find()) {
            extensions = matcher.group();
        }
        return extensions;
    }

    public void visitBrowserDocument(BrowserDocumentDomainObject browserDocument) {
        this.deleteBrowserDocument(browserDocument);
        this.saveNewBrowserDocument(browserDocument);
    }

    private void deleteBrowserDocument(BrowserDocumentDomainObject browserDocument) {
        String sqlStr = "DELETE FROM browser_docs WHERE meta_id = ?";
        Object[] parameters = new String[]{"" + browserDocument.getId()};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters));
    }

    public void saveNewBrowserDocument(BrowserDocumentDomainObject document) {
        String[] browserDocumentColumns = new String[]{"meta_id", "to_meta_id", "browser_id"};
        String sqlBrowserDocsInsertStr = DocumentStoringVisitor.makeSqlInsertString("browser_docs", browserDocumentColumns);
        Map browserDocumentMap = document.getBrowserDocumentIdMap();
        for (BrowserDocumentDomainObject.Browser browser : browserDocumentMap.keySet()) {
            Integer metaIdForBrowser = (Integer)browserDocumentMap.get(browser);
            Object[] parameters = new String[]{"" + document.getId(), "" + metaIdForBrowser, "" + browser.getId()};
            this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlBrowserDocsInsertStr, parameters));
        }
    }

    protected void updateTextDocumentMenus(final TextDocumentDomainObject textDocument, final TextDocumentDomainObject oldTextDocument, final UserDomainObject savingUser) {
        this.database.execute((DatabaseCommand)new TransactionDatabaseCommand(){

            public Object executeInTransaction(DatabaseConnection connection) {
                MenuSaver menuSaver = new MenuSaver((Database)new SingleConnectionDatabase(connection));
                menuSaver.updateTextDocumentMenus(textDocument, DocumentStoringVisitor.this.services, oldTextDocument, savingUser);
                return null;
            }
        });
    }
}

