/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.imcms.mapping.DocumentStoringVisitor;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;

public class DocumentSavingVisitor
extends DocumentStoringVisitor {
    private DocumentDomainObject oldDocument;
    private UserDomainObject savingUser;

    public DocumentSavingVisitor(DocumentDomainObject documentInDatabase, Database database, ImcmsServices services, UserDomainObject user) {
        super(database, services);
        this.oldDocument = documentInDatabase;
        this.savingUser = user;
    }

    public void visitHtmlDocument(HtmlDocumentDomainObject htmlDocument) {
        String sqlStr = "UPDATE frameset_docs SET frame_set = ? WHERE meta_id = ?";
        Object[] parameters = new String[]{htmlDocument.getHtml(), "" + htmlDocument.getId()};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters));
    }

    public void visitUrlDocument(UrlDocumentDomainObject urlDocument) {
        String sqlStr = "UPDATE url_docs SET url_ref = ? WHERE meta_id = ?";
        Object[] parameters = new String[]{urlDocument.getUrl(), "" + urlDocument.getId()};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters));
    }

    public void visitTextDocument(TextDocumentDomainObject textDocument) {
        boolean menusChanged;
        String sqlStr = "UPDATE text_docs SET template_name = ?, group_id = ?,\ndefault_template = ?, default_template_1 = ?, default_template_2 = ? WHERE meta_id = ?";
        String defaultTemplateId = textDocument.getDefaultTemplateName();
        String defaultTemplateIdForRestricted1 = textDocument.getDefaultTemplateNameForRestricted1();
        String defaultTemplateIdForRestricted2 = textDocument.getDefaultTemplateNameForRestricted2();
        String templateId = textDocument.getTemplateName();
        int templateGroupId = textDocument.getTemplateGroupId();
        Object[] parameters = new String[]{"" + templateId, "" + templateGroupId, null != defaultTemplateId ? "" + defaultTemplateId : null, null != defaultTemplateIdForRestricted1 ? "" + defaultTemplateIdForRestricted1 : null, null != defaultTemplateIdForRestricted2 ? "" + defaultTemplateIdForRestricted2 : null, "" + textDocument.getId()};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters));
        this.updateTextDocumentTexts(textDocument, (TextDocumentDomainObject)this.oldDocument, this.savingUser);
        this.updateTextDocumentImages(textDocument, (TextDocumentDomainObject)this.oldDocument, this.savingUser);
        this.updateTextDocumentIncludes(textDocument);
        boolean bl = menusChanged = !((Object)textDocument.getMenus()).equals(((TextDocumentDomainObject)this.oldDocument).getMenus());
        if (menusChanged) {
            this.updateTextDocumentMenus(textDocument, (TextDocumentDomainObject)this.oldDocument, this.savingUser);
        }
    }
}

