/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.commands.SqlUpdateDatabaseCommand;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.mapping.AliasAlreadyExistsInternalException;
import com.imcode.imcms.mapping.CategoryMapper;
import com.imcode.imcms.mapping.DocumentCreatingVisitor;
import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentSaveException;
import com.imcode.imcms.mapping.DocumentSavingVisitor;
import com.imcode.imcms.mapping.NoPermissionInternalException;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.RoleIdToDocumentPermissionSetTypeMappings;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

class DocumentSaver {
    private final DocumentMapper documentMapper;
    private static final int META_HEADLINE_MAX_LENGTH = 255;
    private static final int META_TEXT_MAX_LENGTH = 1000;
    public static final String SQL_DELETE_ROLE_DOCUMENT_PERMISSION_SET_ID = "DELETE FROM roles_rights WHERE role_id = ? AND meta_id = ?";
    public static final String SQL_SET_ROLE_DOCUMENT_PERMISSION_SET_ID = "INSERT INTO roles_rights (role_id, meta_id, set_id) VALUES(?,?,?)";

    DocumentSaver(DocumentMapper documentMapper) {
        this.documentMapper = documentMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDocument(DocumentDomainObject document, DocumentDomainObject oldDocument, UserDomainObject user) throws NoPermissionInternalException, DocumentSaveException {
        this.checkDocumentForSave(document);
        document.loadAllLazilyLoaded();
        try {
            Date lastModifiedDatetime = Utility.truncateDateToMinutePrecision(document.getActualModifiedDatetime());
            Date modifiedDatetime = Utility.truncateDateToMinutePrecision(document.getModifiedDatetime());
            boolean modifiedDatetimeUnchanged = lastModifiedDatetime.equals(modifiedDatetime);
            if (modifiedDatetimeUnchanged) {
                document.setModifiedDatetime(this.documentMapper.getClock().getCurrentDate());
            }
            this.sqlUpdateMeta(document);
            this.updateDocumentSectionsCategoriesKeywords(document);
            this.updateDocumentProperties(document);
            if (user.canEditPermissionsFor(oldDocument)) {
                this.updateDocumentRolePermissions(document, user, oldDocument);
                this.documentMapper.getDocumentPermissionSetMapper().saveRestrictedDocumentPermissionSets(document, user, oldDocument);
            }
            document.accept(new DocumentSavingVisitor(oldDocument, this.getDatabase(), this.documentMapper.getImcmsServices(), user));
        }
        finally {
            this.documentMapper.invalidateDocument(document);
        }
    }

    private void sqlUpdateMeta(DocumentDomainObject document) {
        String headline = document.getHeadline();
        String text = document.getMenuText();
        StringBuffer sqlStr = new StringBuffer("update meta set ");
        ArrayList sqlUpdateColumns = new ArrayList();
        ArrayList<String> sqlUpdateValues = new ArrayList<String>();
        DocumentSaver.makeDateSqlUpdateClause("publication_start_datetime", document.getPublicationStartDatetime(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeDateSqlUpdateClause("publication_end_datetime", document.getPublicationEndDatetime(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeDateSqlUpdateClause("archived_datetime", document.getArchivedDatetime(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeDateSqlUpdateClause("date_created", document.getCreatedDatetime(), sqlUpdateColumns, sqlUpdateValues);
        String headlineThatFitsInDB = headline.substring(0, Math.min(headline.length(), 254));
        DocumentSaver.makeStringSqlUpdateClause("meta_headline", headlineThatFitsInDB, sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeStringSqlUpdateClause("meta_image", document.getMenuImage(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeDateSqlUpdateClause("date_modified", document.getModifiedDatetime(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeStringSqlUpdateClause("target", document.getTarget(), sqlUpdateColumns, sqlUpdateValues);
        String textThatFitsInDB = text.substring(0, Math.min(text.length(), 999));
        DocumentSaver.makeStringSqlUpdateClause("meta_text", textThatFitsInDB, sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeStringSqlUpdateClause("lang_prefix", document.getLanguageIso639_2(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeBooleanSqlUpdateClause("disable_search", document.isSearchDisabled(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeBooleanSqlUpdateClause("shared", document.isLinkableByOtherUsers(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeBooleanSqlUpdateClause("show_meta", document.isLinkedForUnauthorizedUsers(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeBooleanSqlUpdateClause("permissions", document.isRestrictedOneMorePrivilegedThanRestrictedTwo(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeIntSqlUpdateClause("publisher_id", document.getPublisherId(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeIntSqlUpdateClause("owner_id", new Integer(document.getCreatorId()), sqlUpdateColumns, sqlUpdateValues);
        Document.PublicationStatus publicationStatus = document.getPublicationStatus();
        int publicationStatusInt = DocumentSaver.convertPublicationStatusToInt(publicationStatus);
        DocumentSaver.makeIntSqlUpdateClause("status", new Integer(publicationStatusInt), sqlUpdateColumns, sqlUpdateValues);
        sqlStr.append(StringUtils.join(sqlUpdateColumns.iterator(), (String)","));
        sqlStr.append(" where meta_id = ?");
        sqlUpdateValues.add("" + document.getId());
        Object[] params = sqlUpdateValues.toArray(new String[sqlUpdateValues.size()]);
        this.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand(sqlStr.toString(), params));
    }

    static int convertPublicationStatusToInt(Document.PublicationStatus publicationStatus) {
        int publicationStatusInt = 0;
        if (Document.PublicationStatus.APPROVED.equals(publicationStatus)) {
            publicationStatusInt = 2;
        } else if (Document.PublicationStatus.DISAPPROVED.equals(publicationStatus)) {
            publicationStatusInt = 1;
        }
        return publicationStatusInt;
    }

    private void updateDocumentSectionsCategoriesKeywords(DocumentDomainObject document) {
        this.updateDocumentSections(document.getId(), document.getSectionIds());
        new CategoryMapper(this.getDatabase()).updateDocumentCategories(document);
        this.updateDocumentKeywords(document);
    }

    private Database getDatabase() {
        return this.documentMapper.getDatabase();
    }

    void saveNewDocument(UserDomainObject user, DocumentDomainObject document, boolean copying) throws NoPermissionToAddDocumentToMenuException, DocumentSaveException {
        boolean inheritRestrictedPermissions;
        this.checkDocumentForSave(document);
        document.loadAllLazilyLoaded();
        this.documentMapper.setCreatedAndModifiedDatetimes(document, new Date());
        int newMetaId = this.sqlInsertIntoMeta(document);
        boolean bl = inheritRestrictedPermissions = !user.isSuperAdminOrHasFullPermissionOn(document) && !copying;
        if (inheritRestrictedPermissions) {
            document.getPermissionSets().setRestricted1(document.getPermissionSetsForNewDocuments().getRestricted1());
            document.getPermissionSets().setRestricted2(document.getPermissionSetsForNewDocuments().getRestricted2());
        }
        document.setId(newMetaId);
        this.updateDocumentSectionsCategoriesKeywords(document);
        this.updateDocumentProperties(document);
        this.updateDocumentRolePermissions(document, user, null);
        this.documentMapper.getDocumentPermissionSetMapper().saveRestrictedDocumentPermissionSets(document, user, null);
        document.accept(new DocumentCreatingVisitor(this.getDatabase(), this.documentMapper.getImcmsServices(), user));
        this.documentMapper.invalidateDocument(document);
    }

    private void checkDocumentForSave(DocumentDomainObject document) throws NoPermissionInternalException, DocumentSaveException {
        this.documentMapper.getCategoryMapper().checkMaxDocumentCategoriesOfType(document);
        this.checkIfAliasAlreadyExist(document);
    }

    void updateDocumentRolePermissions(DocumentDomainObject document, UserDomainObject user, DocumentDomainObject oldDocument) {
        RoleIdToDocumentPermissionSetTypeMappings.Mapping mapping;
        int i;
        RoleIdToDocumentPermissionSetTypeMappings mappings = new RoleIdToDocumentPermissionSetTypeMappings();
        if (null != oldDocument) {
            RoleIdToDocumentPermissionSetTypeMappings.Mapping[] oldDocumentMappings = oldDocument.getRoleIdsMappedToDocumentPermissionSetTypes().getMappings();
            for (i = 0; i < oldDocumentMappings.length; ++i) {
                mapping = oldDocumentMappings[i];
                mappings.setPermissionSetTypeForRole(mapping.getRoleId(), DocumentPermissionSetTypeDomainObject.NONE);
            }
        }
        RoleIdToDocumentPermissionSetTypeMappings.Mapping[] documentMappings = document.getRoleIdsMappedToDocumentPermissionSetTypes().getMappings();
        for (i = 0; i < documentMappings.length; ++i) {
            mapping = documentMappings[i];
            mappings.setPermissionSetTypeForRole(mapping.getRoleId(), mapping.getDocumentPermissionSetType());
        }
        RoleIdToDocumentPermissionSetTypeMappings.Mapping[] mappingsArray = mappings.getMappings();
        for (int i2 = 0; i2 < mappingsArray.length; ++i2) {
            RoleIdToDocumentPermissionSetTypeMappings.Mapping mapping2 = mappingsArray[i2];
            RoleId roleId = mapping2.getRoleId();
            DocumentPermissionSetTypeDomainObject documentPermissionSetType = mapping2.getDocumentPermissionSetType();
            if (null != oldDocument && !user.canSetDocumentPermissionSetTypeForRoleIdOnDocument(documentPermissionSetType, roleId, oldDocument)) continue;
            Object[] params1 = new String[]{"" + roleId, "" + document.getId()};
            this.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand(SQL_DELETE_ROLE_DOCUMENT_PERMISSION_SET_ID, params1));
            if (DocumentPermissionSetTypeDomainObject.NONE.equals(documentPermissionSetType)) continue;
            Object[] params = new String[]{"" + roleId.intValue(), "" + document.getId(), "" + documentPermissionSetType};
            this.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand(SQL_SET_ROLE_DOCUMENT_PERMISSION_SET_ID, params));
        }
    }

    static void makeBooleanSqlUpdateClause(String columnName, boolean bool, List sqlUpdateColumns, List sqlUpdateValues) {
        sqlUpdateColumns.add(columnName + " = ?");
        sqlUpdateValues.add(bool ? "1" : "0");
    }

    static void makeDateSqlUpdateClause(String columnName, Date date, List sqlUpdateColumns, List sqlUpdateValues) {
        DocumentSaver.makeStringSqlUpdateClause(columnName, Utility.makeSqlStringFromDate(date), sqlUpdateColumns, sqlUpdateValues);
    }

    static void makeIntSqlUpdateClause(String columnName, Integer integer, ArrayList sqlUpdateColumns, ArrayList sqlUpdateValues) {
        if (null != integer) {
            sqlUpdateColumns.add(columnName + " = ?");
            sqlUpdateValues.add("" + integer);
        } else {
            sqlUpdateColumns.add(columnName + " = NULL");
        }
    }

    static void makeStringSqlUpdateClause(String columnName, String value, List sqlUpdateColumns, List sqlUpdateValues) {
        if (null != value) {
            sqlUpdateColumns.add(columnName + " = ?");
            sqlUpdateValues.add(value);
        } else {
            sqlUpdateColumns.add(columnName + " = NULL");
        }
    }

    private int sqlInsertIntoMeta(DocumentDomainObject document) {
        Number documentId = (Number)this.getDatabase().execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("meta", (Object[][])new String[][]{{"doc_type", document.getDocumentTypeId() + ""}, {"meta_headline", document.getHeadline()}, {"meta_text", document.getMenuText()}, {"meta_image", document.getMenuImage()}, {"owner_id", document.getCreatorId() + ""}, {"permissions", this.makeSqlStringFromBoolean(document.isRestrictedOneMorePrivilegedThanRestrictedTwo())}, {"shared", this.makeSqlStringFromBoolean(document.isLinkableByOtherUsers())}, {"show_meta", this.makeSqlStringFromBoolean(document.isLinkedForUnauthorizedUsers())}, {"lang_prefix", document.getLanguageIso639_2()}, {"date_created", Utility.makeSqlStringFromDate(document.getCreatedDatetime())}, {"date_modified", Utility.makeSqlStringFromDate(document.getModifiedDatetime())}, {"disable_search", this.makeSqlStringFromBoolean(document.isSearchDisabled())}, {"target", document.getTarget()}, {"activate", "1"}, {"archived_datetime", Utility.makeSqlStringFromDate(document.getArchivedDatetime())}, {"publisher_id", null != document.getPublisherId() ? document.getPublisherId() + "" : null}, {"status", "" + document.getPublicationStatus()}, {"publication_start_datetime", Utility.makeSqlStringFromDate(document.getPublicationStartDatetime())}, {"publication_end_datetime", Utility.makeSqlStringFromDate(document.getPublicationEndDatetime())}}));
        return documentId.intValue();
    }

    private String makeSqlStringFromBoolean(boolean bool) {
        return bool ? "1" : "0";
    }

    Set getDocumentsAddedWithoutPermission(TextDocumentDomainObject textDocument, TextDocumentDomainObject oldTextDocument, final UserDomainObject user, DocumentGetter documentGetter) {
        Set documentIdsAdded = this.getDocumentIdsAdded(textDocument, oldTextDocument);
        List documents = documentGetter.getDocuments(documentIdsAdded);
        Collection documentsAddedWithoutPermission = CollectionUtils.select((Collection)documents, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return !user.canAddDocumentToAnyMenu((DocumentDomainObject)object);
            }
        });
        return new HashSet(documentsAddedWithoutPermission);
    }

    private Set getDocumentIdsAdded(TextDocumentDomainObject textDocument, TextDocumentDomainObject oldTextDocument) {
        Set documentIdsAdded = null != oldTextDocument ? this.getChildDocumentIdsDifference(textDocument, oldTextDocument) : textDocument.getChildDocumentIds();
        return documentIdsAdded;
    }

    private Set getChildDocumentIdsDifference(TextDocumentDomainObject minuend, TextDocumentDomainObject subtrahend) {
        Set minuendChildDocumentIds = minuend.getChildDocumentIds();
        Set subtrahendChildDocumentIds = subtrahend.getChildDocumentIds();
        HashSet result = new HashSet(minuendChildDocumentIds);
        result.removeAll(subtrahendChildDocumentIds);
        return result;
    }

    void updateDocumentKeywords(DocumentDomainObject document) {
        int meta_id = document.getId();
        Set keywords = document.getKeywords();
        HashSet<String> allKeywords = new HashSet<String>(Arrays.asList(this.documentMapper.getAllKeywords()));
        this.deleteKeywordsFromDocument(meta_id);
        for (String keyword : keywords) {
            boolean keywordExists = allKeywords.contains(keyword);
            if (!keywordExists) {
                this.addKeyword(keyword);
            }
            this.addExistingKeywordToDocument(meta_id, keyword);
        }
        this.deleteUnusedKeywords();
    }

    void updateDocumentProperties(DocumentDomainObject document) {
        int meta_id = document.getId();
        Map<String, String> properties = document.getProperties();
        this.deletePropertiesFromDocumnet(meta_id);
        for (String key : properties.keySet()) {
            Object[] params = new String[]{meta_id + "", key, properties.get(key)};
            this.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("INSERT INTO document_properties (meta_id, key_name, value) VALUES(?,?,?)", params));
        }
    }

    private void deletePropertiesFromDocumnet(int meta_id) {
        Object[] params = new String[]{meta_id + ""};
        this.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("DELETE FROM document_properties WHERE meta_id = ?", params));
    }

    void updateDocumentSections(int metaId, Set sectionIds) {
        this.removeAllSectionsFromDocument(metaId);
        for (Integer sectionId : sectionIds) {
            this.addSectionIdToDocument(metaId, sectionId);
        }
    }

    private void addSectionIdToDocument(int metaId, Integer sectionId) {
        Object[] params = new Integer[]{new Integer(metaId), sectionId};
        this.getDatabase().execute((DatabaseCommand)new SqlUpdateDatabaseCommand("INSERT INTO meta_section VALUES(?,?)", params));
    }

    private void deleteKeywordsFromDocument(int meta_id) {
        String sqlDeleteKeywordsFromDocument = "DELETE FROM meta_classification WHERE meta_id = ?";
        Object[] params = new String[]{"" + meta_id};
        this.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand(sqlDeleteKeywordsFromDocument, params));
    }

    private void deleteUnusedKeywords() {
        Object[] params = new String[]{};
        this.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("DELETE FROM classification WHERE class_id NOT IN (SELECT class_id FROM meta_classification)", params));
    }

    private void addKeyword(String keyword) {
        Object[] params = new String[]{keyword};
        this.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("INSERT INTO classification (code) VALUES(?)", params));
    }

    private void removeAllSectionsFromDocument(int metaId) {
        Object[] params = new String[]{"" + metaId};
        this.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("DELETE FROM meta_section WHERE meta_id = ?", params));
    }

    private void addExistingKeywordToDocument(int meta_id, String keyword) {
        Object[] params1 = new String[]{keyword};
        int keywordId = Integer.parseInt((String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT class_id FROM classification WHERE code = ?", params1, Utility.SINGLE_STRING_HANDLER)));
        Object[] params = new String[]{"" + meta_id, "" + keywordId};
        this.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("INSERT INTO meta_classification (meta_id, class_id) VALUES(?,?)", params));
    }

    public void checkIfAliasAlreadyExist(DocumentDomainObject document) throws AliasAlreadyExistsInternalException {
        String alias;
        Set<String> allAlias = this.documentMapper.getAllDocumentAlias();
        if (allAlias.contains(alias = document.getAlias()) && !this.documentMapper.getDocument(alias).equals(document)) {
            throw new AliasAlreadyExistsInternalException("A document with alias '" + document.getAlias() + "' already exists");
        }
    }
}

