/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.CompositeDatabaseCommand;
import com.imcode.db.commands.DeleteWhereColumnsEqualDatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateDatabaseCommand;
import com.imcode.db.handlers.CollectionHandler;
import com.imcode.db.handlers.RowTransformer;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.flow.DocumentPageFlow;
import com.imcode.imcms.mapping.CachingDocumentGetter;
import com.imcode.imcms.mapping.CategoryMapper;
import com.imcode.imcms.mapping.DatabaseDocumentGetter;
import com.imcode.imcms.mapping.DocumentDeletingVisitor;
import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentPermissionSetMapper;
import com.imcode.imcms.mapping.DocumentSaveException;
import com.imcode.imcms.mapping.DocumentSaver;
import com.imcode.imcms.mapping.DocumentSavingVisitor;
import com.imcode.imcms.mapping.FragmentingDocumentGetter;
import com.imcode.imcms.mapping.NoPermissionInternalException;
import imcode.server.Config;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.DocumentReference;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.GetterDocumentReference;
import imcode.server.document.NoPermissionToEditDocumentException;
import imcode.server.document.SectionDomainObject;
import imcode.server.document.index.DocumentIndex;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Clock;
import imcode.util.LazilyLoadedObject;
import imcode.util.SystemClock;
import imcode.util.Utility;
import imcode.util.io.FileUtility;
import java.io.File;
import java.io.FileFilter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.math.IntRange;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.oro.text.perl.Perl5Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentMapper
implements DocumentGetter {
    private static final String SQL_GET_ALL_SECTIONS = "SELECT section_id, section_name FROM sections";
    private static final String SQL_GET_DOCUMENT_ID_FROM_PROPERTIES = "SELECT meta_id FROM document_properties WHERE key_name=? AND value=?";
    private static final String COPY_HEADLINE_SUFFIX_TEMPLATE = "copy_prefix.html";
    private Database database;
    private DocumentPermissionSetMapper documentPermissionSetMapper;
    private DocumentIndex documentIndex;
    private Map documentCache;
    private Clock clock = new SystemClock();
    private ImcmsServices imcmsServices;
    private DocumentGetter documentGetter;
    private DocumentSaver documentSaver;
    private CategoryMapper categoryMapper;
    private LazilyLoadedObject sections;
    private static final SectionNameComparator SECTION_NAME_COMPARATOR = new SectionNameComparator();

    public DocumentMapper(ImcmsServices services, Database database) {
        this.imcmsServices = services;
        this.database = database;
        Config config = services.getConfig();
        int documentCacheMaxSize = config.getDocumentCacheMaxSize();
        this.documentCache = Collections.synchronizedMap(new LRUMap(documentCacheMaxSize));
        this.setDocumentGetter(new FragmentingDocumentGetter(new DatabaseDocumentGetter(database, services)));
        this.documentPermissionSetMapper = new DocumentPermissionSetMapper(database);
        this.categoryMapper = new CategoryMapper(database);
        this.documentSaver = new DocumentSaver(this);
        this.initSections();
    }

    public void initSections() {
        this.sections = new LazilyLoadedObject(new SectionsSetLoader());
    }

    public void setDocumentGetter(DocumentGetter documentGetter) {
        this.documentGetter = new CachingDocumentGetter(documentGetter, this.documentCache);
    }

    public DocumentSaver getDocumentSaver() {
        return this.documentSaver;
    }

    public DocumentDomainObject createDocumentOfTypeFromParent(int documentTypeId, DocumentDomainObject parent, UserDomainObject user) {
        DocumentDomainObject newDocument;
        try {
            if (2 == documentTypeId) {
                newDocument = (DocumentDomainObject)parent.clone();
                TextDocumentDomainObject newTextDocument = (TextDocumentDomainObject)newDocument;
                newTextDocument.removeAllTexts();
                newTextDocument.removeAllImages();
                newTextDocument.removeAllIncludes();
                newTextDocument.removeAllMenus();
                this.setTemplateForNewTextDocument(newTextDocument, user, parent);
            } else {
                newDocument = DocumentDomainObject.fromDocumentTypeId(documentTypeId);
                newDocument.setAttributes((DocumentDomainObject.Attributes)parent.getAttributes().clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new UnhandledException((Throwable)e);
        }
        newDocument.setId(0);
        newDocument.setHeadline("");
        newDocument.setMenuText("");
        newDocument.setMenuImage("");
        newDocument.setProperties(new HashMap());
        this.makeDocumentLookNew(newDocument, user);
        this.removeNonInheritedCategories(newDocument);
        return newDocument;
    }

    void setTemplateForNewTextDocument(TextDocumentDomainObject newTextDocument, UserDomainObject user, DocumentDomainObject parent) {
        DocumentPermissionSetTypeDomainObject documentPermissionSetType = user.getDocumentPermissionSetTypeFor(parent);
        String templateName = null;
        if (DocumentPermissionSetTypeDomainObject.RESTRICTED_1.equals(documentPermissionSetType)) {
            templateName = newTextDocument.getDefaultTemplateNameForRestricted1();
        } else if (DocumentPermissionSetTypeDomainObject.RESTRICTED_2.equals(documentPermissionSetType)) {
            templateName = newTextDocument.getDefaultTemplateNameForRestricted2();
        }
        if (null == templateName && parent instanceof TextDocumentDomainObject) {
            templateName = ((TextDocumentDomainObject)parent).getDefaultTemplateName();
        }
        if (null != templateName) {
            newTextDocument.setTemplateName(templateName);
        }
    }

    void makeDocumentLookNew(DocumentDomainObject document, UserDomainObject user) {
        Date now = new Date();
        document.setCreator(user);
        this.setCreatedAndModifiedDatetimes(document, now);
        document.setPublicationStartDatetime(now);
        document.setArchivedDatetime(null);
        document.setPublicationEndDatetime(null);
        document.setPublicationStatus(Document.PublicationStatus.NEW);
    }

    public SectionDomainObject[] getAllSections() {
        Object[] parameters = new String[]{};
        String[][] sqlRows = (String[][])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(SQL_GET_ALL_SECTIONS, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
        SectionDomainObject[] allSections = new SectionDomainObject[sqlRows.length];
        for (int i = 0; i < sqlRows.length; ++i) {
            int sectionId = Integer.parseInt(sqlRows[i][0]);
            String sectionName = sqlRows[i][1];
            allSections[i] = new SectionDomainObject(sectionId, sectionName);
        }
        Arrays.sort(allSections, SECTION_NAME_COMPARATOR);
        return allSections;
    }

    public DocumentDomainObject getDocument(int documentId) {
        return this.getDocument(new Integer(documentId));
    }

    public DocumentReference getDocumentReference(DocumentDomainObject document) {
        return this.getDocumentReference(document.getId());
    }

    public DocumentReference getDocumentReference(int childId) {
        return new GetterDocumentReference(childId, this.documentGetter);
    }

    public SectionDomainObject getSectionById(int sectionId) {
        SectionsSet sectionsSet = (SectionsSet)this.sections.get();
        return sectionsSet.getSectionById(sectionId);
    }

    public SectionDomainObject getSectionByName(String name) {
        SectionsSet sectionsSet = (SectionsSet)this.sections.get();
        return sectionsSet.getSectionByName(name);
    }

    public void saveNewDocument(DocumentDomainObject document, UserDomainObject user, boolean copying) throws DocumentSaveException, NoPermissionToAddDocumentToMenuException {
        this.documentSaver.saveNewDocument(user, document, copying);
    }

    public void saveDocument(DocumentDomainObject document, UserDomainObject user) throws DocumentSaveException, NoPermissionToAddDocumentToMenuException, NoPermissionToEditDocumentException {
        DocumentDomainObject oldDocument = this.getDocument(document.getId());
        this.documentSaver.saveDocument(document, oldDocument, user);
    }

    public void invalidateDocument(DocumentDomainObject document) {
        this.documentIndex.indexDocument(document);
        this.documentCache.remove(new Integer(document.getId()));
    }

    public DocumentIndex getDocumentIndex() {
        return this.documentIndex;
    }

    public String[][] getParentDocumentAndMenuIdsForDocument(DocumentDomainObject document) {
        String sqlStr = "SELECT meta_id,menu_index FROM childs, menus WHERE menus.menu_id = childs.menu_id AND to_meta_id = ?";
        Object[] parameters = new String[]{"" + document.getId()};
        return (String[][])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
    }

    public String[][] getAllMimeTypesWithDescriptions(UserDomainObject user) {
        String sqlStr = "SELECT mime, mime_name FROM mime_types WHERE lang_prefix = ? AND mime_id > 0 ORDER BY mime_id";
        Object[] parameters = new String[]{user.getLanguageIso639_2()};
        return (String[][])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
    }

    public String[] getAllMimeTypes() {
        String sqlStr = "SELECT mime FROM mime_types WHERE mime_id > 0 ORDER BY mime_id";
        Object[] params = new String[]{};
        return (String[])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, params, Utility.STRING_ARRAY_HANDLER));
    }

    public BrowserDocumentDomainObject.Browser[] getAllBrowsers() {
        String sqlStr = "SELECT browser_id, name, value FROM browsers WHERE browser_id != 0";
        Object[] parameters = new String[]{};
        String[][] sqlResult = (String[][])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
        ArrayList<BrowserDocumentDomainObject.Browser> browsers = new ArrayList<BrowserDocumentDomainObject.Browser>();
        for (int i = 0; i < sqlResult.length; ++i) {
            browsers.add(this.createBrowserFromSqlRow(sqlResult[i]));
        }
        return browsers.toArray(new BrowserDocumentDomainObject.Browser[browsers.size()]);
    }

    public BrowserDocumentDomainObject.Browser getBrowserById(int browserIdToGet) {
        if (browserIdToGet == BrowserDocumentDomainObject.Browser.DEFAULT.getId()) {
            return BrowserDocumentDomainObject.Browser.DEFAULT;
        }
        String sqlStr = "SELECT browser_id, name, value FROM browsers WHERE browser_id = ?";
        Object[] params = new String[]{"" + browserIdToGet};
        String[] sqlRow = (String[])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, params, Utility.STRING_ARRAY_HANDLER));
        return this.createBrowserFromSqlRow(sqlRow);
    }

    protected BrowserDocumentDomainObject.Browser createBrowserFromSqlRow(String[] sqlRow) {
        int browserId = Integer.parseInt(sqlRow[0]);
        String browserName = sqlRow[1];
        int browserSpecificity = Integer.parseInt(sqlRow[2]);
        return new BrowserDocumentDomainObject.Browser(browserId, browserName, browserSpecificity);
    }

    public void deleteDocument(DocumentDomainObject document, UserDomainObject user) {
        DatabaseCommand deleteDocumentCommand = this.createDeleteDocumentCommand(document);
        this.getDatabase().execute(deleteDocumentCommand);
        document.accept(new DocumentDeletingVisitor());
        this.documentIndex.removeDocument(document);
        this.documentCache.remove(new Integer(document.getId()));
    }

    private DatabaseCommand createDeleteDocumentCommand(DocumentDomainObject document) {
        if (document instanceof TextDocumentDomainObject) {
            TextDocumentDomainObject textDoc = (TextDocumentDomainObject)document;
            this.imcmsServices.getImageCacheMapper().deleteDocumentImagesCache(document.getId(), textDoc.getImages());
        }
        String metaIdStr = "" + document.getId();
        String metaIdColumn = "meta_id";
        return new CompositeDatabaseCommand(new DatabaseCommand[]{new DeleteWhereColumnsEqualDatabaseCommand("document_categories", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("meta_classification", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("childs", "to_meta_id", (Object)metaIdStr), new SqlUpdateDatabaseCommand("DELETE FROM childs WHERE menu_id IN (SELECT menu_id FROM menus WHERE meta_id = ?)", (Object[])new String[]{metaIdStr}), new DeleteWhereColumnsEqualDatabaseCommand("menus", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("text_docs", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("texts", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("images", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("roles_rights", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("user_rights", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("url_docs", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("browser_docs", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("fileupload_docs", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("frameset_docs", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("new_doc_permission_sets_ex", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("new_doc_permission_sets", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("doc_permission_sets_ex", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("doc_permission_sets", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("includes", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("includes", "included_meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("texts_history", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("images_history", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("childs_history", "to_meta_id", (Object)metaIdStr), new SqlUpdateDatabaseCommand("DELETE FROM childs_history WHERE menu_id IN (SELECT menu_id FROM menus_history WHERE meta_id = ?)", (Object[])new String[]{metaIdStr}), new DeleteWhereColumnsEqualDatabaseCommand("menus_history", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("document_properties", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("meta_section", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("meta", "meta_id", (Object)metaIdStr)});
    }

    public Map getAllDocumentTypeIdsAndNamesInUsersLanguage(UserDomainObject user) {
        Object[] parameters = new String[]{user.getLanguageIso639_2()};
        String[][] rows = (String[][])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT doc_type, type FROM doc_types WHERE lang_prefix = ? ORDER BY doc_type", parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
        TreeMap<Integer, String> allDocumentTypeIdsAndNamesInUsersLanguage = new TreeMap<Integer, String>();
        for (int i = 0; i < rows.length; ++i) {
            String[] row = rows[i];
            Integer documentTypeId = Integer.valueOf(row[0]);
            String documentTypeNameInUsersLanguage = row[1];
            allDocumentTypeIdsAndNamesInUsersLanguage.put(documentTypeId, documentTypeNameInUsersLanguage);
        }
        return allDocumentTypeIdsAndNamesInUsersLanguage;
    }

    public TextDocumentMenuIndexPair[] getDocumentMenuPairsContainingDocument(DocumentDomainObject document) {
        String sqlSelectMenus = "SELECT meta_id, menu_index FROM menus, childs WHERE menus.menu_id = childs.menu_id AND childs.to_meta_id = ? ORDER BY meta_id, menu_index";
        Object[] parameters = new String[]{"" + document.getId()};
        String[][] sqlRows = (String[][])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlSelectMenus, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
        TextDocumentMenuIndexPair[] documentMenuPairs = new TextDocumentMenuIndexPair[sqlRows.length];
        for (int i = 0; i < sqlRows.length; ++i) {
            String[] sqlRow = sqlRows[i];
            int containingDocumentId = Integer.parseInt(sqlRow[0]);
            int menuIndex = Integer.parseInt(sqlRow[1]);
            TextDocumentDomainObject containingDocument = (TextDocumentDomainObject)this.getDocument(containingDocumentId);
            documentMenuPairs[i] = new TextDocumentMenuIndexPair(containingDocument, menuIndex);
        }
        return documentMenuPairs;
    }

    public Iterator getDocumentsIterator(IntRange idRange) {
        return new DocumentsIterator(this.getDocumentIds(idRange));
    }

    private int[] getDocumentIds(IntRange idRange) {
        String sqlSelectIds = "SELECT meta_id FROM meta WHERE meta_id >= ? AND meta_id <= ? ORDER BY meta_id";
        Object[] params = new String[]{"" + idRange.getMinimumInteger(), "" + idRange.getMaximumInteger()};
        String[] documentIdStrings = (String[])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlSelectIds, params, Utility.STRING_ARRAY_HANDLER));
        int[] documentIds = new int[documentIdStrings.length];
        for (int i = 0; i < documentIdStrings.length; ++i) {
            documentIds[i] = Integer.parseInt(documentIdStrings[i]);
        }
        return documentIds;
    }

    public int[] getAllDocumentIds() {
        Object[] params = new String[]{};
        String[] documentIdStrings = (String[])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT meta_id FROM meta ORDER BY meta_id", params, Utility.STRING_ARRAY_HANDLER));
        int[] documentIds = new int[documentIdStrings.length];
        for (int i = 0; i < documentIdStrings.length; ++i) {
            documentIds[i] = Integer.parseInt(documentIdStrings[i]);
        }
        return documentIds;
    }

    public Set<String> getAllDocumentAlias() {
        HashSet<String> allDocumentAlias = new HashSet<String>();
        String[] allAlias = (String[])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT value FROM document_properties where key_name = ? ORDER BY value", (Object[])new String[]{"imcms.document.alias"}, Utility.STRING_ARRAY_HANDLER));
        for (int i = 0; i < allAlias.length; ++i) {
            allDocumentAlias.add(allAlias[i].toLowerCase());
        }
        return allDocumentAlias;
    }

    public DocumentDomainObject getDocument(String documentIdString) {
        DocumentDomainObject document = null;
        if (null != documentIdString) {
            if (NumberUtils.isDigits((String)documentIdString)) {
                document = this.getDocument(new Integer(documentIdString));
            } else {
                String[] documentIds = (String[])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(SQL_GET_DOCUMENT_ID_FROM_PROPERTIES, (Object[])new String[]{"imcms.document.alias", documentIdString.toLowerCase()}, Utility.STRING_ARRAY_HANDLER));
                if (documentIds.length > 0 && NumberUtils.isDigits((String)documentIds[0])) {
                    document = this.getDocument(new Integer(documentIds[0]));
                }
            }
        }
        return document;
    }

    static void deleteFileDocumentFilesAccordingToFileFilter(FileFilter fileFilter) {
        File filePath = Imcms.getServices().getConfig().getFilePath();
        File[] filesToDelete = filePath.listFiles(fileFilter);
        for (int i = 0; i < filesToDelete.length; ++i) {
            filesToDelete[i].delete();
        }
    }

    static void deleteAllFileDocumentFiles(FileDocumentDomainObject fileDocument) {
        DocumentMapper.deleteFileDocumentFilesAccordingToFileFilter(new FileDocumentFileFilter(fileDocument));
    }

    public DocumentPermissionSetMapper getDocumentPermissionSetMapper() {
        return this.documentPermissionSetMapper;
    }

    static void deleteOtherFileDocumentFiles(FileDocumentDomainObject fileDocument) {
        DocumentMapper.deleteFileDocumentFilesAccordingToFileFilter(new SuperfluousFileDocumentFilesFileFilter(fileDocument));
    }

    public int getLowestDocumentId() {
        Object[] params = new String[]{};
        return Integer.parseInt((String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT MIN(meta_id) FROM meta", params, Utility.SINGLE_STRING_HANDLER)));
    }

    public int getHighestDocumentId() {
        Object[] params = new String[]{};
        return Integer.parseInt((String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT MAX(meta_id) FROM meta", params, Utility.SINGLE_STRING_HANDLER)));
    }

    public void copyDocument(DocumentDomainObject document, UserDomainObject user) throws NoPermissionToAddDocumentToMenuException, DocumentSaveException {
        String copyHeadlineSuffix = this.imcmsServices.getAdminTemplate(COPY_HEADLINE_SUFFIX_TEMPLATE, user, null);
        document.setHeadline(document.getHeadline() + copyHeadlineSuffix);
        document.setAlias(null);
        this.makeDocumentLookNew(document, user);
        this.saveNewDocument(document, user, true);
    }

    public List getDocumentsWithPermissionsForRole(RoleDomainObject role) {
        String sqlStr = "SELECT meta_id FROM roles_rights WHERE role_id = ? ORDER BY meta_id";
        Object[] parameters = new String[]{"" + role.getId()};
        String[] documentIdStrings = (String[])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_HANDLER));
        final int[] documentIds = Utility.convertStringArrayToIntArray(documentIdStrings);
        return new AbstractList(){

            public Object get(int index) {
                return DocumentMapper.this.getDocument(documentIds[index]);
            }

            public int size() {
                return documentIds.length;
            }
        };
    }

    @Override
    public DocumentDomainObject getDocument(Integer documentId) {
        return this.documentGetter.getDocument(documentId);
    }

    public CategoryMapper getCategoryMapper() {
        return this.categoryMapper;
    }

    public Database getDatabase() {
        return this.database;
    }

    public Clock getClock() {
        return this.clock;
    }

    public ImcmsServices getImcmsServices() {
        return this.imcmsServices;
    }

    void setCreatedAndModifiedDatetimes(DocumentDomainObject document, Date now) {
        document.setCreatedDatetime(now);
        document.setModifiedDatetime(now);
        document.setActualModifiedDatetime(now);
    }

    String[] getAllKeywords() {
        Object[] params = new String[]{};
        return (String[])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT code FROM classification", params, Utility.STRING_ARRAY_HANDLER));
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setDocumentPermissionSetMapper(DocumentPermissionSetMapper documentPermissionSetMapper) {
        this.documentPermissionSetMapper = documentPermissionSetMapper;
    }

    public void setDocumentIndex(DocumentIndex documentIndex) {
        this.documentIndex = documentIndex;
    }

    @Override
    public List getDocuments(Collection documentIds) {
        return this.documentGetter.getDocuments(documentIds);
    }

    public Set getSections(Collection sectionIds) {
        HashSet<SectionDomainObject> sections = new HashSet<SectionDomainObject>();
        for (Integer sectionId : sectionIds) {
            sections.add(this.getSectionById(sectionId));
        }
        return sections;
    }

    public DocumentGetter getDocumentGetter() {
        return this.documentGetter;
    }

    private void removeNonInheritedCategories(DocumentDomainObject document) {
        Set categories = this.getCategoryMapper().getCategories(document.getCategoryIds());
        for (CategoryDomainObject category : categories) {
            if (category.getType().isInherited()) continue;
            document.removeCategoryId(category.getId());
        }
    }

    private class SectionsSetLoader
    implements LazilyLoadedObject.Loader {
        private SectionsSetLoader() {
        }

        public LazilyLoadedObject.Copyable load() {
            return (SectionsSet)DocumentMapper.this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(DocumentMapper.SQL_GET_ALL_SECTIONS, null, (ResultSetHandler)new CollectionHandler((Collection)new SectionsSet(), new RowTransformer(){

                public Object createObjectFromResultSetRow(ResultSet rs) throws SQLException {
                    int sectionId = rs.getInt(1);
                    String sectionName = rs.getString(2);
                    return new SectionDomainObject(sectionId, sectionName);
                }

                public Class getClassOfCreatedObjects() {
                    return SectionDomainObject.class;
                }
            })));
        }
    }

    private static class SectionsSet
    extends AbstractSet
    implements LazilyLoadedObject.Copyable {
        private Map byId = new HashMap();
        private Map byName = new HashMap();

        private SectionsSet() {
        }

        public boolean add(Object o) {
            SectionDomainObject section = (SectionDomainObject)o;
            this.byName.put(section.getName().toLowerCase(), section);
            return null == this.byId.put(new Integer(section.getId()), section);
        }

        public int size() {
            return this.byId.size();
        }

        public Iterator iterator() {
            return this.byId.values().iterator();
        }

        public SectionDomainObject getSectionById(int sectionId) {
            return (SectionDomainObject)this.byId.get(new Integer(sectionId));
        }

        public SectionDomainObject getSectionByName(String name) {
            return (SectionDomainObject)this.byName.get(name.toLowerCase());
        }

        public LazilyLoadedObject.Copyable copy() {
            return this;
        }
    }

    private static class SectionNameComparator
    implements Comparator {
        private SectionNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            SectionDomainObject section1 = (SectionDomainObject)o1;
            SectionDomainObject section2 = (SectionDomainObject)o2;
            return section1.getName().compareToIgnoreCase(section2.getName());
        }
    }

    private static class SuperfluousFileDocumentFilesFileFilter
    extends FileDocumentFileFilter {
        private SuperfluousFileDocumentFilesFileFilter(FileDocumentDomainObject fileDocument) {
            super(fileDocument);
        }

        public boolean accept(File file, int fileDocumentId, String fileId) {
            boolean correctFileForFileDocumentFile = file.equals(DocumentSavingVisitor.getFileForFileDocumentFile(fileDocumentId, fileId));
            boolean fileDocumentHasFile = null != this.fileDocument.getFile(fileId);
            return super.accept(file, fileDocumentId, fileId) && (!correctFileForFileDocumentFile || !fileDocumentHasFile);
        }
    }

    private static class FileDocumentFileFilter
    implements FileFilter {
        protected final FileDocumentDomainObject fileDocument;

        protected FileDocumentFileFilter(FileDocumentDomainObject fileDocument) {
            this.fileDocument = fileDocument;
        }

        public boolean accept(File file) {
            Perl5Util perl5Util = new Perl5Util();
            String filename = file.getName();
            if (perl5Util.match("/(\\d+)(?:_se|\\.(.*))?/", filename)) {
                String idStr = perl5Util.group(1);
                String variantName = FileUtility.unescapeFilename(StringUtils.defaultString((String)perl5Util.group(2)));
                return this.accept(file, Integer.parseInt(idStr), variantName);
            }
            return false;
        }

        public boolean accept(File file, int fileDocumentId, String fileId) {
            return fileDocumentId == this.fileDocument.getId();
        }
    }

    public static class SaveEditedDocumentCommand
    implements DocumentPageFlow.SaveDocumentCommand {
        public void saveDocument(DocumentDomainObject document, UserDomainObject user) throws NoPermissionInternalException, DocumentSaveException {
            Imcms.getServices().getDocumentMapper().saveDocument(document, user);
        }
    }

    private class DocumentsIterator
    implements Iterator {
        int[] documentIds;
        int index;

        DocumentsIterator(int[] documentIds) {
            this.documentIds = (int[])documentIds.clone();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.index < this.documentIds.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return DocumentMapper.this.getDocument(this.documentIds[this.index++]);
        }
    }

    public static class TextDocumentMenuIndexPair {
        private TextDocumentDomainObject document;
        private int menuIndex;

        public TextDocumentMenuIndexPair(TextDocumentDomainObject document, int menuIndex) {
            this.document = document;
            this.menuIndex = menuIndex;
        }

        public TextDocumentDomainObject getDocument() {
            return this.document;
        }

        public int getMenuIndex() {
            return this.menuIndex;
        }
    }
}

