/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.imcms.mapping.DocumentInitializingVisitor;
import com.imcode.imcms.mapping.DocumentList;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.util.CountingIterator;
import imcode.server.document.CopyableHashSet;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.DocumentPermissionSets;
import imcode.server.document.RoleIdToDocumentPermissionSetTypeMappings;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.CopyableHashMap;
import imcode.server.user.RoleId;
import imcode.util.LazilyLoadedObject;
import imcode.util.Utility;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.dbutils.ResultSetHandler;

public class DocumentInitializer {
    private static final String SQL_GET_KEYWORDS = "SELECT mc.meta_id, c.code FROM classification c JOIN meta_classification mc ON mc.class_id = c.class_id WHERE mc.meta_id ";
    private static final String SQL_GET_DOCUMENT_PROPERTIES = "SELECT key_name, value FROM document_properties WHERE meta_id=?";
    private final DocumentMapper documentMapper;
    public static final String SQL_GET_SECTION_IDS_FOR_DOCUMENT = "SELECT ms.meta_id, ms.section_id\nFROM meta_section ms\nWHERE ms.meta_id ";
    public static final int PERM_CREATE_DOCUMENT = 8;
    private Database database;
    MultiHashMap documentsSectionIds;
    MultiHashMap documentsKeywords;
    MultiHashMap documentsCategoryIds;
    HashMap documentsProperties;
    HashMap documentsRolePermissionMappings;
    HashMap documentsPermissionSets;
    HashMap documentsPermissionSetsForNew;

    public DocumentInitializer(DocumentMapper documentMapper) {
        this.documentMapper = documentMapper;
        this.database = documentMapper.getDatabase();
    }

    void initDocuments(DocumentList documentList) {
        Set documentIds = documentList.getMap().keySet();
        DocumentInitializingVisitor documentInitializingVisitor = new DocumentInitializingVisitor(this.documentMapper, documentIds, this.documentMapper);
        for (DocumentDomainObject document : documentList) {
            Integer documentId = new Integer(document.getId());
            LazilyLoadedObject permissionSets = new LazilyLoadedObject(new DocumentPermissionSetsLoader(documentIds, false, documentId));
            LazilyLoadedObject permissionSetsForNew = new LazilyLoadedObject(new DocumentPermissionSetsLoader(documentIds, true, documentId));
            LazilyLoadedObject rolePermissionMappings = new LazilyLoadedObject(new DocumentRolePermissionsLoader(documentIds, documentId));
            LazilyLoadedObject sectionIds = new LazilyLoadedObject(new DocumentSectionIdsLoader(documentIds, documentId));
            LazilyLoadedObject keywords = new LazilyLoadedObject(new DocumentKeywordsLoader(documentIds, documentId));
            LazilyLoadedObject categoryIds = new LazilyLoadedObject(new DocumentCategoryIdsLoader(documentIds, documentId));
            LazilyLoadedObject properties = new LazilyLoadedObject(new DocumentPropertiesLoader(documentIds, documentId));
            document.setLazilyLoadedPermissionSets(permissionSets);
            document.setLazilyLoadedPermissionSetsForNew(permissionSetsForNew);
            document.setLazilyLoadedRoleIdsMappedToDocumentPermissionSetTypes(rolePermissionMappings);
            document.setLazilyLoadedSectionIds(sectionIds);
            document.setLazilyLoadedKeywords(keywords);
            document.setLazilyLoadedCategoryIds(categoryIds);
            document.setLazilyLoadedProperties(properties);
            document.accept(documentInitializingVisitor);
        }
    }

    private static Integer[] appendInClause(StringBuffer sql, Collection documentIds) {
        sql.append("IN (");
        Integer[] documentIdsArray = new Integer[documentIds.size()];
        CountingIterator iterator = new CountingIterator(documentIds.iterator());
        while (iterator.hasNext()) {
            Integer documentId = (Integer)iterator.next();
            documentIdsArray[iterator.getCount() - 1] = new Integer(documentId);
            sql.append('?');
            if (!iterator.hasNext()) continue;
            sql.append(',');
        }
        sql.append(')');
        return documentIdsArray;
    }

    static void executeWithAppendedIntegerInClause(Database database, String sqlString, Collection documentIds, ResultSetHandler resultSetHandler) {
        if (documentIds.isEmpty()) {
            throw new IllegalArgumentException("documentIds is empty");
        }
        StringBuffer sql = new StringBuffer(sqlString);
        Object[] parameters = DocumentInitializer.appendInClause(sql, documentIds);
        database.execute((DatabaseCommand)new SqlQueryCommand(sql.toString(), parameters, resultSetHandler));
    }

    private class DocumentPermissionSetsLoader
    implements LazilyLoadedObject.Loader {
        private final Integer documentId;
        private final Collection documentIds;
        private boolean forNew;

        DocumentPermissionSetsLoader(Collection documentIds, boolean forNew, Integer documentId) {
            this.documentIds = documentIds;
            this.forNew = forNew;
            this.documentId = documentId;
        }

        public LazilyLoadedObject.Copyable load() {
            HashMap map;
            DocumentPermissionSets documentPermissionSets;
            if (null == DocumentInitializer.this.documentsPermissionSets) {
                DocumentInitializer.this.documentsPermissionSets = new HashMap();
                this.initDocumentsPermissionSets(this.documentIds, DocumentInitializer.this.documentsPermissionSets, false);
            }
            if (null == DocumentInitializer.this.documentsPermissionSetsForNew) {
                DocumentInitializer.this.documentsPermissionSetsForNew = new HashMap();
                this.initDocumentsPermissionSets(this.documentIds, DocumentInitializer.this.documentsPermissionSetsForNew, true);
            }
            if (null == (documentPermissionSets = (DocumentPermissionSets)(map = this.forNew ? DocumentInitializer.this.documentsPermissionSetsForNew : DocumentInitializer.this.documentsPermissionSets).get(this.documentId))) {
                documentPermissionSets = new DocumentPermissionSets();
            }
            return documentPermissionSets;
        }

        public void initDocumentsPermissionSets(Collection documentIds, final Map documentsPermissionSets, boolean forNew) {
            DocumentInitializer.executeWithAppendedIntegerInClause(DocumentInitializer.this.database, "SELECT d.meta_id, d.set_id, d.permission_id, de.permission_id, de.permission_data\nFROM " + (forNew ? "new_" : "") + "doc_permission_sets d\n" + "LEFT JOIN " + (forNew ? "new_" : "") + "doc_permission_sets_ex de ON d.meta_id = de.meta_id AND d.set_id = de.set_id\n" + "WHERE d.meta_id ", documentIds, new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws SQLException {
                    while (resultSet.next()) {
                        Integer documentId = new Integer(resultSet.getInt(1));
                        int setId = resultSet.getInt(2);
                        int permissionSetBits = resultSet.getInt(3);
                        Integer permissionId = Utility.getInteger(resultSet.getObject(4));
                        Integer permissionData = Utility.getInteger(resultSet.getObject(5));
                        DocumentPermissionSets permissionSets = (DocumentPermissionSets)documentsPermissionSets.get(documentId);
                        if (null == permissionSets) {
                            permissionSets = new DocumentPermissionSets();
                            documentsPermissionSets.put(documentId, permissionSets);
                        }
                        DocumentPermissionSetDomainObject restricted = permissionSets.getRestricted(setId);
                        if (0 != permissionSetBits && restricted.isEmpty()) {
                            restricted.setFromBits(permissionSetBits);
                        }
                        DocumentPermissionSetsLoader.this.setPermissionData(restricted, permissionId, permissionData);
                    }
                    return null;
                }
            });
        }

        private void setPermissionData(DocumentPermissionSetDomainObject permissionSet, Integer permissionId, Integer permissionData) {
            if (null != permissionId) {
                TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)permissionSet;
                switch (permissionId) {
                    case 8: {
                        textDocumentPermissionSet.addAllowedDocumentTypeId(permissionData);
                        break;
                    }
                    case 524288: {
                        textDocumentPermissionSet.addAllowedTemplateGroupId(permissionData);
                        break;
                    }
                }
            }
        }
    }

    private class DocumentRolePermissionsLoader
    implements LazilyLoadedObject.Loader {
        private final Collection documentIds;
        private final Integer documentId;

        DocumentRolePermissionsLoader(Collection documentIds, Integer documentId) {
            this.documentIds = documentIds;
            this.documentId = documentId;
        }

        public LazilyLoadedObject.Copyable load() {
            this.initDocumentsRolePermissionMappings(this.documentIds);
            RoleIdToDocumentPermissionSetTypeMappings rolePermissionMappings = (RoleIdToDocumentPermissionSetTypeMappings)DocumentInitializer.this.documentsRolePermissionMappings.get(this.documentId);
            if (null == rolePermissionMappings) {
                rolePermissionMappings = new RoleIdToDocumentPermissionSetTypeMappings();
            }
            return rolePermissionMappings;
        }

        public void initDocumentsRolePermissionMappings(Collection documentIds) {
            if (null != DocumentInitializer.this.documentsRolePermissionMappings) {
                return;
            }
            DocumentInitializer.this.documentsRolePermissionMappings = new HashMap();
            DocumentInitializer.executeWithAppendedIntegerInClause(DocumentInitializer.this.database, "SELECT meta_id, role_id, set_id\nFROM  roles_rights\nWHERE meta_id ", documentIds, new ResultSetHandler(){

                public Object handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        Integer documentId = new Integer(rs.getInt(1));
                        int roleId = rs.getInt(2);
                        int setId = rs.getInt(3);
                        RoleIdToDocumentPermissionSetTypeMappings rolePermissionMappings = (RoleIdToDocumentPermissionSetTypeMappings)DocumentInitializer.this.documentsRolePermissionMappings.get(documentId);
                        if (null == rolePermissionMappings) {
                            rolePermissionMappings = new RoleIdToDocumentPermissionSetTypeMappings();
                            DocumentInitializer.this.documentsRolePermissionMappings.put(documentId, rolePermissionMappings);
                        }
                        rolePermissionMappings.setPermissionSetTypeForRole(new RoleId(roleId), DocumentPermissionSetTypeDomainObject.fromInt(setId));
                    }
                    return null;
                }
            });
        }
    }

    private class DocumentCategoryIdsLoader
    implements LazilyLoadedObject.Loader {
        private final Collection documentIds;
        private final Integer documentId;

        DocumentCategoryIdsLoader(Collection documentIds, Integer documentId) {
            this.documentIds = documentIds;
            this.documentId = documentId;
        }

        public LazilyLoadedObject.Copyable load() {
            this.initDocumentsCategoryIds(this.documentIds);
            Collection documentCategoryIds = DocumentInitializer.this.documentsCategoryIds.getCollection((Object)this.documentId);
            if (null == documentCategoryIds) {
                documentCategoryIds = Collections.EMPTY_SET;
            }
            return new CopyableHashSet(documentCategoryIds);
        }

        private void initDocumentsCategoryIds(Collection documentIds) {
            if (null != DocumentInitializer.this.documentsCategoryIds) {
                return;
            }
            DocumentInitializer.this.documentsCategoryIds = new MultiHashMap();
            DocumentInitializer.executeWithAppendedIntegerInClause(DocumentInitializer.this.database, "SELECT meta_id, category_id FROM document_categories WHERE meta_id ", documentIds, new ResultSetHandler(){

                public Object handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        int documentId = rs.getInt(1);
                        int categoryId = rs.getInt(2);
                        DocumentInitializer.this.documentsCategoryIds.put((Object)new Integer(documentId), (Object)new Integer(categoryId));
                    }
                    return null;
                }
            });
        }
    }

    private class DocumentPropertiesLoader
    implements LazilyLoadedObject.Loader {
        private final Collection documentIds;
        private final Integer documentId;

        DocumentPropertiesLoader(Collection documentIds, Integer documentId) {
            this.documentIds = documentIds;
            this.documentId = documentId;
        }

        public LazilyLoadedObject.Copyable load() {
            this.initDocumentsProperties(this.documentIds);
            HashMap documentProperties = (HashMap)DocumentInitializer.this.documentsProperties.get(this.documentId);
            if (null == documentProperties) {
                documentProperties = new HashMap();
            }
            return new CopyableHashMap((Map)documentProperties);
        }

        private void initDocumentsProperties(Collection documentIds) {
            if (null != DocumentInitializer.this.documentsProperties) {
                return;
            }
            DocumentInitializer.this.documentsProperties = new HashMap();
            StringBuffer sql = new StringBuffer(DocumentInitializer.SQL_GET_DOCUMENT_PROPERTIES);
            for (final Integer documentId : documentIds) {
                DocumentInitializer.this.database.execute((DatabaseCommand)new SqlQueryCommand(sql.toString(), (Object[])new String[]{documentId + ""}, new ResultSetHandler(){

                    public Object handle(ResultSet rs) throws SQLException {
                        HashMap<String, String> properties = new HashMap<String, String>(rs.getFetchSize());
                        while (rs.next()) {
                            String keyName = rs.getString(1);
                            String value = rs.getString(2);
                            properties.put(keyName, value);
                        }
                        DocumentInitializer.this.documentsProperties.put(documentId, properties);
                        return null;
                    }
                }));
            }
        }
    }

    private class DocumentKeywordsLoader
    implements LazilyLoadedObject.Loader {
        private final Collection documentIds;
        private final Integer documentId;

        DocumentKeywordsLoader(Collection documentIds, Integer documentId) {
            this.documentIds = documentIds;
            this.documentId = documentId;
        }

        public LazilyLoadedObject.Copyable load() {
            this.initDocumentsKeywords(this.documentIds);
            Collection documentKeywords = (Collection)DocumentInitializer.this.documentsKeywords.get((Object)this.documentId);
            if (null == documentKeywords) {
                documentKeywords = Collections.EMPTY_SET;
            }
            return new CopyableHashSet(documentKeywords);
        }

        private void initDocumentsKeywords(Collection documentIds) {
            if (null != DocumentInitializer.this.documentsKeywords) {
                return;
            }
            DocumentInitializer.this.documentsKeywords = new MultiHashMap();
            DocumentInitializer.executeWithAppendedIntegerInClause(DocumentInitializer.this.database, DocumentInitializer.SQL_GET_KEYWORDS, documentIds, new ResultSetHandler(){

                public Object handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        int documentId = rs.getInt(1);
                        String keyword = rs.getString(2);
                        DocumentInitializer.this.documentsKeywords.put((Object)new Integer(documentId), (Object)keyword);
                    }
                    return null;
                }
            });
        }
    }

    private class DocumentSectionIdsLoader
    implements LazilyLoadedObject.Loader {
        private final Collection documentIds;
        private final Integer documentId;

        DocumentSectionIdsLoader(Collection documentIds, Integer documentId) {
            this.documentIds = documentIds;
            this.documentId = documentId;
        }

        public LazilyLoadedObject.Copyable load() {
            this.initDocumentsSectionIds(this.documentIds);
            Collection sectionIds = (Collection)DocumentInitializer.this.documentsSectionIds.get((Object)this.documentId);
            if (null == sectionIds) {
                sectionIds = Collections.EMPTY_SET;
            }
            return new CopyableHashSet(sectionIds);
        }

        private void initDocumentsSectionIds(Collection documentIds) {
            if (null != DocumentInitializer.this.documentsSectionIds) {
                return;
            }
            DocumentInitializer.this.documentsSectionIds = new MultiHashMap();
            DocumentInitializer.executeWithAppendedIntegerInClause(DocumentInitializer.this.database, DocumentInitializer.SQL_GET_SECTION_IDS_FOR_DOCUMENT, documentIds, new ResultSetHandler(){

                public Object handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        int documentId = rs.getInt(1);
                        int sectionId = rs.getInt(2);
                        DocumentInitializer.this.documentsSectionIds.put((Object)new Integer(documentId), (Object)new Integer(sectionId));
                    }
                    return null;
                }
            });
        }
    }
}

