/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.handlers.CollectionHandler;
import com.imcode.db.handlers.RowTransformer;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.mapping.AbstractDocumentGetter;
import com.imcode.imcms.mapping.DocumentInitializer;
import com.imcode.imcms.mapping.DocumentList;
import imcode.server.ImcmsServices;
import imcode.server.LanguageMapper;
import imcode.server.document.DocumentDomainObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;

public class DatabaseDocumentGetter
extends AbstractDocumentGetter {
    private Database database;
    private ImcmsServices services;
    public static final String SQL_GET_DOCUMENTS = "SELECT meta_id,\ndoc_type,\nmeta_headline,\nmeta_text,\nmeta_image,\nowner_id,\npermissions,\nshared,\nshow_meta,\nlang_prefix,\ndate_created,\ndate_modified,\ndisable_search,\ntarget,\narchived_datetime,\npublisher_id,\nstatus,\npublication_start_datetime,\npublication_end_datetime\nFROM meta\nWHERE meta_id ";
    static final String SQL_SELECT_PERMISSON_DATA__PREFIX = "SELECT meta_id, set_id, permission_data FROM ";

    public DatabaseDocumentGetter(Database database, ImcmsServices services) {
        this.database = database;
        this.services = services;
    }

    public List getDocuments(Collection documentIds) {
        if (documentIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedHashMap documentMap = new LinkedHashMap();
        DocumentInitializer.executeWithAppendedIntegerInClause(this.database, SQL_GET_DOCUMENTS, documentIds, (ResultSetHandler)new CollectionHandler((Collection)new DocumentMapSet(documentMap), (RowTransformer)new DocumentFromRowFactory()));
        DocumentList documentList = new DocumentList(documentMap);
        DocumentInitializer initializer = new DocumentInitializer(this.services.getDocumentMapper());
        initializer.initDocuments(documentList);
        LinkedHashMap retMap = new LinkedHashMap();
        for (Integer id : documentIds) {
            retMap.put(id, documentMap.get(id));
        }
        return new DocumentList(retMap);
    }

    private Document.PublicationStatus publicationStatusFromInt(int publicationStatusInt) {
        Document.PublicationStatus publicationStatus = Document.PublicationStatus.NEW;
        if (2 == publicationStatusInt) {
            publicationStatus = Document.PublicationStatus.APPROVED;
        } else if (1 == publicationStatusInt) {
            publicationStatus = Document.PublicationStatus.DISAPPROVED;
        }
        return publicationStatus;
    }

    private class DocumentFromRowFactory
    implements RowTransformer {
        private DocumentFromRowFactory() {
        }

        public Object createObjectFromResultSetRow(ResultSet resultSet) throws SQLException {
            int documentTypeId = resultSet.getInt(2);
            DocumentDomainObject document = DocumentDomainObject.fromDocumentTypeId(documentTypeId);
            int documentId = resultSet.getInt(1);
            document.setId(documentId);
            document.setHeadline(resultSet.getString(3));
            document.setMenuText(resultSet.getString(4));
            document.setMenuImage(resultSet.getString(5));
            document.setCreatorId(resultSet.getInt(6));
            document.setRestrictedOneMorePrivilegedThanRestrictedTwo(resultSet.getBoolean(7));
            document.setLinkableByOtherUsers(resultSet.getBoolean(8));
            document.setLinkedForUnauthorizedUsers(resultSet.getBoolean(9));
            document.setLanguageIso639_2(LanguageMapper.getAsIso639_2OrDefaultLanguage(resultSet.getString(10), DatabaseDocumentGetter.this.services.getLanguageMapper().getDefaultLanguage()));
            document.setCreatedDatetime(resultSet.getTimestamp(11));
            Timestamp modifiedDatetime = resultSet.getTimestamp(12);
            document.setModifiedDatetime(modifiedDatetime);
            document.setActualModifiedDatetime(modifiedDatetime);
            document.setSearchDisabled(resultSet.getBoolean(13));
            document.setTarget(resultSet.getString(14));
            document.setArchivedDatetime(resultSet.getTimestamp(15));
            Number publisherId = (Number)resultSet.getObject(16);
            document.setPublisherId(publisherId == null ? null : new Integer(publisherId.intValue()));
            int publicationStatusInt = resultSet.getInt(17);
            Document.PublicationStatus publicationStatus = DatabaseDocumentGetter.this.publicationStatusFromInt(publicationStatusInt);
            document.setPublicationStatus(publicationStatus);
            document.setPublicationStartDatetime(resultSet.getTimestamp(18));
            document.setPublicationEndDatetime(resultSet.getTimestamp(19));
            return document;
        }

        public Class getClassOfCreatedObjects() {
            return DocumentDomainObject.class;
        }
    }

    private class DocumentMapSet
    extends AbstractSet {
        private Map map;

        DocumentMapSet(Map map) {
            this.map = map;
        }

        public int size() {
            return this.map.size();
        }

        public boolean add(Object o) {
            DocumentDomainObject document = (DocumentDomainObject)o;
            return null == this.map.put(new Integer(document.getId()), document);
        }

        public Iterator iterator() {
            return this.map.values().iterator();
        }
    }
}

