/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentGetterWrapper;
import imcode.server.document.DocumentDomainObject;
import imcode.util.ShouldNotBeThrownException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CachingDocumentGetter
extends DocumentGetterWrapper {
    private Map cache;

    public CachingDocumentGetter(DocumentGetter documentGetter, Map cache) {
        super(documentGetter);
        this.cache = cache;
    }

    public DocumentDomainObject getDocument(Integer documentId) {
        DocumentDomainObject document = (DocumentDomainObject)this.cache.get(documentId);
        if (null == document) {
            document = super.getDocument(documentId);
            if (null == document) {
                return null;
            }
            this.cache.put(documentId, document);
        }
        try {
            return (DocumentDomainObject)document.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ShouldNotBeThrownException(e);
        }
    }

    public List getDocuments(Collection documentIds) {
        return super.getDocuments(documentIds);
    }
}

