/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.flow;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.Page;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.NotImplementedException;

public abstract class OkCancelPage
extends Page {
    public static final String REQUEST_PARAMETER__OK = "ok";
    public static final String REQUEST_PARAMETER__CANCEL = "cancel";
    protected DispatchCommand okCommand;
    protected DispatchCommand cancelCommand;

    protected OkCancelPage(DispatchCommand okDispatchCommand, DispatchCommand cancelDispatchCommand) {
        this.okCommand = okDispatchCommand;
        this.cancelCommand = cancelDispatchCommand;
    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.wasCanceled(request)) {
            this.dispatchCancel(request, response);
        } else {
            this.dispatchNotCanceled(request, response);
        }
    }

    protected void dispatchNotCanceled(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.updateFromRequest(request);
        if (this.wasOk(request)) {
            this.dispatchOk(request, response);
        } else {
            this.dispatchOther(request, response);
        }
    }

    protected void dispatchOk(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.removeFromSession(request);
        this.okCommand.dispatch(request, response);
    }

    protected void dispatchCancel(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.removeFromSession(request);
        this.cancelCommand.dispatch(request, response);
    }

    protected void dispatchOther(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        throw new NotImplementedException(this.getClass());
    }

    protected boolean wasOk(HttpServletRequest request) {
        return null != request.getParameter(REQUEST_PARAMETER__OK);
    }

    protected boolean wasCanceled(HttpServletRequest request) {
        return null != request.getParameter(REQUEST_PARAMETER__CANCEL);
    }

    protected abstract void updateFromRequest(HttpServletRequest var1);
}

