/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.db.refactoring.model;

import com.imcode.imcms.db.refactoring.model.Column;
import com.imcode.imcms.db.refactoring.model.Type;

public class DdlUtilsColumn
implements Column {
    private final org.apache.ddlutils.model.Column column;

    public DdlUtilsColumn(org.apache.ddlutils.model.Column column) {
        this.column = column;
    }

    public boolean isNullable() {
        return !this.column.isRequired();
    }

    public boolean hasDefault() {
        return null != this.column.getDefaultValue();
    }

    public String getDefaultValue() {
        return this.column.getDefaultValue();
    }

    public boolean isAutoIncremented() {
        return this.column.isAutoIncrement();
    }

    public boolean isPrimaryKey() {
        return this.column.isPrimaryKey();
    }

    public Type getType() {
        if (this.column.isOfNumericType()) {
            return Type.INTEGER;
        }
        if (this.column.isOfTextType()) {
            return Type.VARCHAR;
        }
        return Type.DATETIME;
    }

    public int getSize() {
        return this.column.getSizeAsInt();
    }

    public String getName() {
        return this.column.getName();
    }
}

