/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.db.refactoring;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.imcms.db.DdlUtilsPlatformCommand;
import com.imcode.imcms.db.refactoring.DatabaseNotSupportedException;
import com.imcode.imcms.db.refactoring.MssqlDatabasePlatform;
import com.imcode.imcms.db.refactoring.MysqlDatabasePlatform;
import com.imcode.imcms.db.refactoring.model.Column;
import com.imcode.imcms.db.refactoring.model.DdlUtilsDatabaseModel;
import com.imcode.imcms.db.refactoring.model.DdlUtilsForeignKey;
import com.imcode.imcms.db.refactoring.model.ForeignKey;
import com.imcode.imcms.db.refactoring.model.Table;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.platform.mssql.MSSqlPlatform;
import org.apache.ddlutils.platform.mysql.MySqlPlatform;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabasePlatform {
    private static final Logger LOG = Logger.getLogger(DatabasePlatform.class);
    protected final Database database;
    private static final String OBJECT_DOES_NOT_EXIST = "42S02";

    protected DatabasePlatform(Database database) {
        this.database = database;
    }

    public void dropTable(String tableName) {
        this.dropForeignKeys(tableName);
        this.update("DROP TABLE " + tableName);
    }

    public void update(String sql) {
        LOG.trace((Object)sql);
        this.database.execute((DatabaseCommand)new SqlUpdateCommand(sql, null));
    }

    public void dropForeignKeys(final String tableName) {
        this.database.execute((DatabaseCommand)new DdlUtilsPlatformCommand(){

            protected Object executePlatform(DatabaseConnection databaseConnection, Platform platform) {
                org.apache.ddlutils.model.Database actualDdl = platform.readModelFromDatabase(null);
                org.apache.ddlutils.model.Table table = actualDdl.findTable(tableName);
                for (org.apache.ddlutils.model.ForeignKey foreignKey : table.getForeignKeys()) {
                    DatabasePlatform.this.dropForeignKey(new DdlUtilsForeignKey(tableName, foreignKey));
                }
                return null;
            }
        });
    }

    public abstract void dropForeignKey(ForeignKey var1);

    public abstract void alterColumn(Table var1, String var2, Column var3);

    public static DatabasePlatform getInstance(final Database database) {
        return (DatabasePlatform)database.execute((DatabaseCommand)new DdlUtilsPlatformCommand(){

            protected Object executePlatform(DatabaseConnection databaseConnection, Platform platform) {
                if (platform instanceof MySqlPlatform) {
                    return new MysqlDatabasePlatform(database);
                }
                if (platform instanceof MSSqlPlatform) {
                    return new MssqlDatabasePlatform(database);
                }
                throw new DatabaseNotSupportedException();
            }
        });
    }

    public void addForeignKeys(Collection<ForeignKey> foreignKeys) {
        for (ForeignKey foreignKey : foreignKeys) {
            this.addForeignKey(foreignKey);
        }
    }

    public void addForeignKey(ForeignKey foreignKey) {
        this.update("ALTER TABLE " + foreignKey.getLocalTableName() + " ADD " + this.createForeignKeyDefinition(foreignKey));
    }

    public void alterColumn(String tableName, String columnName, Column column) {
        this.alterColumn(this.getTable(tableName), columnName, column);
    }

    private Table getTable(String tableName) {
        return this.getModel().getTable(tableName);
    }

    private DdlUtilsDatabaseModel getModel() {
        return new DdlUtilsDatabaseModel((org.apache.ddlutils.model.Database)this.database.execute((DatabaseCommand)new DdlUtilsPlatformCommand(){

            protected Object executePlatform(DatabaseConnection databaseConnection, Platform platform) {
                return platform.readModelFromDatabase(null);
            }
        }));
    }

    protected void dropForeignKeys(Iterable<ForeignKey> foreignKeys) {
        for (ForeignKey foreignKey : foreignKeys) {
            this.dropForeignKey(foreignKey);
        }
    }

    public void dropDatabase(String databaseName) {
        block2: {
            try {
                this.update("DROP DATABASE " + databaseName);
            }
            catch (DatabaseException e) {
                String sqlState = this.getSqlState(e);
                if (OBJECT_DOES_NOT_EXIST.equals(sqlState)) break block2;
                throw e;
            }
        }
    }

    private String getSqlState(DatabaseException e) {
        for (Throwable t = e; null != t; t = t.getCause()) {
            if (!(t instanceof SQLException)) continue;
            for (SQLException se = (SQLException)t; null != se; se = se.getNextException()) {
                if (null == se.getSQLState()) continue;
                return se.getSQLState();
            }
        }
        return null;
    }

    public void createDatabase(String databaseName) {
        this.update("CREATE DATABASE " + databaseName);
    }

    public void createTable(Table table) {
        this.update(this.createTableDefinition(table));
    }

    protected String createTableDefinition(Table table) {
        return "CREATE TABLE " + table.getName() + " ( " + this.createTableDefinitionContent(table) + " )";
    }

    private String createTableDefinitionContent(Table table) {
        ArrayList<String> tableDefinition = new ArrayList<String>();
        tableDefinition.add(this.createColumnDefinitions(table.getColumns()));
        ArrayList<String> primaryKeyColumnNames = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            if (!column.isPrimaryKey()) continue;
            primaryKeyColumnNames.add(column.getName());
        }
        if (!primaryKeyColumnNames.isEmpty()) {
            tableDefinition.add(this.createPrimaryKeyDefinition(primaryKeyColumnNames));
        }
        for (ForeignKey foreignKey : table.getForeignKeys()) {
            tableDefinition.add(this.createForeignKeyDefinition(foreignKey));
        }
        return StringUtils.join(tableDefinition.iterator(), (String)", ");
    }

    private String createPrimaryKeyDefinition(List<String> primaryKeyColumnNames) {
        return "PRIMARY KEY ( " + StringUtils.join(primaryKeyColumnNames.iterator(), (String)", ") + " )";
    }

    protected String createForeignKeyDefinition(ForeignKey foreignKey) {
        String name = foreignKey.getName();
        if (null == name) {
            name = "FK__" + foreignKey.getLocalTableName() + "__" + foreignKey.getForeignTableName();
        }
        return "CONSTRAINT " + name + " FOREIGN KEY ( " + StringUtils.join(foreignKey.getLocalColumnNames().iterator(), (String)", ") + " ) REFERENCES " + foreignKey.getForeignTableName() + " ( " + StringUtils.join(foreignKey.getForeignColumnNames().iterator(), (String)", ") + " )";
    }

    private String createColumnDefinitions(Collection<Column> columns) {
        ArrayList<String> columnDefinitions = new ArrayList<String>();
        for (Column column : columns) {
            columnDefinitions.add(this.createColumnDefinition(column));
        }
        return StringUtils.join(columnDefinitions.iterator(), (String)", ");
    }

    protected abstract String createColumnDefinition(Column var1);

    protected String getTypeString(Column column) {
        String typeString = null;
        switch (column.getType()) {
            case INTEGER: {
                typeString = "INTEGER";
                break;
            }
            case VARCHAR: {
                typeString = 0 != column.getSize() ? "VARCHAR(" + column.getSize() + ")" : "TEXT";
                break;
            }
            case DATETIME: {
                typeString = "DATETIME";
            }
        }
        return typeString;
    }
}

