/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.db;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.imcms.db.DatabaseTypeSpecificUpgrade;
import com.imcode.imcms.db.DdlUtilsPlatformCommand;
import com.imcode.imcms.db.DdlUtilsSqlBuilderCommand;
import com.imcode.imcms.db.refactoring.DatabaseNotSupportedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.ColumnOrderChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.SqlBuilder;
import org.apache.log4j.Logger;

class UnicodeUpgrade
extends DatabaseTypeSpecificUpgrade {
    private static final Logger LOG = Logger.getLogger(UnicodeUpgrade.class);

    protected UnicodeUpgrade(Database ddl) {
        super(ddl);
    }

    public void upgradeOther(com.imcode.db.Database database) throws DatabaseException {
        throw new DatabaseNotSupportedException();
    }

    public void upgradeMssql(com.imcode.db.Database database) throws DatabaseException {
        this.rebuildTextTables(database);
    }

    private void rebuildTextTables(com.imcode.db.Database database) {
        database.execute((DatabaseCommand)new DdlUtilsSqlBuilderCommand(){

            protected Object executeSqlBuilder(DatabaseConnection databaseConnection, SqlBuilder sqlBuilder) throws IOException {
                Database sourceDdl = sqlBuilder.getPlatform().readModelFromDatabase(databaseConnection.getConnection(), null);
                ArrayList<ColumnOrderChange> changes = new ArrayList<ColumnOrderChange>();
                block0: for (Table sourceTable : sourceDdl.getTables()) {
                    if (null == UnicodeUpgrade.this.wantedDdl.findTable(sourceTable.getName())) continue;
                    for (Column column : sourceTable.getColumns()) {
                        if (!column.isOfTextType()) continue;
                        LOG.debug((Object)("Rebuilding table " + sourceTable));
                        changes.add(new ColumnOrderChange(sourceTable, Collections.EMPTY_MAP));
                        continue block0;
                    }
                }
                sqlBuilder.processChanges(sourceDdl, sourceDdl, changes, new CreationParameters());
                return null;
            }
        });
    }

    public void upgradeMysql(com.imcode.db.Database database) throws DatabaseException {
        Table[] tables;
        for (Table table : tables = (Table[])database.execute((DatabaseCommand)new DdlUtilsPlatformCommand(){

            protected Object executePlatform(DatabaseConnection databaseConnection, Platform platform) {
                return platform.readModelFromDatabase(null).getTables();
            }
        })) {
            database.execute((DatabaseCommand)new SqlUpdateCommand("ALTER TABLE " + table.getName() + " CONVERT TO CHARACTER SET UTF8", new Object[0]));
        }
    }
}

