/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.db;

import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.imcms.db.DdlUtilsPlatformCommand;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.platform.SqlBuilder;

public abstract class DdlUtilsSqlBuilderCommand
extends DdlUtilsPlatformCommand {
    protected Object executePlatform(DatabaseConnection databaseConnection, Platform platform) {
        Object result;
        SqlBuilder sqlBuilder = platform.getSqlBuilder();
        Writer oldWriter = sqlBuilder.getWriter();
        StringWriter newWriter = new StringWriter();
        sqlBuilder.setWriter((Writer)newWriter);
        try {
            result = this.executeSqlBuilder(databaseConnection, sqlBuilder);
        }
        catch (IOException e) {
            throw new DatabaseException(null, (Throwable)e);
        }
        sqlBuilder.setWriter(oldWriter);
        String sql = newWriter.toString();
        if (StringUtils.isNotBlank((String)sql)) {
            platform.evaluateBatch(databaseConnection.getConnection(), sql, false);
        }
        return result;
    }

    protected abstract Object executeSqlBuilder(DatabaseConnection var1, SqlBuilder var2) throws IOException;
}

