/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.db;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.imcms.db.ImcmsDatabaseUpgrade;
import com.imcode.imcms.db.SingleConnectionDataSource;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.ddlutils.PlatformUtils;
import org.apache.ddlutils.model.Database;

abstract class DatabaseTypeSpecificUpgrade
extends ImcmsDatabaseUpgrade {
    protected DatabaseTypeSpecificUpgrade(Database ddl) {
        super(ddl);
    }

    public void upgrade(com.imcode.db.Database database) throws DatabaseException {
        String databaseName = (String)database.execute(new DatabaseCommand(){

            public Object executeOn(DatabaseConnection databaseConnection) throws DatabaseException {
                Connection connection = databaseConnection.getConnection();
                SingleConnectionDataSource dataSource = new SingleConnectionDataSource(connection);
                PlatformUtils platformUtils = new PlatformUtils();
                return platformUtils.determineDatabaseType((DataSource)dataSource);
            }
        });
        if ("MsSql".equals(databaseName)) {
            this.upgradeMssql(database);
        } else if ("MySQL".equals(databaseName)) {
            this.upgradeMysql(database);
        } else {
            this.upgradeOther(database);
        }
    }

    public abstract void upgradeOther(com.imcode.db.Database var1) throws DatabaseException;

    public abstract void upgradeMssql(com.imcode.db.Database var1) throws DatabaseException;

    public abstract void upgradeMysql(com.imcode.db.Database var1) throws DatabaseException;
}

