/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.db;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.imcms.db.DdlUtilsSqlBuilderCommand;
import com.imcode.imcms.db.ImcmsDatabaseUpgrade;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.ddlutils.alteration.ColumnSizeChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.SqlBuilder;

class ColumnSizeUpgrade
extends ImcmsDatabaseUpgrade {
    private String tableName;
    private String columnName;
    private int columnSize;

    protected ColumnSizeUpgrade(Database ddl, String tableName, String columnName, int columnSize) {
        super(ddl);
        this.tableName = tableName;
        this.columnName = columnName;
        this.columnSize = columnSize;
    }

    public void upgrade(com.imcode.db.Database database) throws DatabaseException {
        database.execute((DatabaseCommand)new DdlUtilsSqlBuilderCommand(){

            protected Object executeSqlBuilder(DatabaseConnection databaseConnection, SqlBuilder sqlBuilder) throws IOException {
                Database actualDdl = sqlBuilder.getPlatform().readModelFromDatabase(databaseConnection.getConnection(), null);
                Table actualTable = actualDdl.findTable(ColumnSizeUpgrade.this.tableName);
                Column column = actualTable.findColumn(ColumnSizeUpgrade.this.columnName);
                column.setSize("" + ColumnSizeUpgrade.this.columnSize);
                ArrayList<ColumnSizeChange> changes = new ArrayList<ColumnSizeChange>();
                changes.add(new ColumnSizeChange(actualTable, column, ColumnSizeUpgrade.this.columnSize, 0));
                sqlBuilder.processChanges(actualDdl, actualDdl, changes, null);
                return null;
            }
        });
    }
}

