/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.net;

import com.imcode.imcms.util.l10n.LocalizedMessage;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Arrays;
import javax.activation.DataSource;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;

public class SMTP {
    private String host;
    private int port;

    public SMTP(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void sendMail(Mail mail) throws IOException {
        HtmlEmail email = mail.getMail();
        try {
            email.setHostName(this.host);
            email.setSmtpPort(this.port);
            email.setCharset("UTF-8");
            email.send();
        }
        catch (EmailException e) {
            if (Utility.throwableContainsMessageContaining(e, "no object DCH")) {
                throw new UnhandledException("\"no object DCH\" Likely cause: the activation jar-file cannot see the mail jar-file. Different ClassLoaders?", (Throwable)e);
            }
            throw new UnhandledException((Throwable)e);
        }
    }

    public static class Mail {
        private HtmlEmail mail = new HtmlEmail();
        private String textBody;

        public Mail(String fromAddress) {
            try {
                this.mail.setFrom(fromAddress);
            }
            catch (EmailException e) {
                LocalizedMessage errorMessage = new LocalizedMessage("error/missing_email_fromAdress");
                throw new UnhandledException(errorMessage.toLocalizedString("eng"), (Throwable)e);
            }
        }

        public Mail(String fromAddress, String[] toAddresses, String subject, String body) {
            this(fromAddress);
            this.setToAddresses(toAddresses);
            this.setSubject(subject);
            this.setBody(body);
        }

        public void setBccAddresses(String[] bccAddresses) {
            try {
                this.mail.setBcc(CollectionUtils.collect(Arrays.asList(bccAddresses), (Transformer)new StringToInternetAddressTransformer()));
            }
            catch (EmailException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        public void setBody(String body) {
            try {
                this.textBody = body;
                this.mail.setTextMsg(body);
            }
            catch (EmailException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        public void setHtmlBody(String htmlBody) {
            try {
                this.mail.setHtmlMsg(htmlBody);
                if (null == this.textBody) {
                    this.setBody(htmlBody.replaceAll("<[^>]*>", ""));
                }
            }
            catch (EmailException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        public void setCcAddresses(String[] ccAddresses) {
            try {
                this.mail.setCc(CollectionUtils.collect(Arrays.asList(ccAddresses), (Transformer)new StringToInternetAddressTransformer()));
            }
            catch (EmailException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        public void setSubject(String subject) {
            this.mail.setSubject(subject);
        }

        public void setToAddresses(String[] toAddresses) {
            try {
                this.mail.setTo(CollectionUtils.collect(Arrays.asList(toAddresses), (Transformer)new StringToInternetAddressTransformer()));
            }
            catch (EmailException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        public void setAttachments(DataSource[] attachments) {
            try {
                for (int i = 0; i < attachments.length; ++i) {
                    DataSource attachment = attachments[i];
                    this.mail.attach(attachment, attachment.getName(), "");
                }
            }
            catch (EmailException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        private HtmlEmail getMail() {
            return this.mail;
        }

        private static class StringToInternetAddressTransformer
        implements Transformer {
            private StringToInternetAddressTransformer() {
            }

            public Object transform(Object input) {
                try {
                    return new InternetAddress((String)input, false);
                }
                catch (AddressException e) {
                    throw new UnhandledException((Throwable)e);
                }
            }
        }
    }
}

