/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.apache.log4j.Logger;

public class FallbackDecoder {
    private Charset charset;
    private Charset fallbackCharset;
    private static final Logger LOG = Logger.getLogger(FallbackDecoder.class);

    public FallbackDecoder(Charset charset, Charset fallbackCharset) {
        this.charset = charset;
        this.fallbackCharset = fallbackCharset;
    }

    public String decodeBytes(byte[] inputBytes, String sourceName) {
        String result;
        if (0 == inputBytes.length) {
            return "";
        }
        try {
            result = FallbackDecoder.createReportingDecoder(this.charset).decode(ByteBuffer.wrap(inputBytes)).toString();
        }
        catch (CharacterCodingException e1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to decode " + sourceName + " using " + this.charset + ", falling back to " + this.fallbackCharset + "."));
            }
            try {
                result = FallbackDecoder.createReportingDecoder(this.fallbackCharset).decode(ByteBuffer.wrap(inputBytes)).toString();
            }
            catch (CharacterCodingException e2) {
                LOG.warn((Object)("Failed to decode " + sourceName + " using " + this.charset + " and " + this.fallbackCharset + ", using broken " + this.charset + " result."), (Throwable)e2);
                result = this.charset.decode(ByteBuffer.wrap(inputBytes)).toString();
            }
        }
        return result;
    }

    private static CharsetDecoder createReportingDecoder(Charset charset) {
        return charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
    }

    public Charset getFallbackCharset() {
        return this.fallbackCharset;
    }
}

