/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.UnhandledException;

public class CollectingHttpServletResponse
extends HttpServletResponseWrapper {
    StringWriter stringWriter = new StringWriter();
    PrintWriter printWriter = new PrintWriter(this.stringWriter);
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    ServletOutputStream servletOutputStream = new ServletOutputStream(){

        public void write(int b) {
            CollectingHttpServletResponse.this.byteArrayOutputStream.write(b);
        }
    };
    private boolean alreadyCalled;

    public CollectingHttpServletResponse(HttpServletResponse response) {
        super(response);
    }

    private void checkCalled() throws IOException {
        if (this.alreadyCalled) {
            throw new IOException("getOutputStream() or getWriter() already called.");
        }
        this.alreadyCalled = true;
    }

    public PrintWriter getWriter() throws IOException {
        this.checkCalled();
        return this.printWriter;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.checkCalled();
        return this.servletOutputStream;
    }

    public String toString() {
        try {
            this.servletOutputStream.flush();
            this.byteArrayOutputStream.flush();
            this.printWriter.flush();
            this.stringWriter.flush();
            if (this.byteArrayOutputStream.size() > 0) {
                return this.byteArrayOutputStream.toString("UTF-8");
            }
            return this.stringWriter.toString();
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
    }
}

