/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.parser;

import imcode.server.DocumentRequest;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.parser.Element;
import imcode.server.parser.MapSubstitution;
import imcode.server.parser.Node;
import imcode.server.parser.NodeList;
import imcode.server.parser.ParserParameters;
import imcode.server.parser.SimpleElement;
import imcode.server.parser.TagParser;
import imcode.server.parser.Text;
import imcode.server.parser.TextDocumentParser;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class MenuParser {
    private static final Substitution NULLSUBSTITUTION = new StringSubstitution("");
    private int[] implicitMenus = new int[]{1};
    private ParserParameters parserParameters;

    MenuParser(ParserParameters parserParameters) {
        this.parserParameters = parserParameters;
    }

    private String parseMenuNode(int menuIndex, String menuTemplate, Properties menuAttributes, TagParser tagParser) {
        String modeAttribute = menuAttributes.getProperty("mode");
        boolean modeIsRead = "read".equalsIgnoreCase(modeAttribute);
        boolean modeIsWrite = "write".equalsIgnoreCase(modeAttribute);
        boolean menuMode = this.parserParameters.isMenuMode();
        if (menuMode && modeIsRead || !menuMode && modeIsWrite) {
            return "";
        }
        try {
            NodeList menuNodes = new NodeList(menuTemplate, this.parserParameters.getDocumentRequest().getHttpServletRequest(), tagParser);
            DocumentRequest documentRequest = this.parserParameters.getDocumentRequest();
            TextDocumentDomainObject document = (TextDocumentDomainObject)documentRequest.getDocument();
            MenuDomainObject menu = document.getMenu(menuIndex);
            StringWriter contentWriter = new StringWriter();
            this.nodeMenu(new SimpleElement("menu", menuAttributes, menuNodes), contentWriter, menu, (PatternMatcher)new Perl5Matcher(), menuIndex, tagParser);
            String content = contentWriter.toString();
            return MenuParser.addMenuAdmin(menuIndex, menuMode, content, menu, documentRequest.getHttpServletRequest(), documentRequest.getHttpServletResponse(), menuAttributes.getProperty("label"));
        }
        catch (Exception e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public static String addMenuAdmin(int menuIndex, boolean menuMode, String content, MenuDomainObject menu, HttpServletRequest request, HttpServletResponse response, String label) throws ServletException, IOException {
        if (!menuMode) {
            return content;
        }
        ImcmsAuthenticatorAndUserAndRoleMapper userMapper = Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper();
        UserDomainObject defaultUser = userMapper.getDefaultUser();
        MenuItemDomainObject[] defaultUserMenuItems = menu.getPublishedMenuItemsUserCanSee(defaultUser);
        UserDomainObject user = Utility.getLoggedOnUser(request);
        MenuItemDomainObject[] menuItemsUserCanSee = menu.getMenuItemsUserCanSee(user);
        request.setAttribute("content", (Object)content);
        request.setAttribute("label", (Object)label);
        request.setAttribute("defaultUserCount", (Object)defaultUserMenuItems.length);
        request.setAttribute("userCount", (Object)menuItemsUserCanSee.length);
        request.setAttribute("menuIndex", (Object)new Integer(menuIndex));
        return Utility.getContents("/imcms/" + user.getLanguageIso639_2() + "/jsp/docadmin/text/edit_menu.jsp", request, response);
    }

    public void nodeMenu(Element menuNode, Writer result, MenuDomainObject currentMenu, PatternMatcher patMat, int menuIndex, TagParser tagParser) throws IOException {
        if (currentMenu == null || 0 == currentMenu.getMenuItems().length) {
            return;
        }
        Properties menuAttributes = menuNode.getAttributes();
        if (menuNode.getChildElement("menuloop") == null) {
            this.nodeMenuLoop(new SimpleElement("menuloop", null, menuNode.getChildren()), result, currentMenu, menuAttributes, patMat, tagParser);
        } else {
            for (Node menuNodeChild : menuNode.getChildren()) {
                switch (menuNodeChild.getNodeType()) {
                    case 0: {
                        result.write(tagParser.replaceTags(((Text)menuNodeChild).getContent(), false));
                        break;
                    }
                    case 1: {
                        if ("menuloop".equals(((Element)menuNodeChild).getName())) {
                            this.nodeMenuLoop((Element)menuNodeChild, result, currentMenu, menuAttributes, patMat, tagParser);
                            break;
                        }
                        result.append(tagParser.replaceTags(menuNodeChild.toString(), false));
                    }
                }
            }
        }
    }

    private void nodeMenuLoop(Element menuLoopNode, Writer result, MenuDomainObject menu, Properties menuAttributes, PatternMatcher patMat, TagParser tagParser) throws IOException {
        if (null == menu) {
            return;
        }
        ArrayList<SimpleElement> menuLoopNodeChildren = menuLoopNode.getChildren();
        if (null == menuLoopNode.getChildElement("menuitem")) {
            SimpleElement menuItemNode = new SimpleElement("menuitem", null, menuLoopNodeChildren);
            menuLoopNodeChildren = new ArrayList<SimpleElement>(1);
            menuLoopNodeChildren.add(menuItemNode);
        }
        this.loopOverMenuItemsAndMenuItemTemplateElementsAndAddToResult(menu, menuLoopNodeChildren, result, menuAttributes, patMat, tagParser);
    }

    private void loopOverMenuItemsAndMenuItemTemplateElementsAndAddToResult(MenuDomainObject menu, List menuLoopNodeChildren, Writer result, Properties menuAttributes, PatternMatcher patMat, TagParser tagParser) throws IOException {
        UserDomainObject user = this.parserParameters.getDocumentRequest().getUser();
        FilterIterator menuItemsIterator = new FilterIterator(Arrays.asList(menu.getMenuItems()).iterator(), (Predicate)new UserCanSeeMenuItemPredicate(user));
        int menuItemIndexStart = 0;
        try {
            menuItemIndexStart = Integer.parseInt(menuAttributes.getProperty("indexstart"));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        int menuItemIndexStep = 1;
        try {
            menuItemIndexStep = Integer.parseInt(menuAttributes.getProperty("indexstep"));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        int menuItemIndex = menuItemIndexStart;
        while (menuItemsIterator.hasNext()) {
            for (Node menuLoopChild : menuLoopNodeChildren) {
                switch (menuLoopChild.getNodeType()) {
                    case 0: {
                        result.write(tagParser.replaceTags(((Text)menuLoopChild).getContent(), false));
                        break;
                    }
                    case 1: {
                        if ("menuitem".equals(((Element)menuLoopChild).getName())) {
                            MenuItemDomainObject menuItem = menuItemsIterator.hasNext() ? (MenuItemDomainObject)menuItemsIterator.next() : null;
                            this.nodeMenuItem((Element)menuLoopChild, result, menuItem, menuAttributes, patMat, menuItemIndex, tagParser);
                            menuItemIndex += menuItemIndexStep;
                            break;
                        }
                        result.append(tagParser.replaceTags(menuLoopChild.toString(), false));
                    }
                }
            }
        }
    }

    private void nodeMenuItem(Element menuItemNode, Writer result, MenuItemDomainObject menuItem, Properties menuAttributes, PatternMatcher patMat, int menuItemIndex, TagParser tagParser) throws IOException {
        Substitution menuItemSubstitution;
        if (menuItem != null) {
            Properties menuItemAttributes = new Properties(menuAttributes);
            menuItemAttributes.putAll((Map<?, ?>)menuItemNode.getAttributes());
            menuItemSubstitution = this.getMenuItemSubstitution(menuItem, menuItemAttributes, menuItemIndex);
        } else {
            menuItemSubstitution = NULLSUBSTITUTION;
        }
        for (Node menuItemChild : menuItemNode.getChildren()) {
            switch (menuItemChild.getNodeType()) {
                case 1: {
                    Element menuItemChildElement = (Element)menuItemChild;
                    if ("menuitemhide".equals(menuItemChildElement.getName()) && menuItem == null) break;
                    this.parseMenuItem(result, menuItemChildElement.getTextContent(), menuItemSubstitution, patMat, tagParser);
                    break;
                }
                case 0: {
                    this.parseMenuItem(result, ((Text)menuItemChild).getContent(), menuItemSubstitution, patMat, tagParser);
                }
            }
        }
    }

    private void parseMenuItem(Writer result, String template, Substitution substitution, PatternMatcher patMat, TagParser tagParser) throws IOException {
        String tagsReplaced = tagParser.replaceTags(template, false);
        result.write(Util.substitute((PatternMatcher)patMat, (Pattern)TextDocumentParser.hashtagPattern, (Substitution)substitution, (String)tagsReplaced, (int)-1));
    }

    public String tag(Properties menuattributes, String menutemplate, PatternMatcher patMat, TagParser tagParser) {
        int menuIndex;
        try {
            menuIndex = Integer.parseInt(menuattributes.getProperty("no"));
        }
        catch (NumberFormatException ex) {
            int n = this.implicitMenus[0];
            this.implicitMenus[0] = n + 1;
            menuIndex = n;
        }
        return this.parseMenuNode(menuIndex, menutemplate, menuattributes, tagParser);
    }

    private Substitution getMenuItemSubstitution(MenuItemDomainObject menuItem, Properties parameters, int menuItemIndex) {
        DocumentDomainObject document = menuItem.getDocument();
        DocumentRequest documentRequest = this.parserParameters.getDocumentRequest();
        String contextPath = documentRequest.getHttpServletRequest().getContextPath();
        String imageUrl = document.getMenuImage();
        String imagesRoot = contextPath + Imcms.getServices().getConfig().getImageUrl();
        String imageTag = imageUrl != null && imageUrl.length() > 0 ? "<img src=\"" + imagesRoot + StringEscapeUtils.escapeHtml((String)imageUrl) + "\" border=\"0\">" : "";
        String headline = document.getHeadline();
        if (StringUtils.isBlank((String)headline)) {
            headline = "&nbsp;";
        } else {
            if (!document.isPublished()) {
                headline = "<em><i>" + headline;
                headline = headline + "</i></em>";
            }
            if (document.isArchived()) {
                headline = "<strike>" + headline;
                headline = headline + "</strike>";
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String createdDate = dateFormat.format(document.getCreatedDatetime());
        String modifiedDate = dateFormat.format(document.getModifiedDatetime());
        Properties tags = new Properties();
        tags.setProperty("#childMetaId#", "" + document.getId());
        tags.setProperty("#childMetaHeadline#", headline);
        tags.setProperty("#childMetaText#", document.getMenuText());
        tags.setProperty("#childMetaImage#", imageTag);
        tags.setProperty("#childCreatedDate#", createdDate);
        tags.setProperty("#childModifiedDate#", modifiedDate);
        tags.setProperty("#menuitemindex#", "" + menuItemIndex);
        tags.setProperty("#menuitemtreesortkey#", menuItem.getTreeSortKey().toString());
        tags.setProperty("#menuitemmetaid#", "" + document.getId());
        tags.setProperty("#menuitemheadline#", headline);
        tags.setProperty("#menuitemtext#", document.getMenuText());
        tags.setProperty("#menuitemimage#", imageTag);
        tags.setProperty("#menuitemimageurl#", StringEscapeUtils.escapeHtml((String)imageUrl));
        tags.setProperty("#menuitemtarget#", document.getTarget());
        tags.setProperty("#menuitemdatecreated#", createdDate);
        tags.setProperty("#menuitemdatemodified#", modifiedDate);
        String template = parameters.getProperty("template");
        HttpServletRequest request = documentRequest.getHttpServletRequest();
        String href = MenuParser.getPathToDocument(request, document, template);
        ArrayList<String> menuItemAHref = new ArrayList<String>(4);
        menuItemAHref.add("#href#");
        menuItemAHref.add(href);
        menuItemAHref.add("#target#");
        menuItemAHref.add(document.getTarget());
        UserDomainObject user = documentRequest.getUser();
        ImcmsServices serverObject = documentRequest.getServices();
        String a_href = serverObject.getAdminTemplate("textdoc/menuitem_a_href.frag", user, menuItemAHref);
        tags.setProperty("#menuitemlinkonly#", a_href);
        tags.setProperty("#/menuitemlinkonly#", "</a>");
        tags.setProperty("#menuitemlink#", a_href);
        tags.setProperty("#/menuitemlink#", "</a>");
        return new MapSubstitution(tags, true);
    }

    public static String getPathToDocument(HttpServletRequest request, DocumentDomainObject document, String template) {
        String href = Utility.getAbsolutePathToDocument(request, document);
        if (StringUtils.isNotBlank((String)template)) {
            href = href + (-1 != href.indexOf(63) ? (char)'&' : '?');
            href = href + "template=" + URLEncoder.encode(template);
        }
        return href;
    }

    public static class UserCanSeeMenuItemPredicate
    implements Predicate {
        private final UserDomainObject user;

        public UserCanSeeMenuItemPredicate(UserDomainObject user) {
            this.user = user;
        }

        public boolean evaluate(Object o) {
            DocumentDomainObject document = ((MenuItemDomainObject)o).getDocument();
            return this.user.canSeeDocumentInMenus(document);
        }
    }
}

