/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import com.imcode.imcms.mapping.DocumentMenusMap;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.textdocument.CopyableHashMap;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.util.LazilyLoadedObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.UnhandledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDocumentDomainObject
extends DocumentDomainObject {
    private Map<Integer, Boolean> modifiedTextIndexes = new TreeMap<Integer, Boolean>();
    private LazilyLoadedObject<CopyableHashMap> texts = new LazilyLoadedObject<CopyableHashMap>(new CopyableHashMapLoader());
    private LazilyLoadedObject<CopyableHashMap> images = new LazilyLoadedObject<CopyableHashMap>(new CopyableHashMapLoader());
    private LazilyLoadedObject<CopyableHashMap> includes = new LazilyLoadedObject<CopyableHashMap>(new CopyableHashMapLoader());
    private LazilyLoadedObject<DocumentMenusMap> menus = new LazilyLoadedObject<DocumentMenusMap>(new LazilyLoadedObject.Loader<DocumentMenusMap>(){

        @Override
        public DocumentMenusMap load() {
            return new DocumentMenusMap();
        }
    });
    private LazilyLoadedObject<TemplateNames> templateNames = new LazilyLoadedObject<TemplateNames>(new LazilyLoadedObject.Loader<TemplateNames>(){

        @Override
        public TemplateNames load() {
            return new TemplateNames();
        }
    });

    public TextDocumentDomainObject() {
        this(0);
    }

    public TextDocumentDomainObject(int documentId) {
        this.setId(documentId);
    }

    @Override
    public void loadAllLazilyLoaded() {
        super.loadAllLazilyLoaded();
        this.texts.load();
        this.images.load();
        this.includes.load();
        this.menus.load();
        this.templateNames.load();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TextDocumentDomainObject clone = (TextDocumentDomainObject)super.clone();
        clone.texts = (LazilyLoadedObject)this.texts.clone();
        clone.images = (LazilyLoadedObject)this.images.clone();
        clone.includes = (LazilyLoadedObject)this.includes.clone();
        clone.menus = (LazilyLoadedObject)this.menus.clone();
        clone.templateNames = (LazilyLoadedObject)this.templateNames.clone();
        return clone;
    }

    @Override
    public DocumentTypeDomainObject getDocumentType() {
        return DocumentTypeDomainObject.TEXT;
    }

    public Set getChildDocumentIds() {
        HashSet<Integer> childDocuments = new HashSet<Integer>();
        for (MenuDomainObject menu : this.getMenus().values()) {
            MenuItemDomainObject[] menuItems = menu.getMenuItems();
            for (int i = 0; i < menuItems.length; ++i) {
                MenuItemDomainObject menuItem = menuItems[i];
                childDocuments.add(new Integer(menuItem.getDocumentId()));
            }
        }
        return childDocuments;
    }

    public ImageDomainObject getImage(int imageIndex) {
        ImageDomainObject image = (ImageDomainObject)this.getImagesMap().get(new Integer(imageIndex));
        if (null == image) {
            image = new ImageDomainObject();
        }
        return image;
    }

    private Map getImagesMap() {
        return (Map)this.images.get();
    }

    public Integer getIncludedDocumentId(int includeIndex) {
        return (Integer)this.getIncludesMap().get(new Integer(includeIndex));
    }

    private Map getIncludesMap() {
        return (Map)this.includes.get();
    }

    public MenuDomainObject getMenu(int menuIndex) {
        Map menusMap = (Map)this.menus.get();
        MenuDomainObject menu = (MenuDomainObject)menusMap.get(new Integer(menuIndex));
        if (null == menu) {
            menu = new MenuDomainObject();
            this.setMenu(menuIndex, menu);
        }
        return menu;
    }

    public TextDomainObject getText(int textFieldIndex) {
        return (TextDomainObject)this.getTextsMap().get(new Integer(textFieldIndex));
    }

    private Map getTextsMap() {
        return (Map)this.texts.get();
    }

    @Override
    public void accept(DocumentVisitor documentVisitor) {
        documentVisitor.visitTextDocument(this);
    }

    public void removeAllImages() {
        this.getImagesMap().clear();
    }

    public void removeAllIncludes() {
        this.getIncludesMap().clear();
    }

    public void removeAllMenus() {
        this.getMenusMap().clear();
    }

    private Map getMenusMap() {
        return (Map)this.menus.get();
    }

    public void removeAllTexts() {
        this.getTextsMap().clear();
    }

    public void setInclude(int includeIndex, int includedDocumentId) {
        this.getIncludesMap().put(new Integer(includeIndex), new Integer(includedDocumentId));
    }

    public void setMenu(int menuIndex, MenuDomainObject menu) {
        this.getMenusMap().put(new Integer(menuIndex), menu);
    }

    public void setText(int textIndex, TextDomainObject text) {
        this.getTextsMap().put(new Integer(textIndex), text);
    }

    public Map<Integer, ImageDomainObject> getImages() {
        return Collections.unmodifiableMap(this.getImagesMap());
    }

    public Map getIncludes() {
        return Collections.unmodifiableMap(this.getIncludesMap());
    }

    public Map<Integer, MenuDomainObject> getMenus() {
        return Collections.unmodifiableMap(this.getMenusMap());
    }

    public String getTemplateName() {
        return this.getTemplateNames().getTemplateName();
    }

    private TemplateNames getTemplateNames() {
        return (TemplateNames)this.templateNames.get();
    }

    public int getTemplateGroupId() {
        return this.getTemplateNames().getTemplateGroupId();
    }

    public Map<Integer, TextDomainObject> getTexts() {
        return Collections.unmodifiableMap(this.getTextsMap());
    }

    public void setTemplateName(String templateName) {
        this.getTemplateNames().setTemplateName(templateName);
    }

    public void setTemplateGroupId(int v) {
        this.getTemplateNames().setTemplateGroupId(v);
    }

    public void setImage(int imageIndex, ImageDomainObject image) {
        this.getImagesMap().put(new Integer(imageIndex), image);
    }

    public String getDefaultTemplateName() {
        return this.getTemplateNames().getDefaultTemplateName();
    }

    public void setDefaultTemplateId(String defaultTemplateId) {
        this.getTemplateNames().setDefaultTemplateName(defaultTemplateId);
    }

    public void removeInclude(int includeIndex) {
        this.getIncludesMap().remove(new Integer(includeIndex));
    }

    public void setLazilyLoadedMenus(LazilyLoadedObject menus) {
        this.menus = menus;
    }

    public void setLazilyLoadedImages(LazilyLoadedObject images) {
        this.images = images;
    }

    public void setLazilyLoadedIncludes(LazilyLoadedObject includes) {
        this.includes = includes;
    }

    public void setLazilyLoadedTexts(LazilyLoadedObject texts) {
        this.texts = texts;
    }

    public String getDefaultTemplateNameForRestricted1() {
        return this.getTemplateNames().getDefaultTemplateNameForRestricted1();
    }

    public String getDefaultTemplateNameForRestricted2() {
        return this.getTemplateNames().getDefaultTemplateNameForRestricted2();
    }

    public void setDefaultTemplateIdForRestricted1(String defaultTemplateIdForRestricted1) {
        this.getTemplateNames().setDefaultTemplateNameForRestricted1(defaultTemplateIdForRestricted1);
    }

    public void setDefaultTemplateIdForRestricted2(String defaultTemplateIdForRestricted2) {
        this.getTemplateNames().setDefaultTemplateNameForRestricted2(defaultTemplateIdForRestricted2);
    }

    public void setLazilyLoadedTemplateIds(LazilyLoadedObject templateIds) {
        this.templateNames = templateIds;
    }

    public Map<Integer, Boolean> getModifiedTextIndexes() {
        return this.modifiedTextIndexes;
    }

    public void addModifiedTextIndex(int index, boolean saveToHistory) {
        this.modifiedTextIndexes.put(index, saveToHistory);
    }

    public void removeModifiedTextIndex(int index) {
        this.modifiedTextIndexes.remove(index);
    }

    public void removeAllModifiedTextIndexs() {
        this.modifiedTextIndexes.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TemplateNames
    implements LazilyLoadedObject.Copyable<TemplateNames>,
    Cloneable {
        private String templateName;
        private int templateGroupId;
        private String defaultTemplateName;
        private String defaultTemplateNameForRestricted1;
        private String defaultTemplateNameForRestricted2;

        @Override
        public TemplateNames copy() {
            return (TemplateNames)this.clone();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public int getTemplateGroupId() {
            return this.templateGroupId;
        }

        public void setTemplateGroupId(int templateGroupId) {
            this.templateGroupId = templateGroupId;
        }

        public String getDefaultTemplateName() {
            return this.defaultTemplateName;
        }

        public void setDefaultTemplateName(String defaultTemplateName) {
            this.defaultTemplateName = defaultTemplateName;
        }

        public String getDefaultTemplateNameForRestricted1() {
            return this.defaultTemplateNameForRestricted1;
        }

        public void setDefaultTemplateNameForRestricted1(String defaultTemplateNameForRestricted1) {
            this.defaultTemplateNameForRestricted1 = defaultTemplateNameForRestricted1;
        }

        public String getDefaultTemplateNameForRestricted2() {
            return this.defaultTemplateNameForRestricted2;
        }

        public void setDefaultTemplateNameForRestricted2(String defaultTemplateNameForRestricted2) {
            this.defaultTemplateNameForRestricted2 = defaultTemplateNameForRestricted2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopyableHashMapLoader
    implements LazilyLoadedObject.Loader<CopyableHashMap> {
        private CopyableHashMapLoader() {
        }

        @Override
        public CopyableHashMap load() {
            return new CopyableHashMap();
        }
    }
}

