/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import com.imcode.util.ImageSize;
import imcode.server.document.textdocument.ImageSource;
import imcode.server.document.textdocument.NullImageSource;
import imcode.util.image.Format;
import imcode.util.image.ImageInfo;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ImageDomainObject
implements Serializable {
    private ImageSource source = new NullImageSource();
    private String name = "";
    private int width;
    private int height;
    private int border;
    private String align = "";
    private String alternateText = "";
    private String lowResolutionUrl = "";
    private int verticalSpace;
    private int horizontalSpace;
    private String target = "";
    private String linkUrl = "";
    private Long archiveImageId;
    private Format format;
    private CropRegion cropRegion = new CropRegion();

    public String getName() {
        return this.name;
    }

    public ImageSize getDisplayImageSize() {
        ImageSize realImageSize = this.getRealImageSize();
        int wantedWidth = this.getWidth();
        int wantedHeight = this.getHeight();
        if (0 == wantedWidth && 0 != wantedHeight && 0 != realImageSize.getHeight()) {
            wantedWidth = (int)((double)realImageSize.getWidth() * ((double)wantedHeight / (double)realImageSize.getHeight()));
        } else if (0 == wantedHeight && 0 != wantedWidth && 0 != realImageSize.getWidth()) {
            wantedHeight = (int)((double)realImageSize.getHeight() * ((double)wantedWidth / (double)realImageSize.getWidth()));
        } else if (0 == wantedWidth && 0 == wantedHeight) {
            wantedWidth = realImageSize.getWidth();
            wantedHeight = realImageSize.getHeight();
        }
        return new ImageSize(wantedWidth, wantedHeight);
    }

    public ImageSize getRealImageSize() {
        ImageSize imageSize = new ImageSize(0, 0);
        if (!this.isEmpty()) {
            try {
                imageSize = this.source.getImageSize();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return imageSize;
    }

    public ImageInfo getImageInfo() {
        if (!this.isEmpty()) {
            try {
                return this.source.getImageInfo();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBorder() {
        return this.border;
    }

    public String getAlign() {
        return this.align;
    }

    public String getAlternateText() {
        return this.alternateText;
    }

    public String getLowResolutionUrl() {
        return this.lowResolutionUrl;
    }

    public int getVerticalSpace() {
        return this.verticalSpace;
    }

    public int getHorizontalSpace() {
        return this.horizontalSpace;
    }

    public String getTarget() {
        return this.target;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setName(String image_name) {
        this.name = image_name;
    }

    public void setWidth(int image_width) {
        this.width = image_width;
    }

    public void setHeight(int image_height) {
        this.height = image_height;
    }

    public void setBorder(int image_border) {
        this.border = image_border;
    }

    public void setAlign(String image_align) {
        this.align = image_align;
    }

    public void setAlternateText(String alt_text) {
        this.alternateText = alt_text;
    }

    public void setLowResolutionUrl(String low_scr) {
        this.lowResolutionUrl = low_scr;
    }

    public void setVerticalSpace(int v_space) {
        this.verticalSpace = v_space;
    }

    public void setHorizontalSpace(int h_space) {
        this.horizontalSpace = h_space;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setLinkUrl(String image_ref_link) {
        this.linkUrl = image_ref_link;
    }

    public Long getArchiveImageId() {
        return this.archiveImageId;
    }

    public void setArchiveImageId(Long archiveImageId) {
        this.archiveImageId = archiveImageId;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setSourceAndClearSize(ImageSource source) {
        this.setSource(source);
        this.setWidth(0);
        this.setHeight(0);
    }

    public void setSource(ImageSource source) {
        if (null == source) {
            throw new NullArgumentException("source");
        }
        this.source = source;
    }

    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    public String getUrlPath(String contextPath) {
        String urlPathRelativeToContextPath = this.getUrlPathRelativeToContextPath();
        if (StringUtils.isBlank((String)urlPathRelativeToContextPath)) {
            return "";
        }
        return contextPath + urlPathRelativeToContextPath;
    }

    public String getUrlPathRelativeToContextPath() {
        return this.source.getUrlPathRelativeToContextPath();
    }

    public long getSize() {
        if (this.isEmpty()) {
            return 0L;
        }
        try {
            return this.source.getInputStreamSource().getSize();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public ImageSource getSource() {
        if (this.isEmpty()) {
            return new NullImageSource();
        }
        return this.source;
    }

    public CropRegion getCropRegion() {
        return this.cropRegion;
    }

    public void setCropRegion(CropRegion cropRegion) {
        this.cropRegion = cropRegion;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImageDomainObject)) {
            return false;
        }
        ImageDomainObject o = (ImageDomainObject)obj;
        CropRegion otherCropRegion = o.getCropRegion();
        return new EqualsBuilder().append((Object)this.source.toStorageString(), (Object)o.getSource().toStorageString()).append((Object)this.name, (Object)o.getName()).append(this.width, o.getWidth()).append(this.height, o.getHeight()).append(this.border, o.getBorder()).append((Object)this.align, (Object)o.getAlign()).append((Object)this.alternateText, (Object)o.getAlternateText()).append((Object)this.lowResolutionUrl, (Object)o.getLowResolutionUrl()).append(this.verticalSpace, o.getVerticalSpace()).append(this.horizontalSpace, o.getHorizontalSpace()).append((Object)this.target, (Object)o.getTarget()).append((Object)this.linkUrl, (Object)o.getLinkUrl()).append((Object)this.format, (Object)o.getFormat()).append(this.cropRegion.getCropX1(), otherCropRegion.getCropX1()).append(this.cropRegion.getCropY1(), otherCropRegion.getCropY1()).append(this.cropRegion.getCropX2(), otherCropRegion.getCropX2()).append(this.cropRegion.getCropY2(), otherCropRegion.getCropY2()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.source.toStorageString()).append((Object)this.name).append(this.width).append(this.height).append(this.border).append((Object)this.align).append((Object)this.alternateText).append((Object)this.lowResolutionUrl).append(this.verticalSpace).append(this.horizontalSpace).append((Object)this.target).append((Object)this.linkUrl).append((Object)this.format).append(this.cropRegion.getCropX1()).append(this.cropRegion.getCropY1()).append(this.cropRegion.getCropX2()).append(this.cropRegion.getCropY2()).toHashCode();
    }

    public static class CropRegion
    implements Serializable {
        private static final long serialVersionUID = -586488435877347784L;
        private int cropX1;
        private int cropY1;
        private int cropX2;
        private int cropY2;
        private boolean valid;

        public CropRegion() {
            this.cropX1 = -1;
            this.cropY1 = -1;
            this.cropX2 = -1;
            this.cropY2 = -1;
        }

        public CropRegion(int cropX1, int cropY1, int cropX2, int cropY2) {
            if (cropX1 > cropX2) {
                this.cropX1 = cropX2;
                this.cropX2 = cropX1;
            } else {
                this.cropX1 = cropX1;
                this.cropX2 = cropX2;
            }
            if (cropY1 > cropY2) {
                this.cropY1 = cropY2;
                this.cropY2 = cropY1;
            } else {
                this.cropY1 = cropY1;
                this.cropY2 = cropY2;
            }
            this.updateValid();
        }

        public void updateValid() {
            this.valid = this.cropX1 >= 0 && this.cropY1 >= 0 && this.cropX2 >= 0 && this.cropY2 >= 0 && this.cropX1 != this.cropX2 && this.cropY1 != this.cropY2;
        }

        public boolean isValid() {
            return this.valid;
        }

        public int getCropX1() {
            return this.cropX1;
        }

        public void setCropX1(int cropX1) {
            this.cropX1 = cropX1;
        }

        public int getCropY1() {
            return this.cropY1;
        }

        public void setCropY1(int cropY1) {
            this.cropY1 = cropY1;
        }

        public int getCropX2() {
            return this.cropX2;
        }

        public void setCropX2(int cropX2) {
            this.cropX2 = cropX2;
        }

        public int getCropY2() {
            return this.cropY2;
        }

        public void setCropY2(int cropY2) {
            this.cropY2 = cropY2;
        }

        public int getWidth() {
            return this.isValid() ? this.cropX2 - this.cropX1 : 0;
        }

        public int getHeight() {
            return this.isValid() ? this.cropY2 - this.cropY1 : 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.cropX1;
            result = 31 * result + this.cropY1;
            result = 31 * result + this.cropX2;
            result = 31 * result + this.cropY2;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CropRegion other = (CropRegion)obj;
            return this.cropX1 == other.cropX1 && this.cropY1 == other.cropY1 && this.cropX2 == other.cropX2 && this.cropY2 == other.cropY2;
        }
    }
}

