/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.index;

import imcode.server.document.index.BackgroundIndexBuilder;
import imcode.server.document.index.RebuildingDirectoryIndex;
import java.util.Date;
import java.util.TimerTask;
import org.apache.log4j.Logger;

class IndexRebuildTimerTask
extends TimerTask {
    private static final Logger log = Logger.getLogger(IndexRebuildTimerTask.class);
    private final long indexRebuildSchedulePeriodInMilliseconds;
    private final BackgroundIndexBuilder backgroundIndexBuilder;

    IndexRebuildTimerTask(long indexRebuildSchedulePeriodInMilliseconds, BackgroundIndexBuilder backgroundIndexBuilder) {
        this.indexRebuildSchedulePeriodInMilliseconds = indexRebuildSchedulePeriodInMilliseconds;
        this.backgroundIndexBuilder = backgroundIndexBuilder;
    }

    public void run() {
        try {
            log.info((Object)"Starting scheduled index rebuild.");
            if (this.backgroundIndexBuilder.otherProcessModifiedIndexDirectory()) {
                log.debug((Object)"Another process modified index directory. Aborting.");
                this.cancel();
                return;
            }
            this.backgroundIndexBuilder.start();
        }
        catch (Exception e) {
            log.warn((Object)"Caught exception during scheduled index rebuild.", (Throwable)e);
        }
        Date nextTime = new Date(this.scheduledExecutionTime() + this.indexRebuildSchedulePeriodInMilliseconds);
        log.info((Object)("Next index rebuild scheduled at " + RebuildingDirectoryIndex.formatDatetime(nextTime)));
    }
}

