/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.index;

import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.index.IndexDocumentFactory;
import imcode.server.document.index.MicrosoftExcelTextExtractor;
import imcode.server.document.index.MicrosoftPowerPointTextExtractor;
import imcode.server.document.index.MicrosoftWordTextExtractor;
import imcode.server.document.index.PdfTextExtractor;
import imcode.server.document.index.StreamTextsExtractor;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

class IndexDocumentAdaptingVisitor
extends DocumentVisitor {
    private static final String MIME_TYPE__WORD = "application/msword";
    private static final String MIME_TYPE__EXCEL = "application/vnd.ms-excel";
    private static final String MIME_TYPE__POWERPOINT = "application/vnd.ms-powerpoint";
    private static final String MIME_TYPE__PDF = "application/pdf";
    Document indexDocument;
    private static final Map EXTRACTORS = new HashMap(ArrayUtils.toMap((Object[])new Object[][]{{"application/msword", new MicrosoftWordTextExtractor()}, {"application/vnd.ms-excel", new MicrosoftExcelTextExtractor()}, {"application/vnd.ms-powerpoint", new MicrosoftPowerPointTextExtractor()}, {"application/pdf", new PdfTextExtractor()}}));

    IndexDocumentAdaptingVisitor(Document indexDocument) {
        this.indexDocument = indexDocument;
    }

    public void visitTextDocument(TextDocumentDomainObject textDocument) {
        this.indexDocument.add(IndexDocumentFactory.unStoredKeyword("template", textDocument.getTemplateName()));
        for (Map.Entry<Integer, TextDomainObject> textEntry : textDocument.getTexts().entrySet()) {
            Integer textIndex = textEntry.getKey();
            TextDomainObject text = textEntry.getValue();
            this.indexDocument.add(Field.UnStored((String)"nonstripped_text", (String)text.getText()));
            String htmlStrippedText = this.stripHtml(text);
            this.indexDocument.add(Field.UnStored((String)"text", (String)htmlStrippedText));
            this.indexDocument.add(Field.UnStored((String)("text" + textIndex), (String)htmlStrippedText));
        }
        for (MenuDomainObject menu : textDocument.getMenus().values()) {
            for (MenuItemDomainObject menuItem : menu.getMenuItems()) {
                this.indexDocument.add(Field.Keyword((String)"child_id", (String)("" + menuItem.getDocumentId())));
            }
        }
        for (ImageDomainObject image : textDocument.getImages().values()) {
            String imageLinkUrl = image.getLinkUrl();
            if (null == imageLinkUrl || imageLinkUrl.length() <= 0) continue;
            this.indexDocument.add(IndexDocumentFactory.unStoredKeyword("image_link_url", imageLinkUrl));
        }
    }

    private String stripHtml(TextDomainObject text) {
        String string = text.getText();
        if (1 == text.getType()) {
            string = string.replaceAll("<[^>]+?>", "");
        }
        return string;
    }

    public void visitFileDocument(FileDocumentDomainObject fileDocument) {
        FileDocumentDomainObject.FileDocumentFile file = fileDocument.getDefaultFile();
        if (null == file) {
            return;
        }
        this.indexDocument.add(IndexDocumentFactory.unStoredKeyword("mime_type", file.getMimeType()));
        this.indexFileContents(file);
    }

    private void indexFileContents(FileDocumentDomainObject.FileDocumentFile file) {
        String[] texts;
        String mimeType = file.getMimeType();
        StreamTextsExtractor extractor = (StreamTextsExtractor)EXTRACTORS.get(mimeType);
        if (null == extractor) {
            return;
        }
        try {
            texts = extractor.extractTexts(file.getInputStreamSource().getInputStream());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        for (String text : texts) {
            this.indexDocument.add(Field.UnStored((String)"text", (String)text));
        }
    }
}

