/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.UnhandledException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XmlDocumentBuilder {
    private Document xmlDocument;
    private Element documentsElement;
    private UserDomainObject currentUser;

    public XmlDocumentBuilder(UserDomainObject user) {
        this.currentUser = user;
        try {
            this.xmlDocument = this.createXmlDocument();
            Element imcmsElement = this.xmlDocument.createElement("imcms");
            this.documentsElement = this.xmlDocument.createElement("documents");
            imcmsElement.appendChild(this.documentsElement);
            this.xmlDocument.appendChild(imcmsElement);
        }
        catch (ParserConfigurationException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private Document createXmlDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    public void addDocument(DocumentDomainObject document) {
        XmlBuildingDocumentVisitor documentVisitor = new XmlBuildingDocumentVisitor(this.xmlDocument, this.currentUser);
        document.accept(documentVisitor);
        Element documentElement = documentVisitor.getDocumentElement();
        documentElement.setAttribute("id", "" + document.getId());
        this.documentsElement.appendChild(documentElement);
    }

    public Document getXmlDocument() {
        return this.xmlDocument;
    }

    private static class XmlBuildingDocumentVisitor
    extends DocumentVisitor {
        private Document xmlDocument;
        private UserDomainObject currentUser;
        private Element documentElement;

        XmlBuildingDocumentVisitor(Document xmlDocument, UserDomainObject currentUser) {
            this.xmlDocument = xmlDocument;
            this.currentUser = currentUser;
        }

        public Element getDocumentElement() {
            return this.documentElement;
        }

        public void visitTextDocument(TextDocumentDomainObject textDocument) {
            Element documentElement = this.xmlDocument.createElement("textdocument");
            this.createTextElements(textDocument, documentElement);
            this.createImageElements(textDocument, documentElement);
            this.createMenuElements(textDocument, documentElement);
            this.documentElement = documentElement;
        }

        private void createTextElements(TextDocumentDomainObject textDocument, Element textDocumentElement) {
            Map<Integer, TextDomainObject> texts = textDocument.getTexts();
            for (Map.Entry<Integer, TextDomainObject> entry : texts.entrySet()) {
                Integer textIndex = entry.getKey();
                TextDomainObject text = entry.getValue();
                Element textElement = this.createTextElement(textIndex, text);
                textDocumentElement.appendChild(textElement);
            }
        }

        private Element createTextElement(Integer textIndex, TextDomainObject text) {
            Element textElement = this.xmlDocument.createElement("text");
            textElement.setAttribute("index", "" + textIndex);
            textElement.setAttribute("type", 0 == text.getType() ? "text" : "html");
            Text textNode = this.xmlDocument.createTextNode(text.getText());
            textElement.appendChild(textNode);
            return textElement;
        }

        private void createImageElements(TextDocumentDomainObject textDocument, Element textDocumentElement) {
            Map<Integer, ImageDomainObject> images = textDocument.getImages();
            for (Map.Entry<Integer, ImageDomainObject> entry : images.entrySet()) {
                Integer imageIndex = entry.getKey();
                ImageDomainObject image = entry.getValue();
                Element imageElement = this.createImageElement(imageIndex, image);
                textDocumentElement.appendChild(imageElement);
            }
        }

        private Element createImageElement(Integer imageIndex, ImageDomainObject image) {
            Element imageElement = this.xmlDocument.createElement("image");
            imageElement.setAttribute("index", "" + imageIndex);
            imageElement.setAttribute("path", image.getUrlPath(""));
            return imageElement;
        }

        private void createMenuElements(TextDocumentDomainObject textDocument, Element textDocumentElement) {
            Map<Integer, MenuDomainObject> menus = textDocument.getMenus();
            for (Map.Entry<Integer, MenuDomainObject> entry : menus.entrySet()) {
                Integer menuIndex = entry.getKey();
                MenuDomainObject menu = entry.getValue();
                Element menuElement = this.createMenuElement(menuIndex, menu);
                textDocumentElement.appendChild(menuElement);
            }
        }

        private Element createMenuElement(Integer menuIndex, MenuDomainObject menu) {
            Element menuElement = this.xmlDocument.createElement("menu");
            menuElement.setAttribute("index", "" + menuIndex);
            this.createMenuItemElements(menu, menuElement);
            return menuElement;
        }

        private void createMenuItemElements(MenuDomainObject menu, Element menuElement) {
            MenuItemDomainObject[] menuItems = menu.getMenuItems();
            for (int i = 0; i < menuItems.length; ++i) {
                MenuItemDomainObject menuItem = menuItems[i];
                DocumentDomainObject document = menuItem.getDocument();
                if ((!this.currentUser.canAccess(document) || !document.isPublished()) && !this.currentUser.canEdit(document)) continue;
                Element menuItemElement = this.createMenuItemElement(menuItem.getDocument());
                menuElement.appendChild(menuItemElement);
            }
        }

        private Element createMenuItemElement(DocumentDomainObject document) {
            Element menuItemElement = this.xmlDocument.createElement("menuItem");
            menuItemElement.setAttribute("documentid", "" + document.getId());
            return menuItemElement;
        }
    }
}

