/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.document.DocumentPermission;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import junit.framework.TestCase;

public class TestDocumentPermissionSetDomainObject
extends TestCase {
    DocumentPermissionSetDomainObject documentPermissionSet = new DocumentPermissionSetDomainObject(DocumentPermissionSetTypeDomainObject.RESTRICTED_1){

        public void setFromBits(int permissionBits) {
        }
    };
    private static final DocumentPermission PERMISSION = new DocumentPermission("test");

    public void testPermissionSetNone() {
        DocumentPermissionSetDomainObject.NONE.setPermission(PERMISSION, true);
        TestDocumentPermissionSetDomainObject.assertFalse((boolean)DocumentPermissionSetDomainObject.NONE.hasPermission(PERMISSION));
    }

    public void testPermissionSetRead() {
        DocumentPermissionSetDomainObject.READ.setPermission(PERMISSION, true);
        TestDocumentPermissionSetDomainObject.assertFalse((boolean)DocumentPermissionSetDomainObject.READ.hasPermission(PERMISSION));
    }

    public void testPermissionSetFull() {
        DocumentPermissionSetDomainObject full = DocumentPermissionSetDomainObject.FULL;
        full.setPermission(PERMISSION, false);
        TestDocumentPermissionSetDomainObject.assertTrue((boolean)full.hasPermission(PERMISSION));
    }

    public void testSetPermissionTrue() throws Exception {
        this.documentPermissionSet.setPermission(PERMISSION, true);
        TestDocumentPermissionSetDomainObject.assertTrue((boolean)this.documentPermissionSet.hasPermission(PERMISSION));
    }

    public void testSetPermissionFalse() throws Exception {
        this.documentPermissionSet.setPermission(PERMISSION, false);
        TestDocumentPermissionSetDomainObject.assertFalse((boolean)this.documentPermissionSet.hasPermission(PERMISSION));
    }

    public void testHasPermission() throws Exception {
        TestDocumentPermissionSetDomainObject.assertFalse((boolean)this.documentPermissionSet.hasPermission(PERMISSION));
    }
}

