/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import com.imcode.imcms.api.Document;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.LifeCyclePhase;
import imcode.server.user.RoleId;
import java.util.Date;
import junit.framework.TestCase;

public class TestDocumentDomainObject
extends TestCase {
    DocumentDomainObject document;

    protected void setUp() throws Exception {
        super.setUp();
        this.document = new DocumentDomainObject(){

            public DocumentTypeDomainObject getDocumentType() {
                return null;
            }

            public void accept(DocumentVisitor documentVisitor) {
            }
        };
    }

    public void testDeepCloneRoles() throws CloneNotSupportedException {
        RoleId roleId = RoleId.SUPERADMIN;
        TestDocumentDomainObject.assertEquals((Object)this.document.getDocumentPermissionSetTypeForRoleId(roleId), (Object)DocumentPermissionSetTypeDomainObject.NONE);
        DocumentDomainObject clone = (DocumentDomainObject)this.document.clone();
        clone.setDocumentPermissionSetTypeForRoleId(roleId, DocumentPermissionSetTypeDomainObject.FULL);
        TestDocumentDomainObject.assertEquals((Object)clone.getDocumentPermissionSetTypeForRoleId(roleId), (Object)DocumentPermissionSetTypeDomainObject.FULL);
        TestDocumentDomainObject.assertEquals((Object)this.document.getDocumentPermissionSetTypeForRoleId(roleId), (Object)DocumentPermissionSetTypeDomainObject.NONE);
    }

    public void testDeepClonePermissionSets() throws CloneNotSupportedException {
        TestDocumentDomainObject.assertFalse((boolean)this.document.getPermissionSets().getRestricted1().getEditDocumentInformation());
        DocumentDomainObject clone = (DocumentDomainObject)this.document.clone();
        TestDocumentDomainObject.assertNotSame((Object)this.document.attributes, (Object)clone.attributes);
        TestDocumentDomainObject.assertNotSame((Object)this.document.getPermissionSets(), (Object)clone.getPermissionSets());
        TestDocumentDomainObject.assertNotSame((Object)this.document.getPermissionSets().getRestricted1(), (Object)clone.getPermissionSets().getRestricted1());
        TestDocumentDomainObject.assertFalse((boolean)clone.getPermissionSets().getRestricted1().getEditDocumentInformation());
        clone.getPermissionSets().getRestricted1().setEditDocumentInformation(true);
        TestDocumentDomainObject.assertTrue((boolean)clone.getPermissionSets().getRestricted1().getEditDocumentInformation());
        TestDocumentDomainObject.assertFalse((boolean)this.document.getPermissionSets().getRestricted1().getEditDocumentInformation());
    }

    public void testGetLifeCyclePhaseAtTime() throws Exception {
        this.assertLifeCyclePhase(LifeCyclePhase.NEW);
        this.document.setPublicationEndDatetime(new Date(0L));
        this.assertLifeCyclePhase(LifeCyclePhase.NEW);
        this.document.setPublicationStatus(Document.PublicationStatus.DISAPPROVED);
        this.assertLifeCyclePhase(LifeCyclePhase.DISAPPROVED);
        this.document.setPublicationStatus(Document.PublicationStatus.APPROVED);
        this.assertLifeCyclePhase(LifeCyclePhase.UNPUBLISHED);
        this.document.setPublicationEndDatetime(null);
        this.assertLifeCyclePhase(LifeCyclePhase.APPROVED);
        this.document.setArchivedDatetime(new Date(0L));
        this.assertLifeCyclePhase(LifeCyclePhase.APPROVED);
        this.document.setPublicationStartDatetime(new Date(0L));
        this.assertLifeCyclePhase(LifeCyclePhase.ARCHIVED);
        this.document.setArchivedDatetime(null);
        this.assertLifeCyclePhase(LifeCyclePhase.PUBLISHED);
        this.document.setPublicationEndDatetime(new Date(0L));
        this.assertLifeCyclePhase(LifeCyclePhase.UNPUBLISHED);
    }

    private void assertLifeCyclePhase(LifeCyclePhase lifeCyclePhase) {
        TestDocumentDomainObject.assertEquals((Object)lifeCyclePhase, (Object)this.document.getLifeCyclePhaseAtTime(new Date(1L)));
    }

    public void testGetDocumentProperties() throws Exception {
        this.document.setProperty("imcms:document:alias", "test");
        this.document.setProperty("imcms:document:foo", "baa");
        this.document.setProperty("imcms:document:fide", "bla");
        TestDocumentDomainObject.assertEquals((String)this.document.getProperty("imcms:document:alias"), (String)"test");
        TestDocumentDomainObject.assertEquals((String)this.document.getProperty("imcms:document:foo"), (String)"baa");
        TestDocumentDomainObject.assertNotSame((Object)this.document.getProperty("imcms:document:fide"), (Object)"hide");
        TestDocumentDomainObject.assertNull((Object)this.document.getProperty("hej"));
        TestDocumentDomainObject.assertTrue((this.document.getProperties().size() == 3 ? 1 : 0) != 0);
    }
}

