/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import com.imcode.imcms.api.Document;
import com.imcode.imcms.util.l10n.LocalizedMessage;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.document.CopyableHashSet;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.DocumentPermissionSets;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.LifeCyclePhase;
import imcode.server.document.RoleIdToDocumentPermissionSetTypeMappings;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.textdocument.CopyableHashMap;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import imcode.util.LazilyLoadedObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentDomainObject
implements Cloneable,
Serializable {
    public static final int ID_NEW = 0;
    public static final String DOCUMENT_PROPERTIES__IMCMS_DOCUMENT_ALIAS = "imcms.document.alias";
    protected Attributes attributes = new Attributes();
    private static Logger log = Logger.getLogger(DocumentDomainObject.class);

    public Object clone() throws CloneNotSupportedException {
        DocumentDomainObject clone = (DocumentDomainObject)super.clone();
        if (null != this.attributes) {
            clone.attributes = (Attributes)this.attributes.clone();
        }
        return clone;
    }

    public static DocumentDomainObject fromDocumentTypeId(int documentTypeId) {
        DocumentDomainObject document;
        switch (documentTypeId) {
            case 2: {
                document = new TextDocumentDomainObject();
                break;
            }
            case 5: {
                document = new UrlDocumentDomainObject();
                break;
            }
            case 6: {
                document = new BrowserDocumentDomainObject();
                break;
            }
            case 8: {
                document = new FileDocumentDomainObject();
                break;
            }
            case 7: {
                document = new HtmlDocumentDomainObject();
                break;
            }
            default: {
                String errorMessage = "Unknown document-type-id: " + documentTypeId;
                log.error((Object)errorMessage);
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return document;
    }

    public Date getArchivedDatetime() {
        return this.attributes.archivedDatetime;
    }

    public void setArchivedDatetime(Date v) {
        this.attributes.archivedDatetime = v;
    }

    public Set<Integer> getCategoryIds() {
        return Collections.unmodifiableSet((Set)this.attributes.categoryIds.get());
    }

    public Date getCreatedDatetime() {
        return this.attributes.createdDatetime;
    }

    public void setCreatedDatetime(Date v) {
        this.attributes.createdDatetime = v;
    }

    public int getCreatorId() {
        return this.attributes.creatorId;
    }

    public void setCreatorId(int creatorId) {
        this.attributes.creatorId = creatorId;
    }

    public void setCreator(UserDomainObject creator) {
        this.setCreatorId(creator.getId());
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public String getHeadline() {
        return this.attributes.headline;
    }

    public void setHeadline(String v) {
        this.attributes.headline = v;
    }

    public int getId() {
        return this.attributes.id;
    }

    public void setId(int v) {
        this.attributes.id = v;
    }

    public String getMenuImage() {
        return this.attributes.image;
    }

    public void setMenuImage(String v) {
        this.attributes.image = v;
    }

    public Set getKeywords() {
        return Collections.unmodifiableSet((Set)this.attributes.keywords.get());
    }

    public void setKeywords(Set keywords) {
        this.attributes.keywords.set(new CopyableHashSet((Collection)keywords));
    }

    public void setProperties(Map properties) {
        this.attributes.properties.set(new CopyableHashMap(properties));
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap((Map)this.attributes.properties.get());
    }

    public String getProperty(String key) {
        Map properties = (Map)this.attributes.properties.get();
        return (String)properties.get(key);
    }

    public void setProperty(String key, String value) {
        Map properties = (Map)this.attributes.properties.get();
        properties.put(key, value);
    }

    public void removeProperty(String key) {
        Map properties = (Map)this.attributes.properties.get();
        properties.remove(key);
    }

    public String getLanguageIso639_2() {
        return this.attributes.languageIso639_2;
    }

    public void setLanguageIso639_2(String languageIso639_2) {
        this.attributes.languageIso639_2 = languageIso639_2;
    }

    public String getMenuText() {
        return this.attributes.menuText;
    }

    public void setMenuText(String v) {
        this.attributes.menuText = v;
    }

    public Date getModifiedDatetime() {
        return this.attributes.modifiedDatetime;
    }

    public void setModifiedDatetime(Date v) {
        this.attributes.modifiedDatetime = v;
    }

    public void setActualModifiedDatetime(Date modifiedDatetime) {
        this.attributes.actualModifiedDatetime = modifiedDatetime;
    }

    public Date getActualModifiedDatetime() {
        return this.attributes.actualModifiedDatetime;
    }

    public Date getPublicationEndDatetime() {
        return this.attributes.publicationEndDatetime;
    }

    public void setPublicationEndDatetime(Date datetime) {
        this.attributes.publicationEndDatetime = datetime;
    }

    public Date getPublicationStartDatetime() {
        return this.attributes.publicationStartDatetime;
    }

    public void setPublicationStartDatetime(Date v) {
        this.attributes.publicationStartDatetime = v;
    }

    public Integer getPublisherId() {
        return this.attributes.publisherId;
    }

    public void setPublisher(UserDomainObject user) {
        this.setPublisherId(new Integer(user.getId()));
    }

    public void setPublisherId(Integer publisherId) {
        this.attributes.publisherId = publisherId;
    }

    public RoleIdToDocumentPermissionSetTypeMappings getRoleIdsMappedToDocumentPermissionSetTypes() {
        return (RoleIdToDocumentPermissionSetTypeMappings)this.getRolePermissionMappings().clone();
    }

    private RoleIdToDocumentPermissionSetTypeMappings getRolePermissionMappings() {
        RoleIdToDocumentPermissionSetTypeMappings rolePermissionMappings = (RoleIdToDocumentPermissionSetTypeMappings)this.attributes.roleIdToDocumentPermissionSetTypeMappings.get();
        return rolePermissionMappings;
    }

    public void setRoleIdsMappedToDocumentPermissionSetTypes(RoleIdToDocumentPermissionSetTypeMappings roleIdToDocumentPermissionSetTypeMappings) {
        this.attributes.roleIdToDocumentPermissionSetTypeMappings.set((LazilyLoadedObject.Copyable)roleIdToDocumentPermissionSetTypeMappings.clone());
    }

    public Set getSectionIds() {
        return Collections.unmodifiableSet((Set)this.attributes.sectionIds.get());
    }

    public void setSectionIds(Set sectionIds) {
        this.attributes.sectionIds.set(new CopyableHashSet((Collection)sectionIds));
    }

    public Document.PublicationStatus getPublicationStatus() {
        return this.attributes.publicationStatus;
    }

    public void setPublicationStatus(Document.PublicationStatus status) {
        if (null == status) {
            throw new NullArgumentException("status");
        }
        this.attributes.publicationStatus = status;
    }

    public String getTarget() {
        return this.attributes.target;
    }

    public void setTarget(String v) {
        this.attributes.target = v;
    }

    public boolean isArchived() {
        return this.hasBeenArchivedAtTime(new Date());
    }

    public boolean isLinkableByOtherUsers() {
        return this.attributes.linkableByOtherUsers;
    }

    public void setLinkableByOtherUsers(boolean linkableByOtherUsers) {
        this.attributes.linkableByOtherUsers = linkableByOtherUsers;
    }

    public boolean isRestrictedOneMorePrivilegedThanRestrictedTwo() {
        return this.attributes.restrictedOneMorePrivilegedThanRestrictedTwo;
    }

    public void setRestrictedOneMorePrivilegedThanRestrictedTwo(boolean b) {
        this.attributes.restrictedOneMorePrivilegedThanRestrictedTwo = b;
    }

    public boolean isPublished() {
        return this.isPublishedAtTime(new Date());
    }

    public boolean isActive() {
        return this.isActiveAtTime(new Date());
    }

    private boolean isActiveAtTime(Date now) {
        return this.isPublishedAtTime(now) && !this.hasBeenArchivedAtTime(now);
    }

    public boolean isSearchDisabled() {
        return this.attributes.searchDisabled;
    }

    public void setSearchDisabled(boolean searchDisabled) {
        this.attributes.searchDisabled = searchDisabled;
    }

    public boolean isLinkedForUnauthorizedUsers() {
        return this.attributes.linkedForUnauthorizedUsers;
    }

    public void setLinkedForUnauthorizedUsers(boolean linkedForUnauthorizedUsers) {
        this.attributes.linkedForUnauthorizedUsers = linkedForUnauthorizedUsers;
    }

    public void addCategoryId(int categoryId) {
        Set categoryIds = (Set)this.attributes.categoryIds.get();
        categoryIds.add(new Integer(categoryId));
    }

    public void addSectionId(int sectionId) {
        Set sectionIds = (Set)this.attributes.sectionIds.get();
        sectionIds.add(new Integer(sectionId));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDomainObject)) {
            return false;
        }
        DocumentDomainObject document = (DocumentDomainObject)o;
        return this.attributes.id == document.attributes.id;
    }

    public abstract DocumentTypeDomainObject getDocumentType();

    public final int getDocumentTypeId() {
        return this.getDocumentType().getId();
    }

    public final LocalizedMessage getDocumentTypeName() {
        return this.getDocumentType().getName();
    }

    public int hashCode() {
        return this.attributes.id;
    }

    private boolean hasBeenArchivedAtTime(Date time) {
        Date archivedDatetime = this.attributes.archivedDatetime;
        return archivedDatetime != null && archivedDatetime.before(time);
    }

    public void removeAllCategories() {
        this.attributes.categoryIds.set(new CopyableHashSet());
    }

    public void removeAllSections() {
        this.attributes.sectionIds.set(new CopyableHashSet());
    }

    public void removeCategoryId(int categoryId) {
        Set categoryIds = (Set)this.attributes.categoryIds.get();
        categoryIds.remove(new Integer(categoryId));
    }

    public void setDocumentPermissionSetTypeForRoleId(RoleId roleId, DocumentPermissionSetTypeDomainObject permissionSetType) {
        this.getRolePermissionMappings().setPermissionSetTypeForRole(roleId, permissionSetType);
    }

    public DocumentPermissionSetTypeDomainObject getDocumentPermissionSetTypeForRoleId(RoleId roleId) {
        return this.getRolePermissionMappings().getPermissionSetTypeForRole(roleId);
    }

    private boolean isPublishedAtTime(Date date) {
        boolean statusIsApproved = Document.PublicationStatus.APPROVED.equals(this.getPublicationStatus());
        return statusIsApproved && this.publicationHasStartedAtTime(date) && !this.publicationHasEndedAtTime(date);
    }

    private boolean publicationHasStartedAtTime(Date date) {
        Date publicationStartDatetime = this.attributes.publicationStartDatetime;
        return publicationStartDatetime != null && publicationStartDatetime.before(date);
    }

    private boolean publicationHasEndedAtTime(Date date) {
        Date publicationEndDatetime = this.attributes.publicationEndDatetime;
        return publicationEndDatetime != null && publicationEndDatetime.before(date);
    }

    public DocumentPermissionSets getPermissionSets() {
        return (DocumentPermissionSets)this.attributes.permissionSets.get();
    }

    public DocumentPermissionSets getPermissionSetsForNewDocuments() {
        return (DocumentPermissionSets)this.attributes.permissionSetsForNewDocuments.get();
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public abstract void accept(DocumentVisitor var1);

    public LifeCyclePhase getLifeCyclePhase() {
        return this.getLifeCyclePhaseAtTime(new Date());
    }

    LifeCyclePhase getLifeCyclePhaseAtTime(Date time) {
        Document.PublicationStatus publicationStatus = this.getPublicationStatus();
        LifeCyclePhase lifeCyclePhase = Document.PublicationStatus.NEW.equals(publicationStatus) ? LifeCyclePhase.NEW : (Document.PublicationStatus.DISAPPROVED.equals(publicationStatus) ? LifeCyclePhase.DISAPPROVED : (this.publicationHasEndedAtTime(time) ? LifeCyclePhase.UNPUBLISHED : (this.publicationHasStartedAtTime(time) ? (this.hasBeenArchivedAtTime(time) ? LifeCyclePhase.ARCHIVED : LifeCyclePhase.PUBLISHED) : LifeCyclePhase.APPROVED)));
        return lifeCyclePhase;
    }

    public void setLazilyLoadedSectionIds(LazilyLoadedObject sectionIds) {
        this.attributes.sectionIds = sectionIds;
    }

    public void setLazilyLoadedKeywords(LazilyLoadedObject keywords) {
        this.attributes.keywords = keywords;
    }

    public void setLazilyLoadedProperties(LazilyLoadedObject properties) {
        this.attributes.properties = properties;
    }

    public void setLazilyLoadedCategoryIds(LazilyLoadedObject categoryIds) {
        this.attributes.categoryIds = categoryIds;
    }

    public void setLazilyLoadedRoleIdsMappedToDocumentPermissionSetTypes(LazilyLoadedObject rolePermissionMappings) {
        this.attributes.roleIdToDocumentPermissionSetTypeMappings = rolePermissionMappings;
    }

    public void setLazilyLoadedPermissionSets(LazilyLoadedObject permissionSets) {
        this.attributes.permissionSets = permissionSets;
    }

    public void setLazilyLoadedPermissionSetsForNew(LazilyLoadedObject permissionSetsForNew) {
        this.attributes.permissionSetsForNewDocuments = permissionSetsForNew;
    }

    public void loadAllLazilyLoaded() {
        this.attributes.categoryIds.load();
        this.attributes.sectionIds.load();
        this.attributes.keywords.load();
        this.attributes.permissionSets.load();
        this.attributes.permissionSetsForNewDocuments.load();
        this.attributes.roleIdToDocumentPermissionSetTypeMappings.load();
        this.attributes.properties.load();
    }

    public String getAlias() {
        return this.getProperty(DOCUMENT_PROPERTIES__IMCMS_DOCUMENT_ALIAS);
    }

    public void setAlias(String alias) {
        if (alias == null) {
            this.removeProperty(DOCUMENT_PROPERTIES__IMCMS_DOCUMENT_ALIAS);
        } else {
            this.setProperty(DOCUMENT_PROPERTIES__IMCMS_DOCUMENT_ALIAS, alias);
        }
    }

    public String getName() {
        return StringUtils.defaultString((String)this.getAlias(), (String)(this.getId() + ""));
    }

    public static class Attributes
    implements Cloneable,
    Serializable {
        private Date archivedDatetime;
        private Date createdDatetime;
        private int creatorId;
        private String headline = "";
        private String image;
        private String languageIso639_2;
        private boolean linkableByOtherUsers;
        private String menuText = "";
        private int id;
        private Date modifiedDatetime;
        private Date actualModifiedDatetime;
        private boolean restrictedOneMorePrivilegedThanRestrictedTwo;
        private Date publicationStartDatetime;
        private Date publicationEndDatetime;
        private Integer publisherId;
        private boolean searchDisabled;
        private Document.PublicationStatus publicationStatus = Document.PublicationStatus.NEW;
        private String target;
        private boolean linkedForUnauthorizedUsers;
        private LazilyLoadedObject categoryIds = new LazilyLoadedObject(new CopyableHashSetLoader());
        private LazilyLoadedObject keywords = new LazilyLoadedObject(new CopyableHashSetLoader());
        private LazilyLoadedObject sectionIds = new LazilyLoadedObject(new CopyableHashSetLoader());
        private LazilyLoadedObject permissionSets = new LazilyLoadedObject(new DocumentPermissionSetsLoader());
        private LazilyLoadedObject permissionSetsForNewDocuments = new LazilyLoadedObject(new DocumentPermissionSetsLoader());
        private LazilyLoadedObject properties = new LazilyLoadedObject(new CopyableHashMapLoader());
        private LazilyLoadedObject roleIdToDocumentPermissionSetTypeMappings = new LazilyLoadedObject(new LazilyLoadedObject.Loader(){

            public LazilyLoadedObject.Copyable load() {
                return new RoleIdToDocumentPermissionSetTypeMappings();
            }
        });

        public Object clone() throws CloneNotSupportedException {
            Attributes clone = (Attributes)super.clone();
            clone.keywords = (LazilyLoadedObject)this.keywords.clone();
            clone.properties = (LazilyLoadedObject)this.properties.clone();
            clone.sectionIds = (LazilyLoadedObject)this.sectionIds.clone();
            clone.categoryIds = (LazilyLoadedObject)this.categoryIds.clone();
            clone.roleIdToDocumentPermissionSetTypeMappings = (LazilyLoadedObject)this.roleIdToDocumentPermissionSetTypeMappings.clone();
            clone.permissionSets = (LazilyLoadedObject)this.permissionSets.clone();
            clone.permissionSetsForNewDocuments = (LazilyLoadedObject)this.permissionSetsForNewDocuments.clone();
            return clone;
        }

        private static class DocumentPermissionSetsLoader
        implements LazilyLoadedObject.Loader {
            private DocumentPermissionSetsLoader() {
            }

            public LazilyLoadedObject.Copyable load() {
                return new DocumentPermissionSets();
            }
        }

        private static class CopyableHashMapLoader
        implements LazilyLoadedObject.Loader {
            private CopyableHashMapLoader() {
            }

            public LazilyLoadedObject.Copyable load() {
                return new CopyableHashMap();
            }
        }

        private static class CopyableHashSetLoader
        implements LazilyLoadedObject.Loader {
            private CopyableHashSetLoader() {
            }

            public LazilyLoadedObject.Copyable load() {
                return new CopyableHashSet();
            }
        }
    }
}

