/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.imcms.db.DdlUtilsPlatformCommand;
import imcode.server.SanityCheck;
import imcode.server.SimpleProblem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddForeignKeyChange;
import org.apache.ddlutils.alteration.AddIndexChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.AddTableChange;
import org.apache.ddlutils.alteration.ColumnAutoIncrementChange;
import org.apache.ddlutils.alteration.ColumnChange;
import org.apache.ddlutils.alteration.ColumnDataTypeChange;
import org.apache.ddlutils.alteration.ColumnDefaultValueChange;
import org.apache.ddlutils.alteration.ColumnOrderChange;
import org.apache.ddlutils.alteration.ColumnRequiredChange;
import org.apache.ddlutils.alteration.ColumnSizeChange;
import org.apache.ddlutils.alteration.ModelChange;
import org.apache.ddlutils.alteration.ModelComparator;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemoveForeignKeyChange;
import org.apache.ddlutils.alteration.RemoveIndexChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveTableChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseSanityCheck
implements SanityCheck {
    private Database database;
    private org.apache.ddlutils.model.Database wantedModel;

    public DatabaseSanityCheck(Database database, org.apache.ddlutils.model.Database wantedModel) {
        this.database = database;
        this.wantedModel = wantedModel;
    }

    @Override
    public Collection<SanityCheck.Problem> execute() {
        DdlUtilsPlatformCommand databaseCommand = new DdlUtilsPlatformCommand(){

            protected Object executePlatform(DatabaseConnection databaseConnection, Platform platform) {
                org.apache.ddlutils.model.Database actualModel = platform.readModelFromDatabase(null);
                ModelComparator modelComparator = new ModelComparator(platform.getPlatformInfo(), false);
                List changes = modelComparator.compare(actualModel, DatabaseSanityCheck.this.wantedModel);
                HashSet<Class> errorChanges = new HashSet<Class>(Arrays.asList(AddColumnChange.class, RemoveColumnChange.class, AddTableChange.class, ColumnAutoIncrementChange.class, AddPrimaryKeyChange.class, ColumnRequiredChange.class, PrimaryKeyChange.class, AddIndexChange.class, ColumnDataTypeChange.class));
                HashSet<Class> warningChanges = new HashSet<Class>(Arrays.asList(ColumnSizeChange.class, AddForeignKeyChange.class, ColumnOrderChange.class));
                HashSet<Class> ignoredChanges = new HashSet<Class>(Arrays.asList(RemoveForeignKeyChange.class, RemoveIndexChange.class, RemoveTableChange.class, RemovePrimaryKeyChange.class, ColumnDefaultValueChange.class));
                ArrayList<SanityCheck.Problem> problems = new ArrayList<SanityCheck.Problem>();
                for (ModelChange change : changes) {
                    Class<?> changeClass = change.getClass();
                    SanityCheck.Problem problem = null;
                    if (errorChanges.contains(changeClass)) {
                        problem = DatabaseSanityCheck.getProblem(SanityCheck.Problem.Severity.ERROR, change, platform);
                    } else if (warningChanges.contains(changeClass)) {
                        problem = DatabaseSanityCheck.getProblem(SanityCheck.Problem.Severity.WARNING, change, platform);
                    } else if (!ignoredChanges.contains(changeClass)) {
                        problem = DatabaseSanityCheck.getProblem(SanityCheck.Problem.Severity.UNKNOWN, change, platform);
                    }
                    if (null == problem) continue;
                    problems.add(problem);
                }
                return problems;
            }
        };
        return (Collection)this.database.execute((DatabaseCommand)databaseCommand);
    }

    private static SanityCheck.Problem getProblem(SanityCheck.Problem.Severity severity, ModelChange change, Platform platform) {
        RemoveForeignKeyChange removeForeignKeyChange;
        String changeString;
        if (change instanceof RemoveIndexChange) {
            RemoveIndexChange removeIndexChange = (RemoveIndexChange)change;
            Index index = removeIndexChange.getIndex();
            changeString = "Unexpected index " + index.getName() + " on column(s) " + DatabaseSanityCheck.stringifyIndexColumns(index);
        } else if (change instanceof ColumnDefaultValueChange) {
            ColumnDefaultValueChange columnDefaultValueChange = (ColumnDefaultValueChange)change;
            changeString = "Unexpected default value " + columnDefaultValueChange.getChangedColumn().getDefaultValue() + ", expected " + columnDefaultValueChange.getNewDefaultValue();
        } else if (change instanceof ColumnDataTypeChange) {
            ColumnDataTypeChange columnDataTypeChange = (ColumnDataTypeChange)change;
            changeString = "Expected data type " + platform.getPlatformInfo().getNativeType(columnDataTypeChange.getNewTypeCode());
        } else if (change instanceof AddTableChange) {
            AddTableChange addTableChange = (AddTableChange)change;
            changeString = "Missing table " + addTableChange.getNewTable();
        } else if (change instanceof RemoveForeignKeyChange) {
            removeForeignKeyChange = (RemoveForeignKeyChange)change;
            ForeignKey foreignKey = removeForeignKeyChange.getForeignKey();
            changeString = "Unexpected foreign key to " + foreignKey.getForeignTableName();
            changeString = changeString + " (" + DatabaseSanityCheck.stringifyReferences(foreignKey) + ")";
        } else if (change instanceof AddForeignKeyChange) {
            removeForeignKeyChange = (AddForeignKeyChange)change;
            ForeignKey newForeignKey = removeForeignKeyChange.getNewForeignKey();
            changeString = "Missing foreign key to " + newForeignKey.getForeignTableName();
            changeString = changeString + " (" + DatabaseSanityCheck.stringifyReferences(newForeignKey) + ")";
        } else if (change instanceof AddIndexChange) {
            AddIndexChange addIndexChange = (AddIndexChange)change;
            Index index = addIndexChange.getNewIndex();
            changeString = "Missing index " + index.getName() + " on column(s) " + DatabaseSanityCheck.stringifyIndexColumns(index);
        } else {
            changeString = change.toString();
        }
        if (change instanceof ColumnChange) {
            ColumnChange columnChange = (ColumnChange)change;
            changeString = columnChange.getChangedTable().getName() + "." + columnChange.getChangedColumn().getName() + ": " + changeString;
        } else if (change instanceof TableChange) {
            changeString = ((TableChange)change).getChangedTable().getName() + ": " + changeString;
        }
        return new SimpleProblem(severity, changeString);
    }

    private static String stringifyIndexColumns(Index index) {
        return DatabaseSanityCheck.commafy(index.getColumns(), new Transformer(){

            public Object transform(Object input) {
                IndexColumn indexColumn = (IndexColumn)input;
                return indexColumn.getName();
            }
        });
    }

    private static String stringifyReferences(ForeignKey newForeignKey) {
        return DatabaseSanityCheck.commafy(newForeignKey.getReferences(), new Transformer(){

            public Object transform(Object input) {
                Reference reference = (Reference)input;
                return reference.getLocalColumnName() + " -> " + reference.getForeignColumnName();
            }
        });
    }

    private static String commafy(Object[] array, Transformer transformer) {
        return StringUtils.join(CollectionUtils.collect(Arrays.asList(array), (Transformer)transformer).iterator(), (String)", ");
    }
}

