/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import imcode.server.LanguageMapper;
import imcode.server.user.RoleId;
import java.io.File;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private File templatePath;
    private File includePath;
    private File filePath;
    private File imagePath;
    private File imageCachePath;
    private String imageCacheAllowedPaths;
    private long imageCacheMaxSize;
    private String imageUrl;
    private String smtpServer;
    private int smtpPort;
    private String defaultLanguage;
    private String sessionCookieDomain;
    private String fileAdminRootPaths;
    private float indexingSchedulePeriodInMinutes;
    private String documentPathPrefix;
    private int documentCacheMaxSize = 100;
    private String keyStorePath;
    private String keyStoreType;
    private String workaroundUriEncoding;
    private boolean secureLoginRequired;
    private boolean denyMultipleUserLogin;
    private String imageArchiveUrl;
    private String imageArchiveAllowedRoleIds;
    private List<RoleId> imageArchiveAllowedRoleIdList;
    private File imageArchiveImagePath;
    private String imageArchiveImageUrl;
    private File imageMagickPath;

    public String getWorkaroundUriEncoding() {
        return this.workaroundUriEncoding;
    }

    public void setWorkaroundUriEncoding(String workaroundUriEncoding) {
        Charset charset = StringUtils.isNotBlank((String)workaroundUriEncoding) ? Charset.forName(workaroundUriEncoding) : Charset.defaultCharset();
        this.workaroundUriEncoding = charset.name();
    }

    public void setTemplatePath(File templatePath) {
        this.templatePath = templatePath;
    }

    public void setIncludePath(File includePath) {
        this.includePath = includePath;
    }

    public void setFilePath(File filePath) {
        this.filePath = filePath;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        try {
            if (defaultLanguage.length() < 3) {
                defaultLanguage = LanguageMapper.convert639_1to639_2(defaultLanguage);
            }
        }
        catch (LanguageMapper.LanguageNotSupportedException e1) {
            defaultLanguage = null;
        }
        this.defaultLanguage = defaultLanguage;
    }

    public File getFilePath() {
        return this.filePath;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public File getTemplatePath() {
        return this.templatePath;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public File getIncludePath() {
        return this.includePath;
    }

    public String getSessionCookieDomain() {
        return this.sessionCookieDomain;
    }

    public void setSessionCookieDomain(String sessionCookieDomain) {
        this.sessionCookieDomain = sessionCookieDomain;
    }

    public File getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(File imagePath) {
        this.imagePath = imagePath;
    }

    public String getFileAdminRootPaths() {
        return this.fileAdminRootPaths;
    }

    public void setFileAdminRootPaths(String fileAdminRootPaths) {
        this.fileAdminRootPaths = fileAdminRootPaths;
    }

    public float getIndexingSchedulePeriodInMinutes() {
        return this.indexingSchedulePeriodInMinutes;
    }

    public void setIndexingSchedulePeriodInMinutes(float indexingSchedulePeriodInMinutes) {
        this.indexingSchedulePeriodInMinutes = indexingSchedulePeriodInMinutes;
    }

    public String getDocumentPathPrefix() {
        return this.documentPathPrefix;
    }

    public void setDocumentPathPrefix(String documentPathPrefix) {
        this.documentPathPrefix = documentPathPrefix;
    }

    public int getDocumentCacheMaxSize() {
        return this.documentCacheMaxSize;
    }

    public void setDocumentCacheMaxSize(int documentCacheMaxSize) {
        this.documentCacheMaxSize = documentCacheMaxSize;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        if (StringUtils.isBlank((String)keyStoreType)) {
            keyStoreType = KeyStore.getDefaultType();
        }
        this.keyStoreType = keyStoreType;
    }

    public boolean getSecureLoginRequired() {
        return this.secureLoginRequired;
    }

    public void setSecureLoginRequired(boolean secureLoginRequired) {
        this.secureLoginRequired = secureLoginRequired;
    }

    public boolean isDenyMultipleUserLogin() {
        return this.denyMultipleUserLogin;
    }

    public void setDenyMultipleUserLogin(boolean denyMultipleUserLogin) {
        this.denyMultipleUserLogin = denyMultipleUserLogin;
    }

    public String getImageArchiveUrl() {
        return this.imageArchiveUrl;
    }

    public void setImageArchiveUrl(String imageArchiveUrl) {
        this.imageArchiveUrl = imageArchiveUrl;
    }

    public File getImageArchiveImagePath() {
        return this.imageArchiveImagePath;
    }

    public void setImageArchiveImagePath(File imageArchiveImagePath) {
        this.imageArchiveImagePath = imageArchiveImagePath;
    }

    public String getImageArchiveImageUrl() {
        return this.imageArchiveImageUrl;
    }

    public void setImageArchiveImageUrl(String imageArchiveImageUrl) {
        this.imageArchiveImageUrl = imageArchiveImageUrl;
    }

    public String getImageArchiveAllowedRoleIds() {
        return this.imageArchiveAllowedRoleIds;
    }

    public void setImageArchiveAllowedRoleIds(String imageArchiveAllowedRoleIds) {
        this.imageArchiveAllowedRoleIds = imageArchiveAllowedRoleIds;
        if (imageArchiveAllowedRoleIds != null) {
            String[] ids = StringUtils.split((String)imageArchiveAllowedRoleIds, (char)',');
            this.imageArchiveAllowedRoleIdList = new ArrayList<RoleId>(ids.length);
            for (String id : ids) {
                try {
                    this.imageArchiveAllowedRoleIdList.add(new RoleId(Integer.parseInt(id.trim())));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public List<RoleId> getImageArchiveAllowedRoleIdList() {
        return this.imageArchiveAllowedRoleIdList;
    }

    public void setImageArchiveAllowedRoleIdList(List<RoleId> imageArchiveAllowedRoleIdList) {
        this.imageArchiveAllowedRoleIdList = imageArchiveAllowedRoleIdList;
    }

    public File getImageCachePath() {
        return this.imageCachePath;
    }

    public void setImageCachePath(File imageCachePath) {
        this.imageCachePath = imageCachePath;
    }

    public String getImageCacheAllowedPaths() {
        return this.imageCacheAllowedPaths;
    }

    public void setImageCacheAllowedPaths(String imageCacheAllowedPaths) {
        this.imageCacheAllowedPaths = imageCacheAllowedPaths;
    }

    public long getImageCacheMaxSize() {
        return this.imageCacheMaxSize;
    }

    public void setImageCacheMaxSize(long imageCacheMaxSize) {
        this.imageCacheMaxSize = imageCacheMaxSize;
    }

    public File getImageMagickPath() {
        return this.imageMagickPath;
    }

    public void setImageMagickPath(File imageMagickPath) {
        this.imageMagickPath = imageMagickPath;
    }
}

