/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.test.external;

import imcode.server.user.LdapUserAndRoleRegistry;
import imcode.server.user.UserDomainObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.SimpleLayout;

public class TestLdapUserAndRoleRegistry
extends TestCase {
    private Properties ldapProperties = new Properties();
    String testUserName;
    String testPassword;
    private static final String LDAP_PROPERTIES_SYSTEM_PROPERTY = "test.ldap.properties";
    private static final String DEFAULT_LDAP_PROPERTIES_FILE = "build.properties";
    private LdapUserAndRoleRegistry ldapUserAndRoleRegistry;

    private void initLog4J() throws IOException {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File tmpFile = new File(tmpDir, "log4joutput.log");
        BasicConfigurator.configure((Appender)new FileAppender((Layout)new SimpleLayout(), tmpFile.toString()));
    }

    LdapUserAndRoleRegistry getLdapUserAndRoleRegistry(String[] ldapAttributesMappedToRoles) throws Exception {
        String propertyFileName = System.getProperty(LDAP_PROPERTIES_SYSTEM_PROPERTY, DEFAULT_LDAP_PROPERTIES_FILE);
        this.ldapProperties.load(new FileInputStream(propertyFileName));
        String ldapUrl = this.ldapProperties.getProperty("ldap-url");
        String ldapPassword = this.ldapProperties.getProperty("ldap-password");
        String ldapBindDN = this.ldapProperties.getProperty("ldap-bind-dn");
        String ldapUserObjectClass = this.ldapProperties.getProperty("ldap-user-object-class");
        String ldapAttributeLoginName = this.ldapProperties.getProperty("ldap-attribute-login-name");
        this.testUserName = this.ldapProperties.getProperty("ldap-test-user");
        this.testPassword = this.ldapProperties.getProperty("ldap-test-password");
        if (StringUtils.isBlank((String)this.testUserName)) {
            throw new Exception("Set ldap-test-user in " + propertyFileName);
        }
        LdapUserAndRoleRegistry ldapUserAndRoleRegistry = new LdapUserAndRoleRegistry(ldapUrl, ldapUserObjectClass, ldapBindDN, ldapPassword, ldapAttributesMappedToRoles, new Properties());
        ldapUserAndRoleRegistry.setUserPropertyLdapAttribute("LoginName", ldapAttributeLoginName);
        return ldapUserAndRoleRegistry;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.initLog4J();
        this.ldapUserAndRoleRegistry = this.getLdapUserAndRoleRegistry(new String[0]);
    }

    public void testExistingUser() {
        UserDomainObject user = this.findUser(this.testUserName);
        TestLdapUserAndRoleRegistry.assertEquals((String)this.testUserName, (String)user.getLoginName());
        TestLdapUserAndRoleRegistry.assertNull((Object)user.getPassword());
    }

    private UserDomainObject findUser(String username) {
        UserDomainObject user = this.ldapUserAndRoleRegistry.getUser(username);
        TestLdapUserAndRoleRegistry.assertNotNull((String)("Search for user \"" + username + "\""), (Object)user);
        return user;
    }

    public void testAuthenticate() {
        boolean userAuthenticates = this.ldapUserAndRoleRegistry.authenticate(this.testUserName, this.testPassword);
        TestLdapUserAndRoleRegistry.assertTrue((boolean)userAuthenticates);
    }

    public void testInvalidName() {
        UserDomainObject user = this.ldapUserAndRoleRegistry.getUser("");
        TestLdapUserAndRoleRegistry.assertNull((Object)user);
    }

    public void testNonExistingUser() {
        UserDomainObject user = this.ldapUserAndRoleRegistry.getUser("non-existing user");
        TestLdapUserAndRoleRegistry.assertNull((Object)user);
    }

    public void testGetRolesForUserLdapService() {
        UserDomainObject user = this.findUser(this.testUserName);
        String[] roleNames = this.ldapUserAndRoleRegistry.getRoleNames(user);
        TestLdapUserAndRoleRegistry.assertNotNull((Object)roleNames);
        TestLdapUserAndRoleRegistry.assertTrue((boolean)Arrays.asList(roleNames).contains("LDAP"));
    }

    public void testGetAllRoleNames() {
        String[] roleNames = this.ldapUserAndRoleRegistry.getAllRoleNames();
        TestLdapUserAndRoleRegistry.assertNotNull((Object)roleNames);
        TestLdapUserAndRoleRegistry.assertTrue((boolean)Arrays.asList(roleNames).contains("LDAP"));
    }
}

