/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.tags;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.TextDocument;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.parser.MenuParser;
import imcode.server.parser.ParserParameters;
import imcode.server.parser.TagParser;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.iterators.FilterIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuTag
extends BodyTagSupport {
    private int no;
    private Properties attributes = new Properties();
    private Iterator<MenuItemDomainObject> menuItemIterator;
    private MenuItemDomainObject menuItem;
    private String template;
    private MenuDomainObject menu;
    private String label;

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ParserParameters parserParameters = ParserParameters.fromRequest(request);
        TextDocumentDomainObject document = (TextDocumentDomainObject)parserParameters.getDocumentRequest().getDocument();
        this.menu = document.getMenu(this.no);
        MenuItemDomainObject[] menuItems = this.menu.getMenuItems();
        this.menuItemIterator = new FilterIterator((Iterator)new ArrayIterator((Object)menuItems), (Predicate)new MenuParser.UserCanSeeMenuItemPredicate(parserParameters.getDocumentRequest().getUser()));
        if (this.menuItemIterator.hasNext()) {
            this.nextMenuItem();
            return 2;
        }
        return 0;
    }

    public boolean nextMenuItem() {
        if (this.menuItemIterator.hasNext()) {
            this.menuItem = this.menuItemIterator.next();
            this.pageContext.setAttribute("menuitem", (Object)new TextDocument.MenuItem(this.menuItem, ContentManagementSystem.fromRequest(this.pageContext.getRequest())));
            return true;
        }
        this.invalidateMenuItem();
        return false;
    }

    public int doAfterBody() throws JspException {
        if (this.menuItemIterator.hasNext()) {
            this.nextMenuItem();
            return 2;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            String bodyContentString = null != this.getBodyContent() ? this.getBodyContent().getString() : "";
            this.bodyContent = null;
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            ParserParameters parserParameters = ParserParameters.fromRequest(request);
            bodyContentString = MenuParser.addMenuAdmin(this.no, parserParameters.isMenuMode(), bodyContentString, this.menu, request, response, this.label);
            bodyContentString = TagParser.addPreAndPost(this.attributes, bodyContentString);
            this.pageContext.getOut().write(bodyContentString);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        catch (ServletException e) {
            throw new JspException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public void setNo(int no) {
        this.no = no;
    }

    public int getNo() {
        return this.no;
    }

    public void setMode(String mode) {
        this.attributes.setProperty("mode", mode);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setPre(String pre) {
        this.attributes.setProperty("pre", pre);
    }

    public void setPost(String post) {
        this.attributes.setProperty("post", post);
    }

    public Iterator<MenuItemDomainObject> getMenuItemIterator() {
        return this.menuItemIterator;
    }

    public MenuItemDomainObject getMenuItem() {
        if (null == this.menuItem) {
            this.nextMenuItem();
        }
        return this.menuItem;
    }

    public void invalidateMenuItem() {
        this.menuItem = null;
        this.pageContext.removeAttribute("menuitem");
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }
}

