/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.OkCancelPage;
import com.imcode.imcms.mapping.NoPermissionInternalException;
import com.imcode.imcms.util.l10n.LocalizedMessage;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.PhoneNumber;
import imcode.server.user.PhoneNumberType;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import imcode.util.ArraySet;
import imcode.util.Html;
import imcode.util.ShouldHaveCheckedPermissionsEarlierException;
import imcode.util.ToStringPairTransformer;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class UserEditorPage
extends OkCancelPage {
    public static final String REQUEST_PARAMETER__LOGIN_NAME = "login_name";
    public static final String REQUEST_PARAMETER__PASSWORD1 = "password1";
    public static final String REQUEST_PARAMETER__FIRST_NAME = "first_name";
    public static final String REQUEST_PARAMETER__LAST_NAME = "last_name";
    public static final String REQUEST_PARAMETER__TITLE = "title";
    public static final String REQUEST_PARAMETER__COMPANY = "company";
    public static final String REQUEST_PARAMETER__ADDRESS = "address";
    public static final String REQUEST_PARAMETER__CITY = "city";
    public static final String REQUEST_PARAMETER__ZIP = "zip";
    public static final String REQUEST_PARAMETER__COUNTRY = "country";
    public static final String REQUEST_PARAMETER__DISTRICT = "county";
    public static final String REQUEST_PARAMETER__EMAIL = "email";
    public static final String REQUEST_PARAMETER__LANGUAGE = "lang_id";
    public static final String REQUEST_PARAMETER__ACTIVE = "active";
    public static final String REQUEST_PARAMETER__PASSWORD2 = "password2";
    public static final String REQUEST_PARAMETER__ROLE_IDS = "role_ids";
    public static final String REQUEST_PARAMETER__USER_ADMIN_ROLE_IDS = "user_admin_role_ids";
    public static final String REQUEST_PARAMETER__ADD_PHONE_NUMBER = "add_phone_number";
    public static final String REQUEST_PARAMETER__EDIT_PHONE_NUMBER = "edit_phone_number";
    public static final String REQUEST_PARAMETER__REMOVE_PHONE_NUMBER = "delete_phone_number";
    public static final String REQUEST_PARAMETER__PHONE_NUMBER_TYPE_ID = "phone_number_type_id";
    public static final String REQUEST_PARAMETER__EDITED_PHONE_NUMBER = "edited_phone_number";
    public static final String REQUEST_PARAMETER__SELECTED_PHONE_NUMBER = "selected_phone_number";
    private static final LocalizedMessage ERROR__PASSWORDS_DID_NOT_MATCH = new LocalizedMessage("error/passwords_did_not_match");
    private static final LocalizedMessage ERROR__PASSWORD_LENGTH = new LocalizedMessage("error/password_length");
    private static final LocalizedMessage ERROR__PASSWORD_TOO_WEAK = new LocalizedMessage("error/password_too_weak");
    private static final LocalizedMessage ERROR__EDITED_USER_MUST_HAVE_AT_LEAST_ONE_ROLE = new LocalizedMessage("error/user_must_have_at_least_one_role");
    private UserDomainObject editedUser;
    private UserDomainObject uneditedUser;
    private PhoneNumber currentPhoneNumber = new PhoneNumber("", PhoneNumberType.OTHER);
    private LocalizedMessage errorMessage;
    private static final int MAXIMUM_PASSWORD_LENGTH = 15;
    private static final int MINIMUM_PASSWORD_LENGTH = 4;

    public UserEditorPage(UserDomainObject user, DispatchCommand okDispatchCommand, DispatchCommand cancelDispatchCommand) {
        super(okDispatchCommand, cancelDispatchCommand);
        this.editedUser = user;
        this.uneditedUser = (UserDomainObject)user.clone();
    }

    protected void updateFromRequest(HttpServletRequest request) {
        this.updateUserFromRequest(request);
    }

    private void updateUserFromRequest(HttpServletRequest request) {
        this.errorMessage = null;
        this.editedUser.setLoginName(request.getParameter(REQUEST_PARAMETER__LOGIN_NAME));
        this.editedUser.setFirstName(request.getParameter(REQUEST_PARAMETER__FIRST_NAME));
        this.editedUser.setLastName(request.getParameter(REQUEST_PARAMETER__LAST_NAME));
        this.editedUser.setTitle(request.getParameter(REQUEST_PARAMETER__TITLE));
        this.editedUser.setCompany(request.getParameter(REQUEST_PARAMETER__COMPANY));
        this.editedUser.setAddress(request.getParameter(REQUEST_PARAMETER__ADDRESS));
        this.editedUser.setCity(request.getParameter(REQUEST_PARAMETER__CITY));
        this.editedUser.setZip(request.getParameter(REQUEST_PARAMETER__ZIP));
        this.editedUser.setCountry(request.getParameter(REQUEST_PARAMETER__COUNTRY));
        this.editedUser.setProvince(request.getParameter(REQUEST_PARAMETER__DISTRICT));
        this.editedUser.setEmailAddress(request.getParameter(REQUEST_PARAMETER__EMAIL));
        this.editedUser.setLanguageIso639_2(request.getParameter(REQUEST_PARAMETER__LANGUAGE));
        this.editedUser.setActive(null != request.getParameter(REQUEST_PARAMETER__ACTIVE));
        this.updateUserPasswordFromRequest(this.editedUser, request);
        this.updateUserRolesFromRequest(request);
        this.updateUserAdminRolesFromRequest(request);
    }

    private void updateUserAdminRolesFromRequest(HttpServletRequest request) {
        if (Utility.getLoggedOnUser(request).isSuperAdmin() && this.editedUser.isUserAdmin()) {
            this.editedUser.setUserAdminRolesIds(this.getRoleIdsFromRequestParameterValues(request, REQUEST_PARAMETER__USER_ADMIN_ROLE_IDS));
            this.editedUser.removeUserAdminRoleId(RoleId.SUPERADMIN);
            this.editedUser.removeUserAdminRoleId(RoleId.USERADMIN);
        }
    }

    private RoleId[] getRoleIdsFromRequestParameterValues(HttpServletRequest request, String requestParameter) {
        Set roleIds = this.getRoleIdsSetFromRequestParameterValues(request, requestParameter);
        return roleIds.toArray(new RoleId[roleIds.size()]);
    }

    private Set getRoleIdsSetFromRequestParameterValues(HttpServletRequest request, String requestParameter) {
        HashSet<RoleId> roleIds = new HashSet<RoleId>();
        String[] roleIdStrings = request.getParameterValues(requestParameter);
        if (null != roleIdStrings) {
            for (int i = 0; i < roleIdStrings.length; ++i) {
                RoleId roleId = new RoleId(Integer.parseInt(roleIdStrings[i]));
                roleIds.add(roleId);
            }
        }
        return roleIds;
    }

    private ImcmsServices getImcmsServices() {
        return Imcms.getServices();
    }

    private void updateUserRolesFromRequest(HttpServletRequest request) {
        UserDomainObject loggedOnUser = Utility.getLoggedOnUser(request);
        if (loggedOnUser.canEditRolesFor(this.uneditedUser)) {
            RoleId[] userRoleIdsArray;
            Set roleIdsSetFromRequest = this.getRoleIdsSetFromRequestParameterValues(request, REQUEST_PARAMETER__ROLE_IDS);
            if (loggedOnUser.isUserAdminAndNotSuperAdmin()) {
                List<RoleId> userAdminRoleIds = Arrays.asList(loggedOnUser.getUserAdminRoleIds());
                roleIdsSetFromRequest.retainAll(userAdminRoleIds);
                HashSet<RoleId> userRoleIds = new HashSet<RoleId>(Arrays.asList(this.editedUser.getRoleIds()));
                userRoleIds.removeAll(userAdminRoleIds);
                userRoleIds.addAll(roleIdsSetFromRequest);
                userRoleIdsArray = userRoleIds.toArray(new RoleId[userRoleIds.size()]);
            } else {
                userRoleIdsArray = roleIdsSetFromRequest.toArray(new RoleId[roleIdsSetFromRequest.size()]);
            }
            this.editedUser.setRoleIds(userRoleIdsArray);
        }
    }

    private void updateUserPasswordFromRequest(UserDomainObject user, HttpServletRequest request) {
        String password1 = this.getPassword1FromRequest(request);
        if (StringUtils.isNotBlank((String)password1)) {
            if (!this.passwordPassesLengthRequirements(password1)) {
                this.errorMessage = ERROR__PASSWORD_LENGTH;
            } else if (!this.passwordsMatch(request)) {
                this.errorMessage = ERROR__PASSWORDS_DID_NOT_MATCH;
            } else if (!user.isDefaultUser() && password1.equalsIgnoreCase(user.getLoginName())) {
                this.errorMessage = ERROR__PASSWORD_TOO_WEAK;
            } else {
                user.setPassword(password1);
            }
        }
    }

    private boolean passwordPassesLengthRequirements(String password1) {
        return password1.length() >= 4 && password1.length() <= 15;
    }

    public String getPath(HttpServletRequest request) {
        UserDomainObject loggedOnUser = Utility.getLoggedOnUser(request);
        return "/imcms/" + loggedOnUser.getLanguageIso639_2() + "/jsp/usereditor.jsp";
    }

    protected void dispatchOther(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PhoneNumber editedPhoneNumber = this.getEditedPhoneNumberFromRequest(request);
        PhoneNumber selectedPhoneNumber = this.getSelectedPhoneNumberFromRequest(request);
        if (null != request.getParameter(REQUEST_PARAMETER__ADD_PHONE_NUMBER) && null != editedPhoneNumber) {
            if (!editedPhoneNumber.equals(this.currentPhoneNumber)) {
                this.editedUser.removePhoneNumber(this.currentPhoneNumber);
            }
            this.editedUser.removePhoneNumber(editedPhoneNumber);
            this.editedUser.addPhoneNumber(editedPhoneNumber);
            this.currentPhoneNumber = new PhoneNumber("", PhoneNumberType.OTHER);
        } else if (null != request.getParameter(REQUEST_PARAMETER__REMOVE_PHONE_NUMBER) && null != selectedPhoneNumber) {
            this.editedUser.removePhoneNumber(selectedPhoneNumber);
            this.currentPhoneNumber = selectedPhoneNumber;
        } else if (null != request.getParameter(REQUEST_PARAMETER__EDIT_PHONE_NUMBER) && null != selectedPhoneNumber) {
            this.currentPhoneNumber = selectedPhoneNumber;
        }
        this.forward(request, response);
    }

    protected void dispatchOk(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (null == this.errorMessage) {
            if (StringUtils.isBlank((String)this.editedUser.getPassword())) {
                this.errorMessage = ERROR__PASSWORD_LENGTH;
            } else {
                boolean editedUserHasOnlyTheUsersRole = 1 == this.editedUser.getRoleIds().length;
                UserDomainObject loggedOnUser = Utility.getLoggedOnUser(request);
                if (editedUserHasOnlyTheUsersRole || loggedOnUser.isUserAdminAndNotSuperAdmin() && !loggedOnUser.canEditRolesAccordingToUserAdminRoles(this.editedUser)) {
                    this.errorMessage = ERROR__EDITED_USER_MUST_HAVE_AT_LEAST_ONE_ROLE;
                } else {
                    super.dispatchOk(request, response);
                    return;
                }
            }
        }
        this.forward(request, response);
    }

    private boolean passwordsMatch(HttpServletRequest request) {
        String password1 = this.getPassword1FromRequest(request);
        String password2 = request.getParameter(REQUEST_PARAMETER__PASSWORD2);
        return password1.equals(password2);
    }

    private String getPassword1FromRequest(HttpServletRequest request) {
        return request.getParameter(REQUEST_PARAMETER__PASSWORD1);
    }

    private PhoneNumber getEditedPhoneNumberFromRequest(HttpServletRequest request) {
        PhoneNumber editedPhoneNumber = null;
        String editedPhoneNumberString = request.getParameter(REQUEST_PARAMETER__EDITED_PHONE_NUMBER);
        if (StringUtils.isNotBlank((String)editedPhoneNumberString)) {
            int editedPhoneNumberTypeId = Integer.parseInt(request.getParameter(REQUEST_PARAMETER__PHONE_NUMBER_TYPE_ID));
            PhoneNumberType editedPhoneNumberType = PhoneNumberType.getPhoneNumberTypeById(editedPhoneNumberTypeId);
            editedPhoneNumber = new PhoneNumber(editedPhoneNumberString, editedPhoneNumberType);
        }
        return editedPhoneNumber;
    }

    private PhoneNumber getSelectedPhoneNumberFromRequest(HttpServletRequest request) {
        Matcher matcher;
        PhoneNumber selectedPhoneNumber = null;
        String selectedPhoneNumberString = request.getParameter(REQUEST_PARAMETER__SELECTED_PHONE_NUMBER);
        if (StringUtils.isNotBlank((String)selectedPhoneNumberString) && (matcher = Pattern.compile("(\\d+) (.*)").matcher(selectedPhoneNumberString)).matches()) {
            int selectedPhoneNumberTypeId = Integer.parseInt(matcher.group(1));
            PhoneNumberType selectedPhoneNumberType = PhoneNumberType.getPhoneNumberTypeById(selectedPhoneNumberTypeId);
            selectedPhoneNumber = new PhoneNumber(matcher.group(2), selectedPhoneNumberType);
        }
        return selectedPhoneNumber;
    }

    public UserDomainObject getEditedUser() {
        return this.editedUser;
    }

    public String createLanguagesHtmlOptionList(UserDomainObject user, UserDomainObject userToChange) {
        return this.getImcmsServices().getLanguageMapper().createLanguagesOptionList(user, userToChange.getLanguageIso639_2());
    }

    public String createPhoneTypesHtmlOptionList(final UserDomainObject loggedOnUser, PhoneNumberType selectedType) {
        return Html.createOptionList(Arrays.asList(PhoneNumberType.getAllPhoneNumberTypes()), selectedType, new ToStringPairTransformer(){

            public String[] transformToStringPair(Object object) {
                PhoneNumberType phoneType = (PhoneNumberType)object;
                return new String[]{"" + phoneType.getId(), phoneType.getName().toLocalizedString(loggedOnUser)};
            }
        });
    }

    public PhoneNumber getCurrentPhoneNumber() {
        return this.currentPhoneNumber;
    }

    public String getUserPhoneNumbersHtmlOptionList(final HttpServletRequest request) {
        Set phoneNumbers = this.editedUser.getPhoneNumbers();
        return Html.createOptionList((Collection)phoneNumbers, this.currentPhoneNumber, new ToStringPairTransformer(){

            protected String[] transformToStringPair(Object object) {
                PhoneNumber phoneNumber = (PhoneNumber)object;
                return new String[]{phoneNumber.getType().getId() + " " + phoneNumber.getNumber(), "(" + phoneNumber.getType().getName().toLocalizedString(request) + ") " + phoneNumber.getNumber()};
            }
        });
    }

    public LocalizedMessage getErrorMessage() {
        return this.errorMessage;
    }

    public String createRolesHtmlOptionList(HttpServletRequest request) {
        UserDomainObject loggedOnUser = Utility.getLoggedOnUser(request);
        RoleDomainObject[] roles = loggedOnUser.isUserAdminAndNotSuperAdmin() ? this.getRoles(loggedOnUser.getUserAdminRoleIds()) : this.getAllRolesExceptUsersRole();
        RoleDomainObject[] usersRoles = this.getRoles(this.editedUser.getRoleIds());
        return this.createRolesHtmlOptionList(roles, usersRoles);
    }

    private RoleDomainObject[] getRoles(RoleId[] roleIds) {
        RoleDomainObject[] roles = new RoleDomainObject[roleIds.length];
        for (int i = 0; i < roleIds.length; ++i) {
            roles[i] = Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper().getRole(roleIds[i]);
        }
        return roles;
    }

    private String createRolesHtmlOptionList(RoleDomainObject[] allRoles, RoleDomainObject[] usersRoles) {
        return Html.createOptionList(Arrays.asList(allRoles), (Set)new ArraySet(usersRoles), (ToStringPairTransformer)new RoleToStringPairTransformer());
    }

    public String createUserAdminRolesHtmlOptionList() {
        RoleDomainObject[] allRoles = this.getAllRolesExceptUsersRole();
        HashSet<RoleDomainObject> allRolesSet = new HashSet<RoleDomainObject>(Arrays.asList(allRoles));
        CollectionUtils.filter(allRolesSet, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                RoleId roleId = ((RoleDomainObject)o).getId();
                return !roleId.equals(RoleId.SUPERADMIN) && !roleId.equals(RoleId.USERADMIN);
            }
        });
        RoleDomainObject[] allUserAdminRoles = allRolesSet.toArray(new RoleDomainObject[allRolesSet.size()]);
        RoleDomainObject[] usersUserAdminRoles = this.getRoles(this.editedUser.getUserAdminRoleIds());
        return this.createRolesHtmlOptionList(allUserAdminRoles, usersUserAdminRoles);
    }

    private RoleDomainObject[] getAllRolesExceptUsersRole() {
        Object[] allRoles = this.getImcmsServices().getImcmsAuthenticatorAndUserAndRoleMapper().getAllRolesExceptUsersRole();
        Arrays.sort(allRoles);
        return allRoles;
    }

    public void setErrorMessage(LocalizedMessage errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setOkCommand(DispatchCommand okCommand) {
        this.okCommand = okCommand;
    }

    public UserDomainObject getUneditedUser() {
        return this.uneditedUser;
    }

    public void forward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserDomainObject loggedOnUser = Utility.getLoggedOnUser(request);
        if (!this.uneditedUser.isNew() && !loggedOnUser.canEdit(this.uneditedUser)) {
            throw new ShouldHaveCheckedPermissionsEarlierException(new NoPermissionInternalException("User " + loggedOnUser + " does not have the permission to edit " + this.editedUser));
        }
        super.forward(request, response);
    }

    public static class RoleToStringPairTransformer
    extends ToStringPairTransformer {
        protected String[] transformToStringPair(Object object) {
            RoleDomainObject role = (RoleDomainObject)object;
            return new String[]{"" + role.getId(), role.getName()};
        }
    }
}

