/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentSaveException;
import com.imcode.imcms.servlet.admin.AdminDoc;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.ConcurrentDocumentModificationException;
import imcode.server.document.MaxCategoryDomainObjectsOfTypeExceededException;
import imcode.server.document.NoPermissionToEditDocumentException;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.document.TemplateMapper;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.ShouldHaveCheckedPermissionsEarlierException;
import imcode.util.ShouldNotBeThrownException;
import imcode.util.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.UnhandledException;

public class SaveInPage
extends HttpServlet {
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices services = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        DocumentMapper documentMapper = services.getDocumentMapper();
        int documentId = Integer.parseInt(req.getParameter("meta_id"));
        TextDocumentDomainObject textDocument = (TextDocumentDomainObject)documentMapper.getDocument(documentId);
        TemplateMapper templateMapper = services.getTemplateMapper();
        TemplateDomainObject requestedTemplate = this.getRequestedTemplate(req, templateMapper);
        TemplateGroupDomainObject requestedTemplateGroup = this.getRequestedTemplateGroup(req, templateMapper);
        TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)user.getPermissionSetFor(textDocument);
        Set allowedTemplateGroupIds = textDocumentPermissionSet.getAllowedTemplateGroupIds();
        if (!textDocumentPermissionSet.getEditTemplates() || null != requestedTemplateGroup && !allowedTemplateGroupIds.contains(new Integer(requestedTemplateGroup.getId()))) {
            this.errorNoPermission(documentId, user, req, res);
            return;
        }
        if (req.getParameter("update") != null) {
            PrintWriter out = res.getWriter();
            req.getSession().setAttribute("flags", (Object)new Integer(0));
            if (requestedTemplate == null) {
                this.errorNoTemplateSelected(documentId, services, user, out);
                return;
            }
            if (!templateMapper.templateGroupContains(requestedTemplateGroup, requestedTemplate)) {
                this.errorNoPermission(documentId, user, req, res);
                return;
            }
            textDocument.setTemplateName(requestedTemplate.getName());
            if (null != requestedTemplateGroup) {
                textDocument.setTemplateGroupId(requestedTemplateGroup.getId());
            }
            try {
                documentMapper.saveDocument(textDocument, user);
                services.updateMainLog("Text docs  [" + textDocument.getId() + "] updated by user: [" + user.getFullName() + "]");
            }
            catch (MaxCategoryDomainObjectsOfTypeExceededException e) {
                throw new UnhandledException((Throwable)e);
            }
            catch (NoPermissionToEditDocumentException e) {
                throw new ShouldHaveCheckedPermissionsEarlierException(e);
            }
            catch (NoPermissionToAddDocumentToMenuException e) {
                throw new ConcurrentDocumentModificationException(e);
            }
            catch (DocumentSaveException e) {
                throw new ShouldNotBeThrownException(e);
            }
            Utility.setDefaultHtmlContentType(res);
            AdminDoc.adminDoc(documentId, user, req, res, this.getServletContext());
        } else if (req.getParameter("change_group") != null) {
            Utility.setDefaultHtmlContentType(res);
            req.getSession().setAttribute("flags", (Object)new Integer(524288));
            if (null != requestedTemplateGroup) {
                user.setTemplateGroup(requestedTemplateGroup);
            }
            AdminDoc.adminDoc(documentId, user, req, res, this.getServletContext());
        }
    }

    private void errorNoPermission(int documentId, UserDomainObject user, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Utility.setDefaultHtmlContentType(res);
        AdminDoc.adminDoc(documentId, user, req, res, this.getServletContext());
    }

    private void errorNoTemplateSelected(int documentId, ImcmsServices services, UserDomainObject user, Writer out) throws IOException {
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#meta_id#");
        vec.add(String.valueOf(documentId));
        String htmlStr = services.getAdminTemplate("inPage_admin_no_template.html", user, vec);
        out.write(htmlStr);
    }

    private TemplateGroupDomainObject getRequestedTemplateGroup(HttpServletRequest req, TemplateMapper templateMapper) {
        try {
            return templateMapper.getTemplateGroupById(Integer.parseInt(req.getParameter("group")));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private TemplateDomainObject getRequestedTemplate(HttpServletRequest req, TemplateMapper templateMapper) {
        try {
            return templateMapper.getTemplateByName(req.getParameter("template"));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

