/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.api.Document;
import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.DocumentPageFlow;
import com.imcode.imcms.flow.EditDocumentInformationPageFlow;
import com.imcode.imcms.flow.EditFileDocumentPageFlow;
import com.imcode.imcms.flow.OkCancelPage;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentSaveException;
import com.imcode.imcms.mapping.NoPermissionInternalException;
import com.imcode.imcms.servlet.DocumentFinder;
import com.imcode.imcms.servlet.SearchDocumentsPage;
import com.imcode.imcms.servlet.admin.Handler;
import com.imcode.imcms.servlet.admin.ImageBrowser;
import com.imcode.imcms.servlet.admin.ImageCropPage;
import com.imcode.imcms.servlet.superadmin.AdminManager;
import com.imcode.imcms.util.l10n.LocalizedMessage;
import com.imcode.util.HumanReadable;
import com.imcode.util.ImageSize;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.NoPermissionToCreateDocumentException;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.index.DefaultQueryParser;
import imcode.server.document.index.QueryParser;
import imcode.server.document.textdocument.FileDocumentImageSource;
import imcode.server.document.textdocument.ImageArchiveImageSource;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.ImageSource;
import imcode.server.document.textdocument.ImagesPathRelativePathImageSource;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import imcode.util.ImcmsImageUtils;
import imcode.util.ShouldHaveCheckedPermissionsEarlierException;
import imcode.util.Utility;
import imcode.util.image.Format;
import imcode.util.image.ImageInfo;
import imcode.util.io.InputStreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageEditPage
extends OkCancelPage {
    public static final String REQUEST_PARAMETER__GO_TO_IMAGE_SEARCH_BUTTON = "goToImageSearch";
    public static final String REQUEST_PARAMETER__GO_TO_IMAGE_BROWSER_BUTTON = "goToImageBrowser";
    public static final String REQUEST_PARAMETER__GO_TO_ADD_RESTRICTED_IMAGE_BUTTON = "goToAddRestrictedImage";
    public static final String REQUEST_PARAMETER__GO_TO_CROP_IMAGE = "goToCropImage";
    public static final String REQUEST_PARAMETER__PREVIEW_BUTTON = "show_img";
    public static final String REQUEST_PARAMETER__CANCEL_BUTTON = "cancel";
    public static final String REQUEST_PARAMETER__DELETE_BUTTON = "delete";
    public static final String REQUEST_PARAMETER__DOCUMENT_ID = "documentId";
    public static final String REQUEST_PARAMETER__IMAGE_URL = "imageref";
    public static final String REQUEST_PARAMETER__OK_BUTTON = "ok";
    public static final String REQUEST_PARAMETER__IMAGE_HEIGHT = "image_height";
    public static final String REQUEST_PARAMETER__IMAGE_WIDTH = "image_width";
    public static final String REQUEST_PARAMETER__IMAGE_BORDER = "image_border";
    public static final String REQUEST_PARAMETER__VERTICAL_SPACE = "v_space";
    public static final String REQUEST_PARAMETER__HORIZONTAL_SPACE = "h_space";
    public static final String REQUEST_PARAMETER__IMAGE_NAME = "image_name";
    public static final String REQUEST_PARAMETER__IMAGE_ALIGN = "image_align";
    public static final String REQUEST_PARAMETER__IMAGE_ALT = "alt_text";
    public static final String REQUEST_PARAMETER__IMAGE_LOWSRC = "low_scr";
    public static final String REQUEST_PARAMETER__LINK_URL = "imageref_link";
    public static final String REQUEST_PARAMETER__LINK_TARGET = "target";
    public static final String REQUEST_PARAMETER__GO_TO_IMAGE_ARCHIVE_BUTTON = "goToImageArchive";
    public static final String REQUEST_PARAMETER__IMAGE_ARCHIVE = "image_archive";
    public static final String REQUEST_PARAMETER__IMAGE_ARCHIVE_IMAGE_ID = "archive_img_id";
    public static final String REQUEST_PARAMETER__IMAGE_ARCHIVE_IMAGE_NAME = "archive_img_nm";
    public static final String REQUEST_PARAMETER__IMAGE_ARCHIVE_FILE_NAME = "archive_file_nm";
    public static final String REQUEST_PARAMETER__FORMAT = "format";
    public static final String REQUEST_PARAMETER__CROP_X1 = "crop_x1";
    public static final String REQUEST_PARAMETER__CROP_Y1 = "crop_y1";
    public static final String REQUEST_PARAMETER__CROP_X2 = "crop_x2";
    public static final String REQUEST_PARAMETER__CROP_Y2 = "crop_y2";
    static final LocalizedMessage ERROR_MESSAGE__ONLY_ALLOWED_TO_UPLOAD_IMAGES = new LocalizedMessage("error/servlet/images/only_allowed_to_upload_images");
    static final LocalizedMessage ERROR_MESSAGE__FILE_NOT_IMAGE = new LocalizedMessage("error/servlet/images/file_not_image");
    private static final String[] IMAGE_MIME_TYPES = new String[]{"image/jpeg", "image/png", "image/gif"};
    public static final Format[] ALLOWED_FORMATS = new Format[]{Format.GIF, Format.JPEG, Format.PNG};
    private TextDocumentDomainObject document;
    private ImageDomainObject image;
    private Integer imageIndex;
    private String label;
    private final ServletContext servletContext;
    private final Handler<ImageDomainObject> imageCommand;
    private final LocalizedMessage heading;
    private boolean linkable;
    private int forcedWidth;
    private int forcedHeight;

    public ImageEditPage(TextDocumentDomainObject document, ImageDomainObject image, Integer imageIndex, LocalizedMessage heading, String label, ServletContext servletContext, Handler<ImageDomainObject> imageCommand, DispatchCommand returnCommand, boolean linkable, int forcedWidth, int forcedHeight) {
        super(returnCommand, returnCommand);
        this.document = document;
        this.image = image;
        this.imageIndex = imageIndex;
        this.label = label;
        this.servletContext = servletContext;
        this.imageCommand = imageCommand;
        this.heading = heading;
        this.linkable = linkable;
        this.forcedWidth = forcedWidth;
        this.forcedHeight = forcedHeight;
        this.forceWidthHeight();
    }

    private void forceWidthHeight() {
        if (this.image != null) {
            if (this.forcedWidth > 0) {
                this.image.setWidth(this.forcedWidth);
            }
            if (this.forcedHeight > 0) {
                this.image.setHeight(this.forcedHeight);
            }
        }
    }

    public ImageDomainObject getImage() {
        return this.image;
    }

    @Override
    public String getPath(HttpServletRequest request) {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        return "/imcms/" + user.getLanguageIso639_2() + "/jsp/change_img.jsp";
    }

    @Override
    protected void updateFromRequest(HttpServletRequest request) {
        if (request.getParameter(REQUEST_PARAMETER__IMAGE_ARCHIVE) != null) {
            this.getImageFromImageArchive(request);
        } else {
            this.image = this.getImageFromRequest(request);
        }
    }

    public String getLabel() {
        return this.label;
    }

    private void getImageFromImageArchive(HttpServletRequest request) {
        String imageName = StringUtils.trimToNull((String)request.getParameter(REQUEST_PARAMETER__IMAGE_ARCHIVE_IMAGE_NAME));
        imageName = StringUtils.substring((String)imageName, (int)0, (int)40);
        String fileName = StringUtils.trimToNull((String)request.getParameter(REQUEST_PARAMETER__IMAGE_ARCHIVE_FILE_NAME));
        String archiveImageIdStr = StringUtils.trimToNull((String)request.getParameter(REQUEST_PARAMETER__IMAGE_ARCHIVE_IMAGE_ID));
        Long archiveImageId = null;
        if (archiveImageIdStr != null) {
            try {
                archiveImageId = Long.parseLong(archiveImageIdStr, 10);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (fileName != null) {
            fileName = fileName.replaceAll("/|\\\\", "");
            this.setNewSourceAndClearSize(new ImageArchiveImageSource(fileName));
            if (imageName != null) {
                this.image.setName(imageName);
            }
            if (archiveImageId != null) {
                this.image.setArchiveImageId(archiveImageId);
            }
        }
    }

    private ImageDomainObject getImageFromRequest(HttpServletRequest req) {
        ImageDomainObject image = new ImageDomainObject();
        try {
            image.setWidth(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__IMAGE_WIDTH)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setHeight(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__IMAGE_HEIGHT)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setBorder(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__IMAGE_BORDER)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setVerticalSpace(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__VERTICAL_SPACE)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setHorizontalSpace(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__HORIZONTAL_SPACE)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setArchiveImageId(Long.parseLong(req.getParameter(REQUEST_PARAMETER__IMAGE_ARCHIVE_IMAGE_ID)));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        ImageDomainObject.CropRegion region = new ImageDomainObject.CropRegion();
        region.setCropX1(NumberUtils.toInt((String)req.getParameter(REQUEST_PARAMETER__CROP_X1), (int)-1));
        region.setCropY1(NumberUtils.toInt((String)req.getParameter(REQUEST_PARAMETER__CROP_Y1), (int)-1));
        region.setCropX2(NumberUtils.toInt((String)req.getParameter(REQUEST_PARAMETER__CROP_X2), (int)-1));
        region.setCropY2(NumberUtils.toInt((String)req.getParameter(REQUEST_PARAMETER__CROP_Y2), (int)-1));
        region.updateValid();
        image.setCropRegion(region);
        String imageUrl = req.getParameter(REQUEST_PARAMETER__IMAGE_URL);
        if (null != imageUrl && imageUrl.startsWith(req.getContextPath())) {
            imageUrl = imageUrl.substring(req.getContextPath().length());
        }
        ImageSource imageSource = ImcmsImageUtils.createImageSourceFromString(imageUrl);
        image.setSource(imageSource);
        ImageInfo imageInfo = image.getImageInfo();
        image.setFormat(imageInfo != null ? imageInfo.getFormat() : null);
        Format format = Format.findFormat(NumberUtils.toInt((String)req.getParameter(REQUEST_PARAMETER__FORMAT), (int)0));
        if (format != null) {
            image.setFormat(format);
        }
        image.setName(StringUtils.trim((String)req.getParameter(REQUEST_PARAMETER__IMAGE_NAME)));
        image.setAlign(req.getParameter(REQUEST_PARAMETER__IMAGE_ALIGN));
        image.setAlternateText(req.getParameter(REQUEST_PARAMETER__IMAGE_ALT));
        image.setLowResolutionUrl(req.getParameter(REQUEST_PARAMETER__IMAGE_LOWSRC));
        if (this.isLinkable()) {
            image.setTarget(EditDocumentInformationPageFlow.getTargetFromRequest(req, REQUEST_PARAMETER__LINK_TARGET));
            image.setLinkUrl(req.getParameter(REQUEST_PARAMETER__LINK_URL));
        }
        return image;
    }

    @Override
    protected void dispatchOther(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        ImcmsServices imcref = Imcms.getServices();
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        if (null != request.getParameter(REQUEST_PARAMETER__DELETE_BUTTON)) {
            this.image = new ImageDomainObject();
            this.forward(request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__PREVIEW_BUTTON)) {
            this.forward(request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__GO_TO_IMAGE_BROWSER_BUTTON)) {
            this.goToImageBrowser(request, response);
        } else if (request.getParameter(REQUEST_PARAMETER__GO_TO_IMAGE_ARCHIVE_BUTTON) != null) {
            this.goToImageArchive(request, response);
        } else if (request.getParameter(REQUEST_PARAMETER__IMAGE_ARCHIVE) != null) {
            this.forward(request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__GO_TO_IMAGE_SEARCH_BUTTON)) {
            this.goToImageSearch(documentMapper, request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__GO_TO_ADD_RESTRICTED_IMAGE_BUTTON)) {
            this.goToImageAdder(documentMapper, user, request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__GO_TO_CROP_IMAGE)) {
            this.goToCropImage(request, response);
        }
    }

    private void goToImageArchive(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int port = request.getServerPort();
        StringBuilder builder = new StringBuilder();
        builder.append("http://");
        builder.append(request.getServerName());
        if (port != 80) {
            builder.append(":");
            builder.append(port);
        }
        builder.append(request.getContextPath());
        builder.append("/servlet/PageDispatcher?page=");
        builder.append(Utility.encodeUrl(this.getSessionAttributeName()));
        builder.append("&");
        builder.append(REQUEST_PARAMETER__IMAGE_ARCHIVE);
        builder.append("=yes&");
        String imageArchiveUrl = String.format("http://%s?returnTo=%s", Imcms.getServices().getConfig().getImageArchiveUrl(), Utility.encodeUrl(builder.toString()));
        response.sendRedirect(imageArchiveUrl);
    }

    private void goToImageAdder(final DocumentMapper documentMapper, UserDomainObject user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (!user.canCreateDocumentOfTypeIdFromParent(8, this.document)) {
                throw new NoPermissionToCreateDocumentException("User can't create documents from document " + this.document.getId());
            }
            FileDocumentDomainObject fileDocument = (FileDocumentDomainObject)documentMapper.createDocumentOfTypeFromParent(8, this.document, user);
            EditFileDocumentPageFlow.ArrayMimeTypeRestriction mimeTypeRestriction = new EditFileDocumentPageFlow.ArrayMimeTypeRestriction(IMAGE_MIME_TYPES, ERROR_MESSAGE__ONLY_ALLOWED_TO_UPLOAD_IMAGES);
            DocumentPageFlow.SaveDocumentCommand saveNewImageFileDocument = new DocumentPageFlow.SaveDocumentCommand(){

                public void saveDocument(DocumentDomainObject document, UserDomainObject user) throws NoPermissionInternalException, NoPermissionToAddDocumentToMenuException, DocumentSaveException {
                    FileDocumentDomainObject fileDocument = (FileDocumentDomainObject)document;
                    Map files = fileDocument.getFiles();
                    for (FileDocumentDomainObject.FileDocumentFile file : files.values()) {
                        file.setCreatedAsImage(true);
                    }
                    FileDocumentDomainObject.FileDocumentFile file = (FileDocumentDomainObject.FileDocumentFile)files.values().iterator().next();
                    if (null != file) {
                        fileDocument.setHeadline(file.getFilename());
                        fileDocument.setPublicationStatus(Document.PublicationStatus.APPROVED);
                        documentMapper.saveNewDocument(document, user, false);
                        ImageEditPage.this.setNewSourceAndClearSize(new FileDocumentImageSource(documentMapper.getDocumentReference(fileDocument)));
                    }
                }
            };
            DispatchCommand returnToImageEditPageCommand = new DispatchCommand(){

                public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    ImageEditPage.this.forward(request, response);
                }
            };
            EditFileDocumentPageFlow pageFlow = new EditFileDocumentPageFlow(fileDocument, this.servletContext, returnToImageEditPageCommand, saveNewImageFileDocument, mimeTypeRestriction);
            pageFlow.dispatch(request, response);
        }
        catch (NoPermissionToCreateDocumentException e) {
            throw new ShouldHaveCheckedPermissionsEarlierException(e);
        }
    }

    private void goToImageBrowser(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ImageBrowser imageBrowser = new ImageBrowser();
        imageBrowser.setCancelCommand(new DispatchCommand(){

            public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                ImageEditPage.this.forward(request, response);
            }
        });
        imageBrowser.setSelectImageUrlCommand(new ImageBrowser.SelectImageUrlCommand(){

            public void selectImageUrl(String imageUrl, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                ImageEditPage.this.setNewSourceAndClearSize(new ImagesPathRelativePathImageSource(imageUrl));
                ImageEditPage.this.forward(request, response);
            }
        });
        imageBrowser.forward(request, response);
    }

    private void goToCropImage(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DispatchCommand returnCommand = new DispatchCommand(){

            public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                ImageEditPage.this.forward(request, response);
            }
        };
        Handler<ImageDomainObject.CropRegion> cropHandler = new Handler<ImageDomainObject.CropRegion>(){

            @Override
            public void handle(ImageDomainObject.CropRegion cropRegion) {
                ImageEditPage.this.image.setCropRegion(cropRegion);
                ImageEditPage.this.forceWidthHeight();
            }
        };
        ImageCropPage cropPage = new ImageCropPage(returnCommand, cropHandler, this.image, this.forcedWidth, this.forcedHeight);
        cropPage.forward(request, response);
    }

    private void goToImageSearch(final DocumentMapper documentMapper, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DocumentFinder documentFinder = new DocumentFinder(new SearchDocumentsPage());
        documentFinder.setQueryParser(new HeadlineWildcardQueryParser());
        documentFinder.setCancelCommand(new DispatchCommand(){

            public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                ImageEditPage.this.forward(request, response);
            }
        });
        documentFinder.setSelectDocumentCommand(new Handler<Integer>(){

            @Override
            public void handle(Integer documentIdFound) {
                if (null != documentIdFound) {
                    ImageEditPage.this.setNewSourceAndClearSize(new FileDocumentImageSource(documentMapper.getDocumentReference(documentIdFound)));
                }
            }
        });
        documentFinder.setRestrictingQuery(this.createImageFileDocumentsQuery());
        documentFinder.addExtraSearchResultColumn(new AdminManager.DatesSummarySearchResultColumn());
        documentFinder.addExtraSearchResultColumn(new ImageThumbnailSearchResultColumn());
        documentFinder.forward(request, response);
    }

    private void setNewSourceAndClearSize(ImageSource imageSource) {
        this.image.setSourceAndClearSize(imageSource);
        this.image.setFormat(this.image.getImageInfo().getFormat());
        this.image.setCropRegion(new ImageDomainObject.CropRegion());
        this.forceWidthHeight();
        Format imageFormat = this.image.getImageInfo().getFormat();
        boolean allowed = false;
        for (Format allowedFormat : ALLOWED_FORMATS) {
            if (imageFormat != allowedFormat) continue;
            allowed = true;
        }
        this.image.setFormat(allowed ? imageFormat : Format.PNG);
    }

    static boolean userHasImagePermissionsOnDocument(UserDomainObject user, TextDocumentDomainObject document) {
        TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)user.getPermissionSetFor(document);
        return textDocumentPermissionSet.getEditImages();
    }

    private Query createImageFileDocumentsQuery() {
        BooleanQuery imageMimeTypeQuery = new BooleanQuery();
        for (String imageMimeType : IMAGE_MIME_TYPES) {
            imageMimeTypeQuery.add((Query)new TermQuery(new Term("mime_type", imageMimeType)), false, false);
        }
        TermQuery fileDocumentQuery = new TermQuery(new Term("doc_type_id", "8"));
        BooleanQuery booleanQuery = new BooleanQuery();
        booleanQuery.add((Query)fileDocumentQuery, true, false);
        booleanQuery.add((Query)imageMimeTypeQuery, true, false);
        return booleanQuery;
    }

    public static ImageEditPage getFromRequest(HttpServletRequest request) {
        return (ImageEditPage)ImageEditPage.fromRequest(request);
    }

    public LocalizedMessage getHeading() {
        return this.heading;
    }

    public boolean canAddImageFiles(UserDomainObject user) {
        return user.canCreateDocumentOfTypeIdFromParent(8, this.document);
    }

    public static boolean allowImageArchive(UserDomainObject user) {
        List<RoleId> allowedRoleIds = Imcms.getServices().getConfig().getImageArchiveAllowedRoleIdList();
        if (allowedRoleIds != null) {
            for (RoleId roleId : allowedRoleIds) {
                if (!user.hasRoleId(roleId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLinkable() {
        return this.linkable;
    }

    public int getForcedWidth() {
        return this.forcedWidth;
    }

    public void setForcedWidth(int forcedWidth) {
        this.forcedWidth = forcedWidth;
    }

    public int getForcedHeight() {
        return this.forcedHeight;
    }

    public void setForcedHeight(int forcedHeight) {
        this.forcedHeight = forcedHeight;
    }

    public TextDocumentDomainObject getDocument() {
        return this.document;
    }

    public void setImage(ImageDomainObject image) {
        this.image = image;
    }

    public Integer getImageIndex() {
        return this.imageIndex;
    }

    @Override
    protected void dispatchOk(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.imageCommand.handle(this.image);
        super.dispatchOk(request, response);
    }

    private static class ImageThumbnailSearchResultColumn
    implements DocumentFinder.SearchResultColumn {
        private ImageThumbnailSearchResultColumn() {
        }

        public String render(DocumentDomainObject document, HttpServletRequest request, HttpServletResponse response) {
            long fileSize;
            UserDomainObject user = Utility.getLoggedOnUser(request);
            FileDocumentDomainObject imageFileDocument = (FileDocumentDomainObject)document;
            ImageSize imageSize = new ImageSize(0, 0);
            InputStreamSource inputStreamSource = imageFileDocument.getDefaultFile().getInputStreamSource();
            try {
                InputStream inputStream = inputStreamSource.getInputStream();
                fileSize = inputStreamSource.getSize();
                try {
                    imageSize = ImageSize.fromInputStream((InputStream)inputStream);
                }
                catch (IOException ignored) {}
            }
            catch (IOException ioe) {
                throw new UnhandledException((Throwable)ioe);
            }
            List<Object> values = Arrays.asList("imageUrl", "GetDoc?meta_id=" + document.getId(), "imageSize", imageSize, "fileSize", HumanReadable.getHumanReadableByteSize((long)fileSize).replaceAll(" ", "&nbsp;"));
            return Imcms.getServices().getAdminTemplate("images/thumbnail.frag", user, values);
        }

        public LocalizedMessage getName() {
            return new LocalizedMessage("server/src/com/imcode/imcms/servlet/admin/ChangeImage/search/image_thumbnail_label");
        }
    }

    private static class HeadlineWildcardQueryParser
    implements QueryParser {
        private HeadlineWildcardQueryParser() {
        }

        public Query parse(String queryString) {
            String[] queryStrings = StringUtils.split((String)queryString);
            BooleanQuery wildcardsQuery = new BooleanQuery();
            for (String queryTerm : queryStrings) {
                wildcardsQuery.add((Query)new WildcardQuery(new Term("meta_headline", "*" + queryTerm + "*")), true, false);
            }
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add((Query)wildcardsQuery, false, false);
            try {
                booleanQuery.add(new DefaultQueryParser().parse(queryString), false, false);
            }
            catch (ParseException e) {
                // empty catch block
            }
            return booleanQuery;
        }
    }
}

