/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.servlet.ImageCacheManager;
import com.imcode.imcms.servlet.ImageHandling;
import imcode.server.Config;
import imcode.server.Imcms;
import imcode.server.document.textdocument.FileDocumentImageSource;
import imcode.server.document.textdocument.ImageCacheDomainObject;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.ImageSource;
import imcode.util.image.Format;
import imcode.util.image.ImageInfo;
import imcode.util.image.ImageOp;
import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RebuildImageCacheThread
extends Thread {
    private static final Logger log = Logger.getLogger(RebuildImageCacheThread.class);
    private volatile boolean cancelled;
    private long logInterval;

    public RebuildImageCacheThread(long logInterval) {
        super("RebuildImageCache");
        this.logInterval = logInterval;
    }

    @Override
    public void run() {
        Config config = Imcms.getServices().getConfig();
        Map<Integer, Map<Integer, ImageDomainObject>> documentImages = Imcms.getServices().getImageCacheMapper().getAllDocumentImages();
        int documentImagesCount = RebuildImageCacheThread.getDocumentImagesCount(documentImages);
        log.info((Object)String.format("Beginning to cache %d images", documentImagesCount));
        int currentImage = 0;
        long lastLogTime = System.currentTimeMillis();
        for (Integer metaId : documentImages.keySet()) {
            Map<Integer, ImageDomainObject> images = documentImages.get(metaId);
            if (this.cancelled) {
                return;
            }
            for (Integer imageIndex : images.keySet()) {
                long currentTime;
                if (this.cancelled) {
                    return;
                }
                ++currentImage;
                ImageDomainObject imageDomainObject = images.get(imageIndex);
                try {
                    RebuildImageCacheThread.cacheImage(metaId, imageIndex, imageDomainObject, config);
                }
                catch (Exception ex) {
                    log.warn((Object)String.format("Failed to create cache of image, meta_id: %d, image_index: %d", metaId, imageIndex), (Throwable)ex);
                }
                if ((currentTime = System.currentTimeMillis()) - lastLogTime < this.logInterval) continue;
                lastLogTime = currentTime;
                int progress = (int)((double)((float)currentImage / (float)documentImagesCount) * 100.0);
                log.info((Object)String.format("Progress: %d%%", progress));
            }
        }
    }

    private static int getDocumentImagesCount(Map<Integer, Map<Integer, ImageDomainObject>> documentImages) {
        int total = 0;
        for (Map<Integer, ImageDomainObject> images : documentImages.values()) {
            total += images.values().size();
        }
        return total;
    }

    private static void cacheImage(Integer metaId, Integer imageIndex, ImageDomainObject imageDomainObject, Config config) {
        ImageSource imageSource = imageDomainObject.getSource();
        int fileId = 0;
        String path = null;
        if (imageSource instanceof FileDocumentImageSource) {
            fileId = ((FileDocumentImageSource)imageSource).getFileDocument().getId();
        } else {
            path = imageDomainObject.getUrlPathRelativeToContextPath();
        }
        Format format = imageDomainObject.getFormat();
        if (format == null || !format.isWritable()) {
            format = Format.PNG;
        }
        ImageCacheDomainObject imageCacheObject = ImageHandling.createImageCacheObject(path, null, fileId, metaId, imageIndex, format, imageDomainObject.getWidth(), imageDomainObject.getHeight(), imageDomainObject.getCropRegion());
        File imageFile = null;
        boolean deleteFile = false;
        if (path != null) {
            imageFile = ImageHandling.getLocalFile(path);
        } else if (fileId > 0) {
            imageFile = ImageHandling.getFileDocument(fileId);
            deleteFile = true;
        }
        ImageInfo imageInfo = ImageOp.getImageInfo(config, imageFile);
        if (imageInfo == null) {
            log.warn((Object)String.format("Failed to create cache of image, meta_id: %d, image_index: %d. Not an image", metaId, imageIndex));
            if (deleteFile) {
                imageFile.delete();
            }
            return;
        }
        File cacheFile = ImageCacheManager.storeImage(imageCacheObject, imageFile, deleteFile);
        if (cacheFile == null) {
            log.warn((Object)String.format("Failed to create cache of image, meta_id: %d, image_index: %d", metaId, imageIndex));
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

