/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.servlet.RebuildImageCacheThread;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class RebuildImageCache
extends HttpServlet {
    private static final long LOG_PROGRESS_INTERVAL_MILLISECONDS = 60000L;
    private static RebuildImageCacheThread rebuildThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        if (!cms.getCurrentUser().isSuperAdmin()) {
            response.sendError(403);
            return;
        }
        boolean stop = request.getParameter("stop") != null;
        String message = null;
        Class<RebuildImageCache> clazz = RebuildImageCache.class;
        synchronized (RebuildImageCache.class) {
            if (stop) {
                if (rebuildThread != null && rebuildThread.isAlive()) {
                    rebuildThread.setCancelled(true);
                    rebuildThread.interrupt();
                    rebuildThread = null;
                    message = "Image cache rebuild has been stopped";
                } else {
                    message = "Image cache rebuild wasn't running";
                }
            } else if (rebuildThread == null || !rebuildThread.isAlive()) {
                rebuildThread = new RebuildImageCacheThread(60000L);
                rebuildThread.start();
                message = "Image cache rebuild has been started";
            } else {
                message = "Image cache rebuild is already running";
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            byte[] data = message.getBytes("UTF-8");
            response.setContentType("text/plain");
            response.setCharacterEncoding("UTF-8");
            response.setContentLength(data.length);
            ServletOutputStream output = null;
            try {
                output = response.getOutputStream();
                output.write(data);
                output.flush();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
            return;
        }
    }
}

