/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.util.rss.Rss20DocumentFactory;
import com.imcode.imcms.util.rss.imcms.DocumentMenuChannel;
import imcode.util.Utility;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class MenuRss
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(MenuRss.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
            int documentId = Integer.parseInt(request.getParameter("meta_id"));
            int menuIndex = Integer.parseInt(request.getParameter("menu_index"));
            DocumentService documentService = cms.getDocumentService();
            TextDocument document = documentService.getTextDocument(documentId);
            if (null == document) {
                response.sendError(404);
            } else {
                Rss20DocumentFactory rssDocumentFactory = new Rss20DocumentFactory();
                DocumentMenuChannel documentMenuChannel = new DocumentMenuChannel(document, this.getUrlRoot(request), menuIndex);
                Document xmlDocument = rssDocumentFactory.createRssDocument(documentMenuChannel);
                Utility.outputXmlDocument(response, xmlDocument);
            }
        }
        catch (NoPermissionException e) {
            LOG.debug((Object)"Forbidden.", (Throwable)e);
            response.sendError(403);
        }
        catch (ClassCastException nfe) {
            LOG.debug((Object)"Forbidden.", (Throwable)nfe);
            response.sendError(403);
        }
        catch (NumberFormatException nfe) {
            response.sendError(400);
        }
    }

    private String getUrlRoot(HttpServletRequest request) {
        return StringUtils.substringBefore((String)request.getRequestURL().toString(), (String)"/servlet/");
    }
}

